/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.util.logging;

import org.eclipse.birt.data.oda.util.logging.Filter;
import org.eclipse.birt.data.oda.util.logging.Level;
import org.eclipse.birt.data.oda.util.logging.LogFormatter;
import org.eclipse.birt.data.oda.util.logging.LogRecord;
import org.eclipse.birt.data.oda.util.logging.LoggingErrorHandler;

public abstract class Handler {
    private LoggingErrorHandler m_errorHandler;
    private Filter m_filter;
    private LogFormatter m_formatter;
    private Level m_level;

    protected Handler() {
    }

    public abstract void close();

    public abstract void flush();

    public abstract void publish(LogRecord var1);

    public boolean isLoggable(LogRecord record) {
        return record.getLevel().intValue() >= this.m_level.intValue() && this.m_level.intValue() <= 1000 && (this.m_filter == null || this.m_filter.isLoggable(record));
    }

    protected void reportError(String message, Exception exception, int errorCode) {
        if (this.m_errorHandler != null) {
            this.m_errorHandler.error(message, exception, errorCode);
        }
    }

    public void setLoggingErrorHandler(LoggingErrorHandler errorHandler) {
        this.m_errorHandler = errorHandler;
    }

    public LoggingErrorHandler getLoggingErrorHandler() {
        return this.m_errorHandler;
    }

    public void setFilter(Filter filter) {
        this.m_filter = filter;
    }

    public Filter getFilter() {
        return this.m_filter;
    }

    public void setFormatter(LogFormatter formatter) {
        if (formatter == null) {
            throw new NullPointerException();
        }
        this.m_formatter = formatter;
    }

    public LogFormatter getFormatter() {
        return this.m_formatter;
    }

    public void setLevel(Level level) {
        this.m_level = level;
    }

    public Level getLevel() {
        return this.m_level;
    }
}

