/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.util.logging;

import org.eclipse.birt.data.oda.util.logging.FileHandler;
import org.eclipse.birt.data.oda.util.logging.Handler;
import org.eclipse.birt.data.oda.util.logging.Level;
import org.eclipse.birt.data.oda.util.logging.LogRecord;

public class Logger {
    private String m_loggerName;
    private Level m_level;
    private Handler m_handler;

    private Logger() {
        this.m_loggerName = "global";
        this.m_level = Level.OFF_LEVEL;
    }

    protected Logger(String loggerName) {
        this.m_loggerName = loggerName;
        this.m_level = Level.OFF_LEVEL;
    }

    public void severe(Throwable thrown) {
        this.log(Level.SEVERE_LEVEL, thrown);
    }

    public void severe(String message) {
        this.log(Level.SEVERE_LEVEL, message);
    }

    public void warning(String message) {
        this.log(Level.WARNING_LEVEL, message);
    }

    public void info(String message) {
        this.log(Level.INFO_LEVEL, message);
    }

    public void config(String message) {
        this.log(Level.CONFIG_LEVEL, message);
    }

    public void fine(String message) {
        this.log(Level.FINE_LEVEL, message);
    }

    public void finer(String message) {
        this.log(Level.FINER_LEVEL, message);
    }

    public void finest(String message) {
        this.log(Level.FINEST_LEVEL, message);
    }

    public void log(Level level, String message) {
        if (this.isLoggable(level) && this.m_handler != null) {
            LogRecord record = new LogRecord(level, message);
            this.m_handler.publish(record);
        }
    }

    public void log(Level level, Throwable thrown) {
        if (this.isLoggable(level) && this.m_handler != null) {
            LogRecord record = new LogRecord(level, "");
            record.setThrown(thrown);
            this.m_handler.publish(record);
        }
    }

    public Level getLevel() {
        return this.m_level;
    }

    public void setLevel(Level level) {
        this.m_level = level;
        if (this.m_handler != null) {
            this.m_handler.setLevel(this.m_level);
        }
    }

    public String getName() {
        return this.m_loggerName;
    }

    protected Handler getHandler() {
        return this.m_handler;
    }

    protected void setHandler(Handler handler) {
        if (this.m_handler != null && this.m_handler != handler) {
            this.m_handler.close();
        }
        this.m_handler = handler;
        this.m_handler.setLevel(this.m_level);
    }

    public boolean isLoggable(Level level) {
        return level.intValue() >= this.m_level.intValue() && this.m_level.intValue() <= 1000;
    }

    void changeLogFile(String filename) {
        if (this.m_handler != null) {
            this.m_handler.close();
            ((FileHandler)this.m_handler).setOutputFile(filename);
        } else {
            this.m_handler = new FileHandler(filename);
        }
    }
}

