/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.logging.Logger;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.impl.DataEngineContextExt;

public class BasicCachedList
implements List {
    protected static final int NULL_VALUE = Integer.MAX_VALUE;
    protected static final int OBJECT_VALUE = 1;
    protected static final int CACHESIZE = 4000;
    private static Logger logger = Logger.getLogger(BasicCachedList.class.getName());
    private int currentCacheNo = 0;
    private List currentCache;
    private String fileNamePrefix;
    private int size = 0;
    private List fileList = new ArrayList();
    private File dir;

    public BasicCachedList() {
        this.setFileNamePrefix();
        this.currentCache = new ArrayList();
    }

    private void setFileNamePrefix() {
        this.fileNamePrefix = "CachedList_" + new Long(System.currentTimeMillis()).toString() + "_" + Integer.toHexString(this.hashCode());
    }

    public BasicCachedList(List list) {
        this();
        if (list == null) {
            return;
        }
        for (int i = 0; i < list.size(); ++i) {
            this.add(list.get(i));
        }
    }

    public boolean add(Object o) {
        if (this.currentCache.size() >= 4000) {
            this.saveToDisk();
            this.currentCache.clear();
            ++this.currentCacheNo;
        }
        this.currentCache.add(o);
        ++this.size;
        return true;
    }

    private void saveToDisk() {
        try {
            File cacheFile = null;
            if (this.currentCacheNo < this.fileList.size()) {
                cacheFile = (File)this.fileList.get(this.currentCacheNo);
            } else {
                cacheFile = this.getCacheFile(this.currentCacheNo);
                this.fileList.add(cacheFile);
            }
            FileOutputStream fos = new FileOutputStream(cacheFile);
            DataOutputStream oos = new DataOutputStream(new BufferedOutputStream(fos));
            this.writeList(oos, this.currentCache);
            oos.close();
        }
        catch (FileNotFoundException e) {
            logger.severe("Exception happened when save data to disk in CachedList. Exception message: " + e.toString());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.severe("Exception happened when save data to disk in CachedList. Exception message: " + e.toString());
            e.printStackTrace();
        }
    }

    private void writeList(DataOutputStream oos, List list) throws IOException {
        IOUtil.writeInt((OutputStream)oos, (int)list.size());
        for (int i = 0; i < list.size(); ++i) {
            this.writeObject(oos, list.get(i));
        }
    }

    protected void writeObject(DataOutputStream oos, Object object) throws IOException {
        if (object == null) {
            IOUtil.writeInt((OutputStream)oos, (int)Integer.MAX_VALUE);
            return;
        }
        IOUtil.writeInt((OutputStream)oos, (int)1);
        IOUtil.writeObject((DataOutputStream)oos, (Object)object);
    }

    public Object get(int index) {
        this.RangeCheck(index);
        if (index / 4000 != this.currentCacheNo) {
            this.saveToDisk();
            this.currentCacheNo = index / 4000;
            this.loadFromDisk();
        }
        return this.currentCache.get(index - this.currentCacheNo * 4000);
    }

    private void loadFromDisk() {
        try {
            FileInputStream fis = new FileInputStream(this.getCacheFile(this.currentCacheNo));
            DataInputStream ois = new DataInputStream(new BufferedInputStream(fis));
            this.currentCache = this.readList(ois);
            ois.close();
        }
        catch (FileNotFoundException e) {
            logger.severe("Exception happened when load data from disk in CachedList. Exception message: " + e.toString());
            e.printStackTrace();
        }
        catch (IOException e) {
            logger.severe("Exception happened when load data from disk in CachedList. Exception message: " + e.toString());
            e.printStackTrace();
        }
    }

    private List readList(DataInputStream dis) throws IOException {
        ArrayList<Object> reList = new ArrayList<Object>();
        int objectCount = IOUtil.readInt((InputStream)dis);
        for (int i = 0; i < objectCount; ++i) {
            reList.add(this.readObject(dis));
        }
        return reList;
    }

    protected Object readObject(DataInputStream dis) throws IOException {
        int fieldCount = IOUtil.readInt((InputStream)dis);
        if (fieldCount == Integer.MAX_VALUE) {
            return null;
        }
        return IOUtil.readObject((DataInputStream)dis);
    }

    private File getCacheFile(int cacheIndex) {
        String tempDirStr = DataEngineContextExt.getInstance().getTmpdir() + File.separatorChar + this.fileNamePrefix;
        if (this.dir == null) {
            this.dir = new File(tempDirStr);
            this.dir.mkdir();
        }
        return new File(tempDirStr + File.separatorChar + cacheIndex + ".tmp");
    }

    public int size() {
        return this.size;
    }

    public void add(int index, Object element) {
        throw new UnsupportedOperationException("add( int index, Object element ) method in CacheList is not supported!");
    }

    public boolean addAll(Collection c) {
        throw new UnsupportedOperationException("addAll method in CacheList is not supported!");
    }

    public boolean addAll(int index, Collection c) {
        throw new UnsupportedOperationException("addAll method in CacheList is not supported!");
    }

    public void clear() {
        this.clearTempDir();
        this.currentCacheNo = 0;
        this.size = 0;
        this.setFileNamePrefix();
        this.currentCache = new ArrayList();
    }

    public boolean contains(Object o) {
        throw new UnsupportedOperationException("the contains( Object o ) method in CacheList is not supported!");
    }

    public boolean containsAll(Collection c) {
        throw new UnsupportedOperationException("the containsAll( Collection c ) method in CacheList is not supported!");
    }

    public int indexOf(Object o) {
        throw new UnsupportedOperationException("the indexOf( Object o ) method in CacheList is not supported!");
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("the isEmpty( ) method in CacheList is not supported!");
    }

    public Iterator iterator() {
        throw new UnsupportedOperationException("the iterator( ) method in CacheList is not supported!");
    }

    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("the lastIndexOf( Object o ) method in CacheList is not supported!");
    }

    public ListIterator listIterator() {
        throw new UnsupportedOperationException("the listIterator( ) method in CacheList is not supported!");
    }

    public ListIterator listIterator(int index) {
        throw new UnsupportedOperationException("the listIterator( int index ) method in CacheList is not supported!");
    }

    public Object remove(int index) {
        throw new UnsupportedOperationException("the remove( int index ) method in CacheList is not supported!");
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("the remove( Object o ) method in CacheList is not supported!");
    }

    public boolean removeAll(Collection c) {
        throw new UnsupportedOperationException("the removeAll( Collection c ) method in CacheList is not supported!");
    }

    public boolean retainAll(Collection c) {
        throw new UnsupportedOperationException("the retainAll( Collection c ) method in CacheList is not supported!");
    }

    public Object set(int index, Object element) {
        this.RangeCheck(index);
        Object oldValue = this.get(index);
        this.currentCache.set(index - this.currentCacheNo * 4000, element);
        return oldValue;
    }

    private void RangeCheck(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
        }
    }

    public List subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException("the subList( int fromIndex, int toIndex ) method in CacheList is not supported!");
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException("method in CacheList is not supported!");
    }

    public Object[] toArray(Object[] a) {
        throw new UnsupportedOperationException("method in CacheList is not supported!");
    }

    public void clearTempDir() {
        for (int i = 0; i < this.fileList.size(); ++i) {
            File file = (File)this.fileList.get(i);
            if (!file.exists()) continue;
            file.delete();
        }
        this.fileList.clear();
        if (this.dir != null && this.dir.exists()) {
            this.dir.delete();
            this.dir = null;
        }
    }

    public void finalize() {
        this.clearTempDir();
    }
}

