/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClassHelper;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.cache.ResultSetUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class ResultClass
implements IResultClass {
    private ResultFieldMetadata[] projectedCols;
    private int m_fieldCount;
    private HashMap nameToIdMapping;
    private String[] fieldNames;
    private int[] fieldDriverPositions;
    private ResultClassHelper resultClassHelper;
    private boolean hasAny;
    private List originalAnyTypeField;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ResultClass(List projectedColumns) {
        if (!$assertionsDisabled && projectedColumns == null) {
            throw new AssertionError();
        }
        this.initColumnsInfo(projectedColumns);
    }

    private void initColumnsInfo(List projectedColumns) {
        this.m_fieldCount = projectedColumns.size();
        this.projectedCols = new ResultFieldMetadata[this.m_fieldCount];
        this.nameToIdMapping = new HashMap();
        this.originalAnyTypeField = new ArrayList();
        int n = projectedColumns.size();
        for (int i = 0; i < n; ++i) {
            String upperCaseAlias;
            this.projectedCols[i] = (ResultFieldMetadata)projectedColumns.get(i);
            ResultFieldMetadata column = this.projectedCols[i];
            if (this.isOfAnyType(column)) {
                this.hasAny = true;
                this.originalAnyTypeField.add(new Integer(i + 1));
            }
            String upperCaseName = column.getName();
            Integer index = new Integer(i + 1);
            if (!this.nameToIdMapping.containsKey(upperCaseName)) {
                this.nameToIdMapping.put(upperCaseName, index);
            }
            if ((upperCaseAlias = column.getAlias()) == null || upperCaseAlias.length() <= 0 || this.nameToIdMapping.containsKey(upperCaseAlias)) continue;
            this.nameToIdMapping.put(upperCaseAlias, index);
        }
    }

    private boolean isOfAnyType(ResultFieldMetadata column) {
        return column.getDataType().getName().equals(DataType.AnyType.class.getName());
    }

    public ResultClass(InputStream inputStream) throws DataException {
        if (!$assertionsDisabled && inputStream == null) {
            throw new AssertionError();
        }
        DataInputStream dis = new DataInputStream(inputStream);
        try {
            ArrayList<ResultFieldMetadata> newProjectedColumns = new ArrayList<ResultFieldMetadata>();
            int size = IOUtil.readInt((InputStream)dis);
            for (int i = 0; i < size; ++i) {
                int driverPos = IOUtil.readInt((InputStream)dis);
                String name = IOUtil.readString((DataInputStream)dis);
                String lable = IOUtil.readString((DataInputStream)dis);
                String alias = IOUtil.readString((DataInputStream)dis);
                String dtName = IOUtil.readString((DataInputStream)dis);
                String ntName = IOUtil.readString((DataInputStream)dis);
                boolean bool = IOUtil.readBool((InputStream)dis);
                String dpdpName = IOUtil.readString((DataInputStream)dis);
                ResultFieldMetadata metaData = new ResultFieldMetadata(driverPos, name, lable, Class.forName(dtName), ntName, bool);
                metaData.setAlias(alias);
                if (dpdpName != null) {
                    metaData.setDriverProvidedDataType(Class.forName(dpdpName));
                }
                newProjectedColumns.add(metaData);
            }
            dis.close();
            this.initColumnsInfo(newProjectedColumns);
        }
        catch (ClassNotFoundException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Class");
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Class");
        }
    }

    public void doSave(OutputStream outputStream, Map requestColumnMap) throws DataException {
        if (!$assertionsDisabled && outputStream == null) {
            throw new AssertionError();
        }
        DataOutputStream dos = new DataOutputStream(outputStream);
        Set resultSetNameSet = ResultSetUtil.getRsColumnRequestMap(requestColumnMap);
        int size = resultSetNameSet.size();
        try {
            IOUtil.writeInt((OutputStream)outputStream, (int)size);
            int writeCount = 0;
            for (int i = 0; i < this.m_fieldCount; ++i) {
                ResultFieldMetadata column = this.projectedCols[i];
                if (!resultSetNameSet.contains(column.getName()) && !resultSetNameSet.contains(column.getAlias())) continue;
                IOUtil.writeInt((OutputStream)dos, (int)column.getDriverPosition());
                IOUtil.writeString((DataOutputStream)dos, (String)column.getName());
                IOUtil.writeString((DataOutputStream)dos, (String)column.getLabel());
                IOUtil.writeString((DataOutputStream)dos, (String)column.getAlias());
                IOUtil.writeString((DataOutputStream)dos, (String)column.getDataType().getName());
                IOUtil.writeString((DataOutputStream)dos, (String)column.getNativeTypeName());
                IOUtil.writeBool((OutputStream)dos, (boolean)column.isCustom());
                if (column.getDriverProvidedDataType() == null) {
                    IOUtil.writeString((DataOutputStream)dos, null);
                } else {
                    IOUtil.writeString((DataOutputStream)dos, (String)column.getDriverProvidedDataType().getName());
                }
                ++writeCount;
            }
            if (writeCount != size) {
                throw new DataException("data.engine.resultClassSaveError");
            }
            dos.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Class");
        }
    }

    public int getFieldCount() {
        return this.m_fieldCount;
    }

    public String[] getFieldNames() {
        return this.doGetFieldNames();
    }

    private String[] doGetFieldNames() {
        if (this.fieldNames == null) {
            int size = this.m_fieldCount;
            this.fieldNames = new String[size];
            for (int i = 0; i < size; ++i) {
                this.fieldNames[i] = this.projectedCols[i].getName();
            }
        }
        return this.fieldNames;
    }

    public int[] getFieldDriverPositions() {
        if (this.fieldDriverPositions == null) {
            int size = this.m_fieldCount;
            this.fieldDriverPositions = new int[size];
            for (int i = 0; i < size; ++i) {
                ResultFieldMetadata column = this.projectedCols[i];
                this.fieldDriverPositions[i] = column.getDriverPosition();
            }
        }
        return this.fieldDriverPositions;
    }

    public String getFieldName(int index) throws DataException {
        return this.projectedCols[index - 1].getName();
    }

    public String getFieldAlias(int index) throws DataException {
        return this.projectedCols[index - 1].getAlias();
    }

    public int getFieldIndex(String fieldName) {
        Integer i = (Integer)this.nameToIdMapping.get(fieldName);
        return i == null ? -1 : i;
    }

    private int doGetFieldIndex(String fieldName) throws DataException {
        int index = this.getFieldIndex(fieldName);
        if (index <= 0) {
            throw new DataException("data.engine.InvalidFieldName", fieldName);
        }
        return index;
    }

    public Class getFieldValueClass(String fieldName) throws DataException {
        int index = this.doGetFieldIndex(fieldName);
        return this.getFieldValueClass(index);
    }

    public Class getFieldValueClass(int index) throws DataException {
        return this.projectedCols[index - 1].getDataType();
    }

    public boolean isCustomField(String fieldName) throws DataException {
        int index = this.doGetFieldIndex(fieldName);
        return this.isCustomField(index);
    }

    public boolean isCustomField(int index) throws DataException {
        return this.projectedCols[index - 1].isCustom();
    }

    public String getFieldLabel(int index) throws DataException {
        return this.projectedCols[index - 1].getLabel();
    }

    public String getFieldNativeTypeName(int index) throws DataException {
        return this.projectedCols[index - 1].getNativeTypeName();
    }

    public ResultFieldMetadata getFieldMetaData(int index) throws DataException {
        return this.projectedCols[index - 1];
    }

    public boolean hasClobOrBlob() throws DataException {
        return this.getResultClasstHelper().hasClobOrBlob();
    }

    public int[] getClobFieldIndexes() throws DataException {
        return this.getResultClasstHelper().getClobIndexArray();
    }

    public int[] getBlobFieldIndexes() throws DataException {
        return this.getResultClasstHelper().getBlobIndexArray();
    }

    public ResultClassHelper getResultClasstHelper() throws DataException {
        if (this.resultClassHelper == null) {
            this.resultClassHelper = new ResultClassHelper(this);
        }
        return this.resultClassHelper;
    }

    public boolean hasAnyTYpe() throws DataException {
        if (this.hasAny) {
            for (int i = 0; i < this.projectedCols.length; ++i) {
                if (!this.isOfAnyType(this.projectedCols[i])) continue;
                return this.hasAny;
            }
            this.hasAny = false;
        }
        return this.hasAny;
    }

    public boolean wasAnyType(String name) throws DataException {
        Iterator it = this.originalAnyTypeField.iterator();
        while (it.hasNext()) {
            int index = (Integer)it.next();
            if (!this.getFieldName(index).equals(name) && !this.getFieldAlias(index).equals(name)) continue;
            return true;
        }
        return false;
    }

    public boolean wasAnyType(int index) {
        Iterator it = this.originalAnyTypeField.iterator();
        while (it.hasNext()) {
            if (index != (Integer)it.next()) continue;
            return true;
        }
        return false;
    }

    static {
        $assertionsDisabled = !ResultClass.class.desiredAssertionStatus();
    }
}

