/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache;

import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.logging.Logger;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngine;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.cache.SortSpec;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class CacheUtil {
    private static String TEST_MEM_BUFFER_SIZE = "birt.data.engine.test.memcachesize";
    private static Integer cacheCounter1 = new Integer(0);
    private static Integer cacheCounter2 = new Integer(0);
    private String tempDir;

    public CacheUtil(String tempDir) {
        this.tempDir = tempDir;
    }

    static int computeMemoryBufferSize(Map appContext) throws DataException {
        if (appContext == null) {
            return 0xA00000;
        }
        if (appContext.get(TEST_MEM_BUFFER_SIZE) != null) {
            return CacheUtil.populateMemBufferSize(appContext.get(TEST_MEM_BUFFER_SIZE));
        }
        return CacheUtil.populateMemBufferSize(appContext.get(DataEngine.MEMORY_BUFFER_SIZE)) * 1024 * 1024;
    }

    private static int populateMemBufferSize(Object propValue) throws DataException {
        String targetBufferSize = propValue == null ? "1" : propValue.toString();
        int memoryCacheSize = 10;
        if (targetBufferSize != null) {
            memoryCacheSize = Integer.parseInt(targetBufferSize);
        }
        if (memoryCacheSize <= 0) {
            throw new DataException("data.engine.invalidMemBufferSize", new Object[]{new Integer(memoryCacheSize)});
        }
        return memoryCacheSize;
    }

    static Comparator getComparator(SortSpec sortSpec, final IEventHandler eventHandler) {
        if (sortSpec == null) {
            return null;
        }
        final int[] sortKeyIndexes = sortSpec.sortKeyIndexes;
        final String[] sortKeyColumns = sortSpec.sortKeyColumns;
        if (sortKeyIndexes == null || sortKeyIndexes.length == 0) {
            return null;
        }
        final boolean[] sortAscending = sortSpec.sortAscending;
        Comparator comparator = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                IResultObject row1 = (IResultObject)obj1;
                IResultObject row2 = (IResultObject)obj2;
                for (int i = 0; i < sortKeyIndexes.length; ++i) {
                    int colIndex = sortKeyIndexes[i];
                    String colName = sortKeyColumns[i];
                    try {
                        Object colObj1 = null;
                        Object colObj2 = null;
                        if (eventHandler != null) {
                            colObj1 = eventHandler.getValue(row1, colIndex, colName);
                            colObj2 = eventHandler.getValue(row2, colIndex, colName);
                        } else {
                            colObj1 = row1.getFieldValue(colIndex);
                            colObj2 = row2.getFieldValue(colIndex);
                        }
                        int result = CacheUtil.compareObjects(colObj1, colObj2);
                        if (result == 0) continue;
                        return sortAscending[i] ? result : -result;
                    }
                    catch (DataException e) {
                        // empty catch block
                    }
                }
                return 0;
            }
        };
        return comparator;
    }

    public static int compareObjects(Object ob1, Object ob2) {
        int result = 0;
        if (ob1 == ob2) {
            return result;
        }
        if (ob1 == null || ob2 == null) {
            result = ob1 == null ? -1 : 1;
            return result;
        }
        if (ob1.equals(ob2)) {
            return result;
        }
        if (ob1 instanceof Comparable && ob2 instanceof Comparable) {
            Comparable comp1 = (Comparable)ob1;
            Comparable comp2 = (Comparable)ob2;
            if (ob1.getClass() != ob2.getClass()) {
                try {
                    if (ob1 instanceof Number && ob2 instanceof Number) {
                        comp1 = DataTypeUtil.toDouble((Object)ob1);
                        comp2 = DataTypeUtil.toDouble((Object)ob2);
                    } else if (ob1 instanceof Date && ob2 instanceof Date) {
                        comp1 = DataTypeUtil.toDate((Object)ob1);
                        comp2 = DataTypeUtil.toDate((Object)ob1);
                    }
                }
                catch (BirtException ex) {
                    // empty catch block
                }
            }
            result = comp1.compareTo(comp2);
        } else if (ob1 instanceof Boolean && ob2 instanceof Boolean) {
            Boolean bool = (Boolean)ob1;
            result = bool.equals(Boolean.TRUE) ? 1 : -1;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doCreateTempRootDir(Logger logger) {
        String rootDirStr = null;
        File tempDtEDir = null;
        Integer n = cacheCounter1;
        synchronized (n) {
            tempDtEDir = new File(this.tempDir, "BirtDataTemp" + System.currentTimeMillis() + cacheCounter1);
            cacheCounter1 = new Integer(cacheCounter1 + 1);
            int x = 0;
            while (tempDtEDir.exists()) {
                tempDtEDir = new File(this.tempDir, "BirtDataTemp" + System.currentTimeMillis() + cacheCounter1 + "_" + ++x);
            }
            tempDtEDir.mkdir();
            tempDtEDir.deleteOnExit();
        }
        try {
            rootDirStr = tempDtEDir.getCanonicalPath();
        }
        catch (IOException e) {
            // empty catch block
        }
        logger.info("Temp directory used to cache data is " + rootDirStr);
        return rootDirStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSessionTempDir(String tempRootDirStr) {
        String sessionTempDirStr;
        String prefix = "session_";
        Integer n = cacheCounter2;
        synchronized (n) {
            sessionTempDirStr = tempRootDirStr + File.separator + "session_" + System.currentTimeMillis() + cacheCounter2;
            cacheCounter2 = new Integer(cacheCounter2 + 1);
            File file = new File(sessionTempDirStr);
            int i = 0;
            while (file.exists() || !file.mkdir()) {
                sessionTempDirStr = sessionTempDirStr + "_" + ++i;
                file = new File(sessionTempDirStr);
            }
        }
        return sessionTempDirStr;
    }

    public static SortSpec getSortSpec(IResultClass rsMeta) {
        int fieldCount = rsMeta.getFieldCount();
        int[] sortKeyIndexs = new int[fieldCount];
        String[] sortKeyNames = new String[fieldCount];
        boolean[] ascending = new boolean[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            sortKeyIndexs[i] = i + 1;
            ascending[i] = true;
        }
        return new SortSpec(sortKeyIndexs, sortKeyNames, ascending);
    }
}

