/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.cache.disk;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.birt.data.engine.executor.cache.disk.MergeSortInfo;
import org.eclipse.birt.data.engine.odi.IResultObject;

class MergeSortUtil {
    private Comparator comparator;
    static final /* synthetic */ boolean $assertionsDisabled;

    MergeSortUtil() {
    }

    static MergeSortUtil getUtil(Comparator comparator) {
        if (!$assertionsDisabled && comparator == null) {
            throw new AssertionError();
        }
        MergeSortUtil instance = new MergeSortUtil();
        instance.comparator = comparator;
        return instance;
    }

    void sortSelf(IResultObject[] self) {
        Comparator comparator = new Comparator(){

            public int compare(Object obj1, Object obj2) {
                IResultObject data1 = (IResultObject)obj1;
                IResultObject data2 = (IResultObject)obj2;
                return MergeSortUtil.this.compareResultObject(data1, data2);
            }
        };
        Arrays.sort(self, comparator);
    }

    public int getMinResultObject(IResultObject[] objects, int length) {
        IResultObject minObject = null;
        int minObjectPos = -1;
        for (int i = 0; i < length; ++i) {
            if (objects[i] == null || minObject != null && this.compareResultObject(minObject, objects[i]) <= 0) continue;
            minObject = objects[i];
            minObjectPos = i;
        }
        return minObjectPos;
    }

    MergeSortInfo mergeSort(IResultObject[][] resultObjects, IResultObject[] sortedResultObjects) {
        int mergeCount = resultObjects.length;
        int[] indexOfAllUnits = new int[mergeCount];
        boolean[] validUnit = new boolean[mergeCount];
        int realMergeCount = 0;
        IResultObject[][] toBeSortData = new IResultObject[mergeCount][];
        for (int i = 0; i < mergeCount; ++i) {
            if (resultObjects[i].length <= 0) continue;
            toBeSortData[realMergeCount++] = resultObjects[i];
            validUnit[i] = true;
        }
        int totalCount = 0;
        int[] indexOfUnit = new int[realMergeCount];
        boolean isDone = false;
        while (!isDone) {
            int indexUnitOfMinValue = 0;
            IResultObject minSortData = toBeSortData[indexUnitOfMinValue][indexOfUnit[indexUnitOfMinValue]];
            for (int i = 1; i < realMergeCount; ++i) {
                if (this.compareResultObject(minSortData, toBeSortData[i][indexOfUnit[i]]) <= 0) continue;
                indexUnitOfMinValue = i;
                minSortData = toBeSortData[indexUnitOfMinValue][indexOfUnit[indexUnitOfMinValue]];
            }
            sortedResultObjects[totalCount++] = minSortData;
            int n = indexUnitOfMinValue;
            indexOfUnit[n] = indexOfUnit[n] + 1;
            if (toBeSortData[indexUnitOfMinValue].length != indexOfUnit[indexUnitOfMinValue]) continue;
            isDone = true;
        }
        int j = 0;
        for (int i = 0; i < mergeCount; ++i) {
            indexOfAllUnits[i] = validUnit[i] ? indexOfUnit[j++] : 0;
        }
        return new MergeSortInfo(totalCount, indexOfAllUnits);
    }

    private int compareResultObject(IResultObject resultObject1, IResultObject resultObject2) {
        return this.comparator.compare(resultObject1, resultObject2);
    }

    static {
        $assertionsDisabled = !MergeSortUtil.class.desiredAssertionStatus();
    }
}

