/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.dscache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DiskDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.MemoryDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.cache.ResultObjectUtil;
import org.eclipse.birt.data.engine.executor.dscache.ILoadUtil;
import org.eclipse.birt.data.engine.executor.dscache.ISaveUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

class CacheUtilFactory {
    static /* synthetic */ Class class$org$eclipse$birt$data$engine$executor$dscache$CacheUtilFactory;

    CacheUtilFactory() {
    }

    public static ISaveUtil createSaveUtil(IDataSetCacheObject cacheObject, IResultClass rs) {
        if (cacheObject instanceof DiskDataSetCacheObject) {
            return new DiskSaveUtil(((DiskDataSetCacheObject)cacheObject).getDataFile(), ((DiskDataSetCacheObject)cacheObject).getMetaFile(), rs);
        }
        if (cacheObject instanceof MemoryDataSetCacheObject) {
            return new MemorySaveUtil((MemoryDataSetCacheObject)cacheObject, rs);
        }
        return null;
    }

    public static ILoadUtil createLoadUtil(IDataSetCacheObject cacheObject) {
        if (cacheObject instanceof DiskDataSetCacheObject) {
            return new DiskLoadUtil(((DiskDataSetCacheObject)cacheObject).getDataFile(), ((DiskDataSetCacheObject)cacheObject).getMetaFile());
        }
        if (cacheObject instanceof MemoryDataSetCacheObject) {
            return new MemoryLoadUtil((MemoryDataSetCacheObject)cacheObject);
        }
        return null;
    }

    private static class MemoryLoadUtil
    implements ILoadUtil {
        private int currIndex;
        private MemoryDataSetCacheObject cacheObject;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MemoryLoadUtil(MemoryDataSetCacheObject cacheObject) {
            if (!$assertionsDisabled && cacheObject == null) {
                throw new AssertionError();
            }
            this.cacheObject = cacheObject;
            this.currIndex = -1;
        }

        public IResultObject loadObject() throws DataException {
            ++this.currIndex;
            if (this.currIndex >= this.cacheObject.getSize()) {
                return null;
            }
            return this.cacheObject.getResultObject(this.currIndex);
        }

        public IResultClass loadResultClass() throws DataException {
            return this.cacheObject.getResultClass();
        }

        public void close() throws DataException {
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$executor$dscache$CacheUtilFactory == null ? (class$org$eclipse$birt$data$engine$executor$dscache$CacheUtilFactory = CacheUtilFactory.class$("org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory")) : class$org$eclipse$birt$data$engine$executor$dscache$CacheUtilFactory).desiredAssertionStatus();
        }
    }

    private static class DiskLoadUtil
    implements ILoadUtil {
        private File file;
        private File metaFile;
        private FileInputStream fis;
        private BufferedInputStream bis;
        private ResultObjectUtil roUtil;
        private IResultClass rsClass;
        private int rowCount;
        private int currIndex;
        static final /* synthetic */ boolean $assertionsDisabled;

        public DiskLoadUtil(File file, File metaFile) {
            if (!$assertionsDisabled && file == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && metaFile == null) {
                throw new AssertionError();
            }
            this.file = file;
            this.metaFile = metaFile;
            this.rowCount = 0;
            this.currIndex = -1;
        }

        public IResultObject loadObject() throws DataException {
            if (this.roUtil == null) {
                this.init();
            }
            try {
                if (this.currIndex == this.rowCount - 1) {
                    return null;
                }
                ++this.currIndex;
                return this.roUtil.readData(this.bis, 1)[0];
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
        }

        public IResultClass loadResultClass() throws DataException {
            if (this.roUtil == null) {
                this.init();
            }
            return this.rsClass;
        }

        private void init() throws DataException {
            try {
                FileInputStream fis1 = new FileInputStream(this.metaFile);
                BufferedInputStream bis1 = new BufferedInputStream(fis1);
                this.rowCount = IOUtil.readInt((InputStream)bis1);
                this.rsClass = new ResultClass(bis1);
                bis1.close();
                fis1.close();
                if (this.rowCount > 0) {
                    this.roUtil = ResultObjectUtil.newInstance(this.rsClass);
                    this.fis = new FileInputStream(this.file);
                    this.bis = new BufferedInputStream(this.fis);
                }
            }
            catch (FileNotFoundException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.load.error", e);
            }
        }

        public void close() throws DataException {
            if (this.bis != null) {
                try {
                    this.bis.close();
                    this.fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$executor$dscache$CacheUtilFactory == null ? (class$org$eclipse$birt$data$engine$executor$dscache$CacheUtilFactory = CacheUtilFactory.class$("org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory")) : class$org$eclipse$birt$data$engine$executor$dscache$CacheUtilFactory).desiredAssertionStatus();
        }
    }

    private static class MemorySaveUtil
    implements ISaveUtil {
        private MemoryDataSetCacheObject cacheObject;
        static final /* synthetic */ boolean $assertionsDisabled;

        public MemorySaveUtil(MemoryDataSetCacheObject cacheObject, IResultClass rs) {
            if (!$assertionsDisabled && cacheObject == null) {
                throw new AssertionError();
            }
            this.cacheObject = cacheObject;
            this.cacheObject.setResultClass(rs);
        }

        public void saveObject(IResultObject resultObject) throws DataException {
            if (!$assertionsDisabled && resultObject == null) {
                throw new AssertionError();
            }
            this.cacheObject.populateResult(resultObject);
        }

        public void close() throws DataException {
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$executor$dscache$CacheUtilFactory == null ? (class$org$eclipse$birt$data$engine$executor$dscache$CacheUtilFactory = CacheUtilFactory.class$("org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory")) : class$org$eclipse$birt$data$engine$executor$dscache$CacheUtilFactory).desiredAssertionStatus();
        }
    }

    private static class DiskSaveUtil
    implements ISaveUtil {
        private File file;
        private File metaFile;
        private FileOutputStream fos;
        private BufferedOutputStream bos;
        private IResultClass rsClass;
        private ResultObjectUtil roUtil;
        private int rowCount;
        static final /* synthetic */ boolean $assertionsDisabled;

        public DiskSaveUtil(File file, File metaFile, IResultClass rsClass) {
            if (!$assertionsDisabled && file == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && metaFile == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && rsClass == null) {
                throw new AssertionError();
            }
            this.file = file;
            this.file.deleteOnExit();
            this.metaFile = metaFile;
            this.metaFile.deleteOnExit();
            this.rsClass = rsClass;
            this.rowCount = 0;
        }

        public void saveObject(IResultObject resultObject) throws DataException {
            if (!$assertionsDisabled && resultObject == null) {
                throw new AssertionError();
            }
            if (this.roUtil == null) {
                this.roUtil = ResultObjectUtil.newInstance(this.rsClass);
                try {
                    this.fos = new FileOutputStream(this.file);
                    this.bos = new BufferedOutputStream(this.fos);
                }
                catch (FileNotFoundException e) {
                    throw new DataException("data.engine.datasetcache.save.error", e);
                }
            }
            try {
                ++this.rowCount;
                this.roUtil.writeData(this.bos, resultObject);
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.save.error", e);
            }
        }

        public void close() throws DataException {
            try {
                if (this.bos != null) {
                    this.bos.close();
                    this.fos.close();
                }
                FileOutputStream fos1 = new FileOutputStream(this.metaFile);
                BufferedOutputStream bos1 = new BufferedOutputStream(fos1);
                IOUtil.writeInt((OutputStream)bos1, (int)this.rowCount);
                HashMap metaMap = new HashMap();
                this.populateDataSetRowMapping(metaMap);
                ((ResultClass)this.rsClass).doSave(bos1, metaMap);
                bos1.close();
                fos1.close();
            }
            catch (IOException e) {
                throw new DataException("data.engine.datasetcache.save.error", e);
            }
        }

        private void populateDataSetRowMapping(Map metaMap) throws DataException {
            for (int i = 0; i < this.rsClass.getFieldCount(); ++i) {
                metaMap.put(this.rsClass.getFieldName(i + 1), new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)this.rsClass.getFieldName(i + 1))));
            }
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$executor$dscache$CacheUtilFactory == null ? (class$org$eclipse$birt$data$engine$executor$dscache$CacheUtilFactory = CacheUtilFactory.class$("org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory")) : class$org$eclipse$birt$data$engine$executor$dscache$CacheUtilFactory).desiredAssertionStatus();
        }
    }
}

