/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.transform.pass;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IComputedColumn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.transform.IComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.IExpressionProcessor;
import org.eclipse.birt.data.engine.executor.transform.OdiResultSetWrapper;
import org.eclipse.birt.data.engine.executor.transform.ResultSetPopulator;
import org.eclipse.birt.data.engine.executor.transform.pass.ComputedColumnsState;
import org.eclipse.birt.data.engine.executor.transform.pass.DataSetProcessUtil;
import org.eclipse.birt.data.engine.executor.transform.pass.PassStatusController;
import org.eclipse.birt.data.engine.executor.transform.pass.PassUtil;
import org.eclipse.birt.data.engine.executor.transform.pass.ResultSetProcessUtil;
import org.eclipse.birt.data.engine.impl.ComputedColumnHelper;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.FilterByRow;
import org.eclipse.birt.data.engine.odi.IEventHandler;

public class PassManager {
    private ResultSetPopulator populator;
    private ComputedColumnHelper computedColumnHelper;
    private FilterByRow filterByRow;
    private DataEngineSession session;

    private PassManager(ResultSetPopulator populator, DataEngineSession session) {
        this.populator = populator;
        this.session = session;
    }

    public static void populateResultSet(ResultSetPopulator populator, OdiResultSetWrapper odaResultSet, DataEngineSession session) throws DataException {
        new PassManager(populator, session).pass(odaResultSet);
    }

    private void pass(OdiResultSetWrapper odaResultSet) throws DataException {
        this.prepareFetchEventList();
        PassStatusController psController = new PassStatusController(this.populator, this.filterByRow, this.computedColumnHelper);
        if (!psController.needMultipassProcessing()) {
            this.doSinglePass(odaResultSet);
        } else {
            this.doMultiPass(odaResultSet, psController);
        }
        this.calculateAggregationsInColumnBinding();
    }

    private void prepareFetchEventList() {
        Object[] fetchEventsList = PassManager.getFetchEventListFromQuery(this.populator);
        for (int i = 0; i < fetchEventsList.length; ++i) {
            if (fetchEventsList[i] instanceof ComputedColumnHelper) {
                this.computedColumnHelper = (ComputedColumnHelper)fetchEventsList[i];
                continue;
            }
            if (!(fetchEventsList[i] instanceof FilterByRow)) continue;
            this.filterByRow = (FilterByRow)fetchEventsList[i];
        }
    }

    private void doSinglePass(OdiResultSetWrapper odaResultSet) throws DataException {
        if (this.computedColumnHelper != null) {
            this.computedColumnHelper.setModel(0);
        }
        PassUtil.pass(this.populator, odaResultSet, false, this.session);
        this.populator.getExpressionProcessor().setDataSetMode(false);
        this.handleEndOfDataSetProcess();
    }

    private void doMultiPass(OdiResultSetWrapper odaResultSet, PassStatusController psController) throws DataException {
        ComputedColumnsState iccState = null;
        if (this.computedColumnHelper != null) {
            iccState = new ComputedColumnsState(this.computedColumnHelper);
        }
        this.doPopulation(odaResultSet, iccState, psController);
    }

    private static Object[] getFetchEventListFromQuery(ResultSetPopulator rsp) {
        Object[] fetchEventsList = null;
        fetchEventsList = rsp.getQuery().getFetchEvents() == null ? new Object[]{} : rsp.getQuery().getFetchEvents().toArray();
        return fetchEventsList;
    }

    private void doPopulation(OdiResultSetWrapper odaResultSet, ComputedColumnsState iccState, PassStatusController psController) throws DataException {
        List<Object> cachedSorting = Arrays.asList(this.populator.getQuery().getOrdering() == null ? new Object[]{} : this.populator.getQuery().getOrdering());
        this.populator.getQuery().setOrdering(new ArrayList());
        this.populator.getExpressionProcessor().setDataSetMode(true);
        this.populateResultSetCacheInResultSetPopulator(odaResultSet);
        DataSetProcessUtil.doPopulate(this.populator, iccState, this.computedColumnHelper, this.filterByRow, psController, this.session);
        this.handleEndOfDataSetProcess();
        this.populator.getExpressionProcessor().setDataSetMode(false);
        ResultSetProcessUtil.doPopulate(this.populator, iccState, this.computedColumnHelper, this.filterByRow, psController, cachedSorting, this.session);
    }

    private void populateResultSetCacheInResultSetPopulator(OdiResultSetWrapper odaResultSet) throws DataException {
        int max = 0;
        if (this.computedColumnHelper != null) {
            this.computedColumnHelper.setModel(4);
        }
        if (this.filterByRow != null) {
            this.filterByRow.setWorkingFilterSet(4);
        }
        max = this.populator.getQuery().getMaxRows();
        if (this.filterByRow != null) {
            this.populator.getQuery().setMaxRows(0);
        }
        PassUtil.pass(this.populator, odaResultSet, false, this.session);
        this.populator.getQuery().setMaxRows(max);
    }

    private void handleEndOfDataSetProcess() {
        IEventHandler eventHandler = this.populator.getEventHandler();
        if (eventHandler != null) {
            eventHandler.handleEndOfDataSetProcess(this.populator.getResultIterator());
        }
    }

    private void calculateAggregationsInColumnBinding() throws DataException {
        IExpressionProcessor ep = this.populator.getExpressionProcessor();
        Map results = this.populator.getEventHandler().getColumnBindings();
        DummyICCState iccState = new DummyICCState(results);
        ep.setResultIterator(this.populator.getResultIterator());
        while (!iccState.isFinish()) {
            ep.evaluateMultiPassExprOnCmp(iccState, false);
        }
    }

    private class DummyICCState
    implements IComputedColumnsState {
        private Object[] exprs;
        private Object[] names;
        private boolean[] isValueAvailable;

        DummyICCState(Map columnMappings) throws DataException {
            this.exprs = columnMappings.values().toArray();
            this.names = columnMappings.keySet().toArray();
            this.isValueAvailable = new boolean[this.exprs.length];
        }

        public boolean isValueAvailable(int index) {
            return this.isValueAvailable[index];
        }

        public String getName(int index) {
            return this.names[index].toString();
        }

        public IBaseExpression getExpression(int index) {
            return (IBaseExpression)this.exprs[index];
        }

        public void setValueAvailable(int index) {
            this.isValueAvailable[index] = true;
        }

        public int getCount() {
            return this.isValueAvailable.length;
        }

        public IComputedColumn getComputedColumn(int index) {
            return null;
        }

        public void setModel(int model) {
        }

        public boolean isFinish() {
            for (int i = 0; i < this.isValueAvailable.length; ++i) {
                if (this.isValueAvailable[i]) continue;
                return false;
            }
            return true;
        }
    }
}

