/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.core.data.ExpressionUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IGroupDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.api.querydefn.ScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.CompiledExpression;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.DataSetRuntime;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.GroupBindingColumn;
import org.eclipse.birt.data.engine.impl.IExecutorHelper;
import org.eclipse.birt.data.engine.impl.IPreparedQueryService;
import org.eclipse.birt.data.engine.impl.IQueryExecutor;
import org.eclipse.birt.data.engine.impl.IServiceForQueryResults;
import org.eclipse.birt.data.engine.impl.PreparedDataSourceQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVQuery;
import org.eclipse.birt.data.engine.impl.PreparedIVSubQuery;
import org.eclipse.birt.data.engine.impl.PreparedSubquery;
import org.eclipse.birt.data.engine.impl.QueryExecutor;
import org.eclipse.birt.data.engine.odi.IEventHandler;
import org.eclipse.birt.data.engine.odi.IResultIterator;
import org.eclipse.birt.data.engine.odi.IResultObject;
import org.eclipse.birt.data.engine.script.JSResultSetRow;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class ServiceForQueryResults
implements IServiceForQueryResults {
    private DataEngineContext context;
    private IPreparedQueryService queryService;
    private IQueryExecutor queryExecutor;
    private PreparedDataSourceQuery reportQuery;
    private IBaseQueryDefinition queryDefn;
    private ExprManager exprManager;
    private Scriptable scope;
    private int nestedLevel;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ServiceForQueryResults(DataEngineContext context, Scriptable scope, int nestedLevel, PreparedDataSourceQuery reportQuery, IPreparedQueryService query, QueryExecutor queryExecutor, IBaseQueryDefinition queryDefn, ExprManager exprManager) {
        if (!($assertionsDisabled || reportQuery != null && queryExecutor != null)) {
            throw new AssertionError();
        }
        this.context = context;
        this.scope = scope;
        this.nestedLevel = nestedLevel;
        this.reportQuery = reportQuery;
        this.queryService = query;
        this.queryExecutor = queryExecutor;
        this.queryDefn = queryDefn;
        this.exprManager = exprManager;
    }

    public DataEngineContext getContext() {
        return this.context;
    }

    public Scriptable getScope() {
        return this.scope;
    }

    public int getNestedLevel() {
        return this.nestedLevel;
    }

    public IBaseQueryDefinition getQueryDefn() {
        return this.queryDefn;
    }

    public IPreparedQuery getPreparedQuery() {
        return this.reportQuery;
    }

    public int getGroupLevel() {
        if (this.queryService instanceof PreparedSubquery) {
            PreparedSubquery subQuery = (PreparedSubquery)this.queryService;
            return subQuery.getGroupLevel();
        }
        if (this.queryService instanceof PreparedIVSubQuery) {
            PreparedIVSubQuery subQuery = (PreparedIVSubQuery)this.queryService;
            return subQuery.getGroupLevel();
        }
        return 0;
    }

    public DataSetRuntime getDataSetRuntime() {
        return this.queryExecutor.getDataSet();
    }

    public DataSetRuntime[] getDataSetRuntimes(int count) {
        if (!$assertionsDisabled && count < 0) {
            throw new AssertionError();
        }
        DataSetRuntime[] dsRuns = new DataSetRuntime[count];
        if (count > 1) {
            DataSetRuntime[] innerDsRuns = null;
            IQueryExecutor executor = this.queryExecutor;
            innerDsRuns = executor.getNestedDataSets(count - 1);
            for (int i = 0; i < count - 1; ++i) {
                dsRuns[i] = innerDsRuns[i];
            }
        }
        dsRuns[count - 1] = this.queryExecutor.getDataSet();
        return dsRuns;
    }

    public IResultMetaData getResultMetaData() throws DataException {
        return this.queryExecutor.getResultMetaData();
    }

    public IResultIterator executeQuery() throws DataException {
        this.queryExecutor.execute(new EventHandler());
        return this.queryExecutor.getOdiResultSet();
    }

    public IQueryResults execSubquery(IResultIterator iterator, String subQueryName, Scriptable subScope) throws DataException {
        return this.queryService.execSubquery(iterator, subQueryName, subScope);
    }

    public void close() {
        if (this.queryExecutor != null) {
            this.queryExecutor.close();
            this.queryExecutor = null;
        }
    }

    public void validateQueryColumBinding() throws DataException {
        if (this.getPreparedQuery() instanceof PreparedIVQuery) {
            return;
        }
        this.exprManager.validateColumnBinding();
    }

    public IBaseExpression getBindingExpr(String exprName) {
        return this.exprManager.getExpr(exprName);
    }

    public IScriptExpression getAutoBindingExpr(String exprName) {
        return this.exprManager.getAutoBindingExpr(exprName);
    }

    public List getAllBindingExprs() {
        return this.exprManager.getBindingExprs();
    }

    public Map getAllAutoBindingExprs() {
        return this.exprManager.getAutoBindingExprMap();
    }

    public void initAutoBinding() throws DataException {
        if (!this.needAutoBinding()) {
            return;
        }
        Context cx = Context.enter();
        IResultMetaData metaData = this.getResultMetaData();
        int columnCount = metaData.getColumnCount();
        for (int i = 0; i < columnCount; ++i) {
            int colIndex = i + 1;
            try {
                String colName = metaData.getColumnAlias(colIndex);
                if (colName == null) {
                    colName = metaData.getColumnName(colIndex);
                }
                ScriptExpression baseExpr = new ScriptExpression(ExpressionUtil.createJSDataSetRowExpression((String)colName), metaData.getColumnType(colIndex));
                CompiledExpression compiledExpr = ExpressionCompilerUtil.compile(baseExpr.getText(), cx);
                baseExpr.setHandle(compiledExpr);
                this.exprManager.addAutoBindingExpr(colName, baseExpr);
                continue;
            }
            catch (BirtException e) {
                // empty catch block
            }
        }
        Context.exit();
    }

    private boolean needAutoBinding() {
        if (this.queryDefn instanceof IQueryDefinition) {
            return ((IQueryDefinition)this.queryDefn).needAutoBinding();
        }
        return false;
    }

    static {
        $assertionsDisabled = !ServiceForQueryResults.class.desiredAssertionStatus();
    }

    private class EventHandler
    implements IEventHandler {
        private JSResultSetRow jsResultSetRow;
        private IExecutorHelper helper;

        private EventHandler() {
        }

        public void handleEndOfDataSetProcess(IResultIterator resultIterator) {
            this.jsResultSetRow = new JSResultSetRow(resultIterator, ServiceForQueryResults.this.exprManager, ServiceForQueryResults.this.queryExecutor.getQueryScope(), this.helper);
            ServiceForQueryResults.this.getDataSetRuntime().setJSResultSetRow(this.jsResultSetRow);
        }

        public Object getValue(IResultObject rsObject, int index, String name) throws DataException {
            if (this.jsResultSetRow == null) {
                return rsObject.getFieldValue(index);
            }
            return this.jsResultSetRow.getValue(rsObject, index, name);
        }

        public boolean isRowID(int index, String name) {
            IBaseExpression baseExpr = ServiceForQueryResults.this.exprManager.getExpr(name);
            if (baseExpr instanceof IScriptExpression) {
                String exprText = ((IScriptExpression)baseExpr).getText();
                if (exprText == null) {
                    return false;
                }
                return exprText.trim().equalsIgnoreCase("dataSetRow[0]") || exprText.trim().equalsIgnoreCase("dataSetRow._rowPosition");
            }
            return false;
        }

        public IBaseExpression getBaseExpr(String name) {
            if (name == null) {
                return null;
            }
            return ServiceForQueryResults.this.exprManager.getExpr(name);
        }

        public IExecutorHelper getExecutorHelper() {
            return this.helper;
        }

        public void setExecutorHelper(IExecutorHelper helper) {
            this.helper = helper;
        }

        public Map getAllColumnBindings() {
            return this.getColumnBindings(ServiceForQueryResults.this.queryDefn);
        }

        private Map getColumnBindings(IBaseQueryDefinition defn) {
            HashMap result = new HashMap();
            Iterator temp = defn.getResultSetExpressions().keySet().iterator();
            while (temp.hasNext()) {
                Object key = temp.next();
                result.put(key, defn.getResultSetExpressions().get(key));
            }
            result.putAll(this.populateGroupColumnBindings(defn.getGroups().iterator()));
            result.putAll(this.populateSubQueryColumnBindings(defn.getSubqueries().iterator()));
            return result;
        }

        private Map populateGroupColumnBindings(Iterator groups) {
            HashMap result = new HashMap();
            while (groups.hasNext()) {
                IGroupDefinition gd = (IGroupDefinition)groups.next();
                result.putAll(this.populateSubQueryColumnBindings(gd.getSubqueries().iterator()));
            }
            return result;
        }

        private Map populateSubQueryColumnBindings(Iterator subs) {
            HashMap result = new HashMap();
            while (subs.hasNext()) {
                IBaseQueryDefinition defn1 = (IBaseQueryDefinition)subs.next();
                result.putAll(this.getColumnBindings(defn1));
            }
            return result;
        }

        public Map getColumnBindings() {
            HashMap<String, IBaseExpression> result = new HashMap<String, IBaseExpression>();
            List groupBindingColumns = ServiceForQueryResults.this.exprManager.getBindingExprs();
            for (int i = 0; i < groupBindingColumns.size(); ++i) {
                GroupBindingColumn gbc = (GroupBindingColumn)groupBindingColumns.get(i);
                Iterator it = gbc.getColumnNames().iterator();
                while (it.hasNext()) {
                    String name = it.next().toString();
                    result.put(name, gbc.getExpression(name));
                }
            }
            return result;
        }

        public Map getAppContext() {
            return ServiceForQueryResults.this.queryExecutor.getAppContext();
        }
    }
}

