/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.impl.ResultMetaData;
import org.eclipse.birt.data.engine.impl.document.QueryDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDGroupUtil;
import org.eclipse.birt.data.engine.impl.document.RDLoadUtil;
import org.eclipse.birt.data.engine.impl.document.RDSubQueryUtil;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.document.util.BaseExprDataResultSet;
import org.eclipse.birt.data.engine.impl.document.util.ExprDataResultSet1;
import org.eclipse.birt.data.engine.impl.document.util.ExprDataResultSet2;
import org.eclipse.birt.data.engine.impl.document.util.ExprResultSet;
import org.eclipse.birt.data.engine.impl.document.util.ExprResultSet2;
import org.eclipse.birt.data.engine.impl.document.util.IExprDataResultSet;
import org.eclipse.birt.data.engine.impl.document.util.IExprResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.DataSetResultSet;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaInfo;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaUtil;
import org.eclipse.birt.data.engine.odi.IResultClass;

public class RDLoad {
    private int version;
    private StreamManager streamManager;
    private RDSubQueryUtil subQueryUtil;

    RDLoad(DataEngineContext context, QueryResultInfo queryResultInfo) throws DataException {
        this.subQueryUtil = new RDSubQueryUtil(context, QueryResultIDUtil.getRealStreamID(queryResultInfo.getRootQueryResultID(), queryResultInfo.getSelfQueryResultID()), queryResultInfo.getSubQueryName());
        this.streamManager = new StreamManager(context, new QueryResultInfo(queryResultInfo.getRootQueryResultID(), queryResultInfo.getParentQueryResultID(), queryResultInfo.getSelfQueryResultID(), queryResultInfo.getSubQueryName(), queryResultInfo.getSubQueryName() == null ? 0 : this.getSubQueryIndex(queryResultInfo.getIndex())));
        this.version = this.streamManager.getVersion();
    }

    int getSubQueryIndex(int currParentIndex) throws DataException {
        return this.subQueryUtil.getSubQueryIndex(currParentIndex);
    }

    public ResultMetaData loadResultMetaData() throws DataException {
        return new ResultMetaData(this.loadResultClass());
    }

    IExprResultSet loadExprResultSet() throws DataException {
        if (this.streamManager.isSecondRD() && this.streamManager.isSubquery()) {
            return new ExprResultSet2(this.streamManager, this.version, this.streamManager.isSecondRD());
        }
        return new ExprResultSet(this.streamManager, this.version, this.streamManager.isSecondRD());
    }

    public RDGroupUtil loadRootGroupUtil() throws DataException {
        return RDLoadUtil.loadGroupUtil(this.streamManager, 0, 0);
    }

    public IExprDataResultSet loadExprDataResultSet() throws DataException {
        if (this.version == 0) {
            throw new DataException("data.engine.wrongVersion");
        }
        RAInputStream inputStream = this.streamManager.getInStream(32, 0, 0);
        BufferedInputStream buffStream = new BufferedInputStream((InputStream)inputStream);
        ExprMetaInfo[] exprMetas = ExprMetaUtil.loadExprMetaInfo(buffStream);
        try {
            buffStream.close();
            inputStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        BaseExprDataResultSet exprDataResultSet = null;
        exprDataResultSet = !this.streamManager.isBasedOnSecondRD() ? new ExprDataResultSet1(this.streamManager.getInStream(31, 0, 0), exprMetas, this.streamManager.getVersion()) : new ExprDataResultSet2(this.streamManager.getInStream(31, 0, 0), this.streamManager.getInStream(33, 0, 0), this.streamManager.getInStream(51, 0, 1), exprMetas);
        return exprDataResultSet;
    }

    private IResultClass loadResultClass() throws DataException {
        RAInputStream stream = this.streamManager.getInStream(22, 0, 0);
        BufferedInputStream buffStream = new BufferedInputStream((InputStream)stream);
        ResultClass resultClass = new ResultClass(buffStream);
        try {
            buffStream.close();
            stream.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Result Class");
        }
        return resultClass;
    }

    public DataSetResultSet loadDataSetData() throws DataException {
        RAInputStream stream = this.streamManager.getInStream(21, 0, 0);
        BufferedInputStream buffStream = new BufferedInputStream((InputStream)stream);
        DataSetResultSet populator = new DataSetResultSet(buffStream, this.loadResultClass());
        return populator;
    }

    public IBaseQueryDefinition loadOriginalQueryDefn(int streamPos, int streamScope) throws DataException {
        RAInputStream inputStream = this.streamManager.getInStream(44, streamPos, streamScope);
        return this.loadQueryDefn((InputStream)inputStream);
    }

    public IBaseQueryDefinition loadQueryDefn(int streamPos, int streamScope) throws DataException {
        RAInputStream inputStream = this.streamManager.getInStream(43, streamPos, streamScope);
        return this.loadQueryDefn((InputStream)inputStream);
    }

    private IBaseQueryDefinition loadQueryDefn(InputStream inputStream) throws DataException {
        IQueryDefinition queryDefn = QueryDefnUtil.loadQueryDefn(inputStream);
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return queryDefn;
    }

    public List loadFilterDefn(int streamPos, int streamScope) throws DataException {
        return this.loadQueryDefn(streamPos, streamScope).getFilters();
    }

    public List loadGroupDefn(int streamPos, int streamScope) throws DataException {
        return this.loadQueryDefn(streamPos, streamScope).getGroups();
    }
}

