/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.querydefn.QueryDefinition;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.QueryDefnUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDManager;
import org.eclipse.birt.data.engine.impl.document.RDSubQueryUtil;
import org.eclipse.birt.data.engine.impl.document.StreamWrapper;
import org.eclipse.birt.data.engine.impl.document.stream.StreamManager;
import org.eclipse.birt.data.engine.impl.document.viewing.ExprMetaUtil;
import org.eclipse.birt.data.engine.odi.IResultIterator;

class RDSaveUtil {
    private int mode;
    private IBaseQueryDefinition queryDefn;
    private StreamManager streamManager;

    RDSaveUtil(int mode, IBaseQueryDefinition queryDefn, StreamManager streamManager) {
        this.mode = mode;
        this.queryDefn = queryDefn;
        this.streamManager = streamManager;
    }

    void saveResultIterator(IResultIterator odiResult, int groupLevel, int[] subQueryInfo) throws DataException {
        if (this.mode == 1) {
            this.saveForGeneration(odiResult, groupLevel, subQueryInfo);
        } else {
            this.saveForUpdate(odiResult, groupLevel, subQueryInfo);
        }
    }

    private void saveForGeneration(IResultIterator odiResult, int groupLevel, int[] subQueryInfo) throws DataException {
        try {
            Object streamForDataSet = null;
            OutputStream streamForResultClass = null;
            OutputStream streamForGroupInfo = null;
            boolean isSubQuery = this.streamManager.isSubquery();
            if (!isSubQuery) {
                streamForResultClass = this.streamManager.getOutStream(22, 0, 2);
            }
            streamForGroupInfo = this.streamManager.getOutStream(41, 0, 2);
            odiResult.doSave(new StreamWrapper(this.streamManager, streamForResultClass, streamForGroupInfo, null, null), isSubQuery);
            streamForGroupInfo.close();
            if (isSubQuery && !this.streamManager.hasOutStream(42, 1, 2)) {
                this.saveSubQueryInfo(groupLevel, subQueryInfo);
            }
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Set");
        }
    }

    private void saveForUpdate(IResultIterator odiResult, int groupLevel, int[] subQueryInfo) throws DataException {
        try {
            OutputStream streamForGroupInfo = null;
            OutputStream streamForRowIndexInfo = null;
            OutputStream streamForParentIndexInfo = null;
            boolean isSubQuery = this.streamManager.isSubquery();
            if (this.streamManager.isSecondRD()) {
                streamForRowIndexInfo = this.streamManager.getOutStream(51, 0, 2);
                if (isSubQuery) {
                    streamForParentIndexInfo = this.streamManager.getOutStream(71, 0, 2);
                }
            }
            streamForGroupInfo = this.streamManager.getOutStream(41, 0, 2);
            odiResult.doSave(new StreamWrapper(null, null, streamForGroupInfo, streamForRowIndexInfo, streamForParentIndexInfo), isSubQuery);
            streamForGroupInfo.close();
            if (streamForRowIndexInfo != null) {
                streamForRowIndexInfo.close();
            }
            if (streamForParentIndexInfo != null) {
                streamForParentIndexInfo.close();
            }
            if (isSubQuery && this.mode == 4) {
                this.saveSubQueryInfo(groupLevel, subQueryInfo);
            }
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Result Set");
        }
    }

    private void saveSubQueryInfo(int groupLevel, int[] subQueryInfo) throws DataException, IOException {
        OutputStream streamForSubQuery = this.streamManager.getOutStream(42, 1, 2);
        RDSubQueryUtil.doSave(streamForSubQuery, groupLevel, subQueryInfo);
        streamForSubQuery.close();
    }

    void saveExprMetadata(Set exprNameSet) throws DataException {
        OutputStream outputStream = this.streamManager.getOutStream(32, 0, 2);
        ExprMetaUtil.saveExprMetaInfo(this.queryDefn, exprNameSet, outputStream);
        try {
            outputStream.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    void saveQueryDefn() throws DataException {
        OutputStream outputStream;
        if (this.queryDefn instanceof QueryDefinition && ((QueryDefinition)this.queryDefn).getQueryResultsID() == null) {
            outputStream = this.streamManager.getOutStream(44, 0, 2);
            QueryDefnUtil.saveBaseQueryDefn(outputStream, this.queryDefn);
            try {
                outputStream.close();
            }
            catch (IOException e) {
                throw new DataException("data.engine.SaveReportDocumentError", e);
            }
        }
        outputStream = this.streamManager.getOutStream(43, 0, 2);
        QueryDefnUtil.saveBaseQueryDefn(outputStream, this.queryDefn);
        try {
            outputStream.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", e);
        }
    }

    void saveChildQueryID() throws DataException {
        QueryResultIDManager.appendChildToRoot(this.streamManager, this.queryDefn.getFilters());
    }
}

