/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.activity;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Stack;
import org.eclipse.birt.report.model.activity.ActivityRecord;
import org.eclipse.birt.report.model.activity.CompoundRecord;
import org.eclipse.birt.report.model.activity.ExtensionActivityRecord;
import org.eclipse.birt.report.model.activity.FilterEventsCompoundRecord;
import org.eclipse.birt.report.model.activity.LayoutCompoundRecord;
import org.eclipse.birt.report.model.api.CommandStack;
import org.eclipse.birt.report.model.api.activity.ActivityStackEvent;
import org.eclipse.birt.report.model.api.activity.ActivityStackListener;
import org.eclipse.birt.report.model.api.activity.IActivityRecord;
import org.eclipse.birt.report.model.api.extension.IElementCommand;

public class ActivityStack
implements CommandStack {
    public static final int DEFAULT_STACK_LIMIT = 500;
    private Stack undoStack = new Stack();
    private Stack redoStack = new Stack();
    private Stack transStack = new Stack();
    private int stackLimit = 500;
    private int transCount = 0;
    protected ArrayList listeners = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public void execute(IElementCommand command) {
        ExtensionActivityRecord record = new ExtensionActivityRecord(command);
        this.execute(record);
    }

    public void execute(IActivityRecord executeRecord) {
        ActivityRecord record = (ActivityRecord)executeRecord;
        if (!$assertionsDisabled && record == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && record.getState() != 0) {
            throw new AssertionError();
        }
        record.execute();
        record.setState(1);
        if (!$assertionsDisabled && record instanceof CompoundRecord) {
            throw new AssertionError();
        }
        record.performPostTasks(this.transStack);
        if (this.transStack.isEmpty()) {
            this.destroyRecords(this.redoStack);
            record.setTransNo(++this.transCount);
            this.undoStack.push(record);
            this.trimUndoStack();
            this.sendNotifcations(new ActivityStackEvent(this, 1));
        } else {
            CompoundRecord trans = (CompoundRecord)this.transStack.lastElement();
            trans.append(record);
        }
    }

    public void undo() {
        if (!$assertionsDisabled && !this.canUndo()) {
            throw new AssertionError();
        }
        ActivityRecord record = (ActivityRecord)this.undoStack.pop();
        if (!$assertionsDisabled && record.getState() != 1 && record.getState() != 3) {
            throw new AssertionError();
        }
        record.undo();
        record.setState(2);
        this.redoStack.push(record);
        record.performPostTasks(this.transStack);
        this.sendNotifcations(new ActivityStackEvent(this, 3));
    }

    public void redo() {
        if (!$assertionsDisabled && !this.canRedo()) {
            throw new AssertionError();
        }
        ActivityRecord record = (ActivityRecord)this.redoStack.pop();
        if (!$assertionsDisabled && record.getState() != 2) {
            throw new AssertionError();
        }
        record.redo();
        record.setState(3);
        this.undoStack.push(record);
        record.performPostTasks(this.transStack);
        this.sendNotifcations(new ActivityStackEvent(this, 2));
    }

    public boolean canUndo() {
        if (!this.transStack.isEmpty()) {
            return false;
        }
        if (this.undoStack.size() == 0) {
            return false;
        }
        ActivityRecord record = (ActivityRecord)this.undoStack.lastElement();
        return record.canUndo();
    }

    public boolean canRedo() {
        if (!this.transStack.isEmpty()) {
            return false;
        }
        if (this.redoStack.size() == 0) {
            return false;
        }
        ActivityRecord record = (ActivityRecord)this.redoStack.lastElement();
        return record.canUndo();
    }

    private void trimUndoStack() {
        while (this.undoStack.size() > this.stackLimit) {
            ActivityRecord cmd = (ActivityRecord)this.undoStack.remove(0);
            if (!$assertionsDisabled && cmd.getState() == 4) {
                throw new AssertionError();
            }
            cmd.destroy();
            cmd.setState(4);
        }
    }

    public void flush() {
        this.destroyRecords(this.redoStack);
        this.destroyRecords(this.undoStack);
    }

    private void destroyRecords(Stack stack) {
        Iterator iter = stack.iterator();
        while (iter.hasNext()) {
            ActivityRecord cmd = (ActivityRecord)iter.next();
            if (!$assertionsDisabled && cmd.getState() == 4) {
                throw new AssertionError();
            }
            cmd.destroy();
            cmd.setState(4);
        }
        stack.removeAllElements();
    }

    public void setStackLimit(int limit) {
        if (!$assertionsDisabled && limit < 0) {
            throw new AssertionError();
        }
        this.stackLimit = limit;
        this.trimUndoStack();
    }

    public Object[] getRecords() {
        ArrayList records = new ArrayList(this.undoStack);
        for (int i = this.redoStack.size() - 1; i >= 0; --i) {
            records.add(this.redoStack.get(i));
        }
        return records.toArray();
    }

    public IActivityRecord getRedoRecord() {
        return this.redoStack.isEmpty() ? null : (ActivityRecord)this.redoStack.peek();
    }

    public IActivityRecord getUndoRecord() {
        return this.undoStack.isEmpty() ? null : (ActivityRecord)this.undoStack.peek();
    }

    public String getUndoLabel() {
        IActivityRecord cmd = this.getUndoRecord();
        if (cmd == null) {
            return null;
        }
        String label = cmd.getLabel();
        if (!$assertionsDisabled && label == null) {
            throw new AssertionError();
        }
        return label;
    }

    public String getRedoLabel() {
        IActivityRecord cmd = this.getRedoRecord();
        if (cmd == null) {
            return null;
        }
        String label = cmd.getLabel();
        if (!$assertionsDisabled && label == null) {
            throw new AssertionError();
        }
        return label;
    }

    public void startTrans() {
        this.startTrans(null);
    }

    public void startTrans(String label) {
        if (!this.transStack.isEmpty() && this.transStack.peek() instanceof LayoutCompoundRecord) {
            this.startSilentTrans(label, false);
        } else if (!this.transStack.isEmpty() && this.transStack.peek() instanceof FilterEventsCompoundRecord) {
            this.startFilterEventTrans(label);
        } else {
            this.transStack.push(new CompoundRecord(label));
        }
    }

    public void commit() {
        if (!$assertionsDisabled && this.transStack.empty()) {
            throw new AssertionError();
        }
        CompoundRecord transaction = (CompoundRecord)this.transStack.pop();
        if (transaction.isEmpty()) {
            transaction.destroy();
            return;
        }
        transaction.setState(1);
        CompoundRecord record = transaction;
        ((ActivityRecord)record).performPostTasks(this.transStack);
        if (this.transStack.empty()) {
            this.destroyRecords(this.redoStack);
            record.setTransNo(++this.transCount);
            this.undoStack.push(record);
            this.trimUndoStack();
            this.sendNotifcations(new ActivityStackEvent(this, 1));
        } else {
            CompoundRecord outer = (CompoundRecord)this.transStack.lastElement();
            outer.append(record);
        }
    }

    public void rollback() {
        if (!$assertionsDisabled && this.transStack.size() <= 0) {
            throw new AssertionError();
        }
        CompoundRecord trans = (CompoundRecord)this.transStack.pop();
        trans.rollback();
        trans.destroy();
        if (this.transStack.empty()) {
            this.sendNotifcations(new ActivityStackEvent(this, 4));
        }
    }

    public void rollbackAll() {
        while (!this.transStack.isEmpty()) {
            this.rollback();
        }
    }

    public int getCurrentTransNo() {
        if (this.undoStack.isEmpty()) {
            return 0;
        }
        return ((ActivityRecord)this.undoStack.lastElement()).getTransNo();
    }

    public void addListener(ActivityStackListener obj) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        if (obj != null && !this.listeners.contains(obj)) {
            this.listeners.add(obj);
        }
    }

    public void removeListener(ActivityStackListener obj) {
        if (this.listeners == null) {
            return;
        }
        int posn = this.listeners.indexOf(obj);
        if (posn != -1) {
            this.listeners.remove(posn);
        }
    }

    public void sendNotifcations(ActivityStackEvent event) {
        if (this.listeners != null) {
            Iterator iter = this.listeners.iterator();
            while (iter.hasNext()) {
                ActivityStackListener listener = (ActivityStackListener)iter.next();
                listener.stackChanged(event);
            }
        }
    }

    public void startPersistentTrans(String label) {
        this.transStack.push(new CompoundRecord(label, true));
    }

    public void startPersistentTrans() {
        this.startPersistentTrans(null);
    }

    public void startSilentTrans() {
        this.startSilentTrans(null, false);
    }

    public void startSilentTrans(boolean filterAll) {
        this.startSilentTrans(null, filterAll);
    }

    protected void startSilentTrans(String label, boolean filterAll) {
        boolean outerMost = true;
        if (!this.transStack.isEmpty() && this.transStack.peek() instanceof LayoutCompoundRecord) {
            outerMost = false;
        }
        this.transStack.push(new LayoutCompoundRecord(label, outerMost, filterAll));
    }

    public void startFilterEventTrans(String label) {
        if (!this.transStack.isEmpty() && this.transStack.peek() instanceof LayoutCompoundRecord) {
            this.startSilentTrans(label, false);
        } else {
            boolean outerMost = true;
            if (!this.transStack.isEmpty() && this.transStack.peek() instanceof FilterEventsCompoundRecord) {
                outerMost = false;
            }
            this.transStack.push(new FilterEventsCompoundRecord(label, outerMost));
        }
    }

    public void clearListeners() {
        if (this.listeners != null) {
            this.listeners.clear();
        }
        this.listeners = null;
    }

    static {
        $assertionsDisabled = !ActivityStack.class.desiredAssertionStatus();
    }
}

