/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.CellContextInfo;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.ColumnBandAdapter;
import org.eclipse.birt.report.model.api.ColumnHandle;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableGroupHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.ColumnHelper;
import org.eclipse.birt.report.model.elements.TableColumn;

abstract class ColumnBandAction {
    protected ColumnBandAdapter adapter = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    ColumnBandAction(ColumnBandAdapter adapter) {
        this.adapter = adapter;
    }

    protected boolean isRectangleArea(List cells, int rectWidth) {
        int numOfRows = this.adapter.getRowCount();
        int rowCount = 0;
        for (int i = 0; i < cells.size(); ++i) {
            CellContextInfo contextInfo = (CellContextInfo)cells.get(i);
            int colSpan = contextInfo.getColumnSpan();
            if (colSpan > rectWidth) {
                return false;
            }
            rowCount += contextInfo.getRowSpan();
        }
        if (!$assertionsDisabled && rowCount > numOfRows) {
            throw new AssertionError();
        }
        return rowCount >= numOfRows;
    }

    protected void addColumnHeader(TableColumn column, int columnNumber, boolean isInsert) {
        SlotHandle columns = this.adapter.getColumns();
        if (!$assertionsDisabled && columns.getCount() != 0) {
            throw new AssertionError();
        }
        int columnCount = this.adapter.getColumnCount();
        if (isInsert) {
            ++columnCount;
        }
        for (int i = 0; i < columnCount; ++i) {
            ColumnHandle toAdd = null;
            toAdd = i == columnNumber - 1 && !isInsert || isInsert && i == columnNumber ? column.handle(this.adapter.getModule()) : this.adapter.getElementHandle().getElementFactory().newTableColumn();
            try {
                columns.add(toAdd);
                continue;
            }
            catch (SemanticException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                continue;
            }
        }
    }

    private List checkElementPostPaste(DesignElementHandle content) {
        if (content == null) {
            return Collections.EMPTY_LIST;
        }
        List exceptionList = content.getElement().validateWithContents(this.adapter.getModule());
        List errorDetailList = ErrorDetail.convertExceptionList(exceptionList);
        return errorDetailList;
    }

    protected CellContextInfo getCellContextInfo(Cell cell, RowHandle row) {
        DesignElementHandle rowContainer = row.getContainer();
        int slotId = rowContainer.findContentSlot(row);
        int groupId = -1;
        SlotHandle slot = rowContainer.getSlot(slotId);
        if (rowContainer instanceof TableGroupHandle) {
            TableHandle rowGrandPa = (TableHandle)rowContainer.getContainer();
            groupId = rowGrandPa.getGroups().findPosn(rowContainer);
        }
        CellContextInfo cellInfo = new CellContextInfo(cell, cell.getRowSpan(this.adapter.getModule()), cell.getColSpan(this.adapter.getModule()), cell.getStringProperty(this.adapter.getModule(), "drop"));
        int rowNumber = slot.findPosn(row);
        cellInfo.setContainerDefnName(rowContainer.getDefn().getName());
        cellInfo.setSlotId(slotId);
        cellInfo.setGroupId(groupId);
        cellInfo.setRowIndex(rowNumber);
        return cellInfo;
    }

    private SlotLayoutInfo getLayoutOfSlot(List cells, String containerDefnName, int slotId, int groupId) {
        SlotLayoutInfo layoutInfo = new SlotLayoutInfo(containerDefnName, slotId, groupId);
        for (int i = 0; i < cells.size(); ++i) {
            Object obj = cells.get(i);
            String tmpDefnName = null;
            int tmpSlotId = -1;
            int tmpGroupId = -1;
            CellContextInfo contextInfo = (CellContextInfo)obj;
            tmpDefnName = contextInfo.getContainerDefnName();
            tmpSlotId = contextInfo.getSlotId();
            tmpGroupId = contextInfo.getGroupId();
            if (!containerDefnName.equals(tmpDefnName) || tmpSlotId != slotId || tmpGroupId != groupId) continue;
            layoutInfo.addCell(contextInfo.getCell(), contextInfo.getRowSpan());
        }
        return layoutInfo;
    }

    protected boolean isSameLayout(List copiedCells, List targetCells) throws SemanticException {
        String oldContainerDefnName = null;
        int oldSlotId = -1;
        int oldGroupId = -1;
        for (int i = 0; i < copiedCells.size(); ++i) {
            CellContextInfo contextInfo = (CellContextInfo)copiedCells.get(i);
            String containerDefnName = contextInfo.getContainerDefnName();
            int slotId = contextInfo.getSlotId();
            int groupId = contextInfo.getGroupId();
            if (!containerDefnName.equals(oldContainerDefnName) || slotId != oldSlotId || groupId != oldGroupId) {
                SlotLayoutInfo info2;
                SlotLayoutInfo info1 = this.getLayoutOfSlot(copiedCells, containerDefnName, slotId, groupId);
                if (!info1.isSameNumOfRows(info2 = this.getLayoutOfSlot(targetCells, containerDefnName, slotId, groupId))) {
                    throw new SemanticError(this.adapter.getElementHandle().getElement(), new String[]{this.adapter.getElementHandle().getName()}, "Error.SemanticError.COLUMN_PASTE_FORBIDDEN");
                }
                if (!info1.isSameLayoutOfRows(info2)) {
                    return false;
                }
            }
            oldContainerDefnName = containerDefnName;
            oldSlotId = slotId;
            oldGroupId = groupId;
        }
        return true;
    }

    protected void pasteColumn(TableColumn column, int columnNumber, boolean isInsert) throws SemanticException {
        TableColumn targetColumn = null;
        SlotHandle columns = this.adapter.getColumns();
        if (columns.getCount() == 0 && column == null) {
            return;
        }
        if (columns.getCount() == 0 && column != null) {
            this.addColumnHeader(column, columnNumber, isInsert);
            return;
        }
        if (isInsert && columnNumber == 0) {
            columns.add(column.handle(this.adapter.getModule()), 0);
            return;
        }
        targetColumn = ColumnHelper.findColumn(this.adapter.getModule(), columns.getSlot(), columnNumber);
        this.replaceColumn(column, targetColumn.handle(this.adapter.getModule()), columnNumber, isInsert);
    }

    private void replaceColumn(TableColumn source, ColumnHandle target, int columnNumber, boolean isInsert) throws SemanticException {
        SlotHandle columns = target.getContainerSlotHandle();
        if (!$assertionsDisabled && target == null) {
            throw new AssertionError();
        }
        int colStartPos = ColumnBandAdapter.getColumnStartPos(target);
        int colEndPos = colStartPos + target.getRepeatCount() - 1;
        ColumnHandle toAdd = null;
        toAdd = source == null ? target.getElementFactory().newTableColumn() : (ColumnHandle)source.getHandle(this.adapter.getModule());
        int oldPos = columns.findPosn(target);
        if (target.getRepeatCount() == 1) {
            if (isInsert) {
                ++oldPos;
            } else {
                columns.drop(target);
            }
            columns.add(toAdd, oldPos);
            return;
        }
        if (!$assertionsDisabled && target.getRepeatCount() <= 1) {
            throw new AssertionError();
        }
        if (!isInsert && (columnNumber == colStartPos || columnNumber == colEndPos) || isInsert && columnNumber == colEndPos) {
            if (!isInsert) {
                target.setRepeatCount(target.getRepeatCount() - 1);
            }
            int pos = oldPos;
            if (columnNumber != colStartPos) {
                ++pos;
            }
            columns.add(toAdd, pos);
            return;
        }
        if (columnNumber > colStartPos && columnNumber < colEndPos || isInsert && columnNumber == colStartPos) {
            int repeat1 = columnNumber - colStartPos;
            if (isInsert) {
                ++repeat1;
            }
            int repeat2 = target.getRepeatCount() - repeat1;
            if (!isInsert) {
                --repeat2;
            }
            ColumnHandle newColumn = ((TableColumn)target.copy()).handle(this.adapter.getModule());
            target.setRepeatCount(repeat1);
            newColumn.setRepeatCount(repeat2);
            int pos = oldPos;
            columns.add(toAdd, pos + 1);
            columns.add(newColumn, pos + 2);
        }
    }

    protected List getCellsContextInfo(List cells) {
        ArrayList<CellContextInfo> list = new ArrayList<CellContextInfo>();
        for (int i = 0; i < cells.size(); ++i) {
            CellHandle cell = (CellHandle)cells.get(i);
            list.add(this.getCellContextInfo((Cell)cell.getElement(), (RowHandle)cell.getContainer()));
        }
        return list;
    }

    protected List doPostPasteCheck(TableColumn column, List cells) {
        List list = Collections.EMPTY_LIST;
        if (column != null) {
            list = this.checkElementPostPaste(column.getHandle(this.adapter.getModule()));
        }
        for (int i = 0; i < cells.size(); ++i) {
            CellContextInfo contextInfo = (CellContextInfo)cells.get(i);
            CellHandle cell = contextInfo.getCell().handle(this.adapter.getModule());
            list.addAll(this.checkElementPostPaste(cell));
        }
        return list;
    }

    static {
        $assertionsDisabled = !ColumnBandAction.class.desiredAssertionStatus();
    }

    private static class SlotLayoutInfo {
        private List details = new ArrayList();
        private String containerDefnName;
        private int slotId;
        private int groupId;

        protected SlotLayoutInfo(String containerDefnName, int slotId, int groupId) {
            this.containerDefnName = containerDefnName;
            this.slotId = slotId;
            this.groupId = groupId;
        }

        protected void addCell(Cell cell, int rowSpan) {
            this.details.add(new Integer(rowSpan));
        }

        public boolean isSameNumOfRows(SlotLayoutInfo info) {
            int targetNumOfRows;
            if (!this.containerDefnName.equals(info.containerDefnName)) {
                return false;
            }
            if (this.slotId != info.slotId || this.groupId != this.groupId) {
                return false;
            }
            int myNumOfRows = this.getNumOfRows();
            return myNumOfRows == (targetNumOfRows = info.getNumOfRows());
        }

        public boolean isSameLayoutOfRows(SlotLayoutInfo info) {
            if (this.details.size() != info.details.size()) {
                return false;
            }
            for (int i = 0; i < this.details.size(); ++i) {
                Object targetRowSpan;
                Integer myRowSpan = (Integer)this.details.get(i);
                if (myRowSpan.equals(targetRowSpan = info.details.get(i))) continue;
                return false;
            }
            return true;
        }

        private int getNumOfRows() {
            int numOfRows = 0;
            for (int i = 0; i < this.details.size(); ++i) {
                Integer rowSpan = (Integer)this.details.get(i);
                numOfRows += rowSpan.intValue();
            }
            return numOfRows;
        }
    }
}

