/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.CellHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListingHandle;
import org.eclipse.birt.report.model.api.ReportItemHandle;
import org.eclipse.birt.report.model.api.RowBandAdapter;
import org.eclipse.birt.report.model.api.RowHandle;
import org.eclipse.birt.report.model.api.RowOperationParameters;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.TableHandle;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.TableRow;

abstract class RowBandAction {
    protected RowBandAdapter adapter = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    RowBandAction(RowBandAdapter adapter) {
        this.adapter = adapter;
    }

    protected TableRow copyRow(RowHandle rowHandle) {
        return (TableRow)rowHandle.copy();
    }

    protected TableRow copyRow(TableRow row) {
        TableRow clonedRow;
        block2: {
            clonedRow = null;
            try {
                clonedRow = (TableRow)row.clone();
            }
            catch (CloneNotSupportedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return clonedRow;
    }

    protected boolean isRectangleArea(RowHandle rowHandle) {
        if (rowHandle == null) {
            return true;
        }
        int numOfColumns = this.adapter.getColumnCount();
        int columnCount = 0;
        SlotHandle slotHandle = rowHandle.getCells();
        for (int i = 0; i < slotHandle.getCount(); ++i) {
            CellHandle cellHandle = (CellHandle)slotHandle.get(i);
            columnCount += cellHandle.getColumnSpan();
        }
        return columnCount == numOfColumns;
    }

    protected boolean containsRowSpan(RowHandle rowHandle) {
        if (rowHandle == null) {
            return true;
        }
        SlotHandle cellsHandle = rowHandle.getCells();
        int count = cellsHandle.getCount();
        for (int i = 0; i < count; ++i) {
            CellHandle cell = (CellHandle)cellsHandle.get(i);
            if (cell.getRowSpan() <= 1) continue;
            return true;
        }
        return false;
    }

    protected int getPositionOfRow(TableRow row) {
        DesignElement rowContainer = row.getContainer();
        int slotId = rowContainer.findSlotOf(row);
        ContainerSlot parent = rowContainer.getSlot(slotId);
        int rowNumber = parent.findPosn(row);
        return rowNumber;
    }

    protected int computeColumnCount(TableRow row) {
        List contents = row.getContentsSlot();
        Iterator cellIter = contents.iterator();
        int count = 0;
        while (cellIter.hasNext()) {
            Cell cell = (Cell)cellIter.next();
            int columnSpan = cell.getColSpan(null);
            count += columnSpan;
        }
        return count;
    }

    protected int computeColumnCount(RowHandle rowHandle) {
        return this.computeColumnCount((TableRow)rowHandle.getElement());
    }

    protected SlotHandle getSlotHandle(RowOperationParameters parameters) {
        ReportItemHandle reportHandle = this.adapter.getElementHandle();
        SlotHandle slotHandle = null;
        int slotId = parameters.getSlotId();
        int groupId = parameters.getGroupId();
        if (reportHandle instanceof TableHandle) {
            if (groupId >= 0) {
                SlotHandle groups = ((ListingHandle)reportHandle).getGroups();
                if (groups == null || groupId < 0 || groupId >= groups.getCount()) {
                    return null;
                }
                GroupHandle groupHandle = (GroupHandle)groups.get(groupId);
                if (slotId != 0 && slotId != 1) {
                    return null;
                }
                slotHandle = groupHandle.getSlot(slotId);
            } else {
                if (slotId < 0 || slotId > 3) {
                    return null;
                }
                slotHandle = reportHandle.getSlot(slotId);
            }
        } else if (reportHandle instanceof GridHandle) {
            slotHandle = ((GridHandle)reportHandle).getRows();
        }
        return slotHandle;
    }

    protected int adjustPosition(int destIndex, int count) {
        if (destIndex < 0) {
            destIndex = 0;
        }
        if (destIndex > count - 1) {
            destIndex = count - 1;
        }
        return destIndex;
    }

    static {
        $assertionsDisabled = !RowBandAction.class.desiredAssertionStatus();
    }
}

