/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.validators;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.birt.report.model.api.elements.SemanticError;
import org.eclipse.birt.report.model.api.util.URIUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.validators.AbstractElementValidator;

public class ImageFileExistingValidator
extends AbstractElementValidator {
    private static final ImageFileExistingValidator instance = new ImageFileExistingValidator();

    public static ImageFileExistingValidator getInstance() {
        return instance;
    }

    public List validate(Module module, DesignElement element) {
        if (!(element instanceof ImageItem)) {
            return Collections.EMPTY_LIST;
        }
        return this.doValidate(module, (ImageItem)element);
    }

    private List doValidate(Module module, ImageItem toValidate) {
        String source = toValidate.getStringProperty(module, "source");
        if (!"file".equalsIgnoreCase(source)) {
            return Collections.EMPTY_LIST;
        }
        if (!(module instanceof ReportDesign)) {
            return Collections.EMPTY_LIST;
        }
        String uri = toValidate.getStringProperty(module, "uri");
        String filePath = URIUtil.getLocalPath(uri);
        if (filePath != null && !((ReportDesign)module).isFileExist(filePath, 1)) {
            toValidate.setValid(false);
            ArrayList<SemanticError> list = new ArrayList<SemanticError>();
            list.add(new SemanticError((DesignElement)toValidate, new String[]{filePath}, "Error.SemanticError.IMAGE_FILE_NOT_FOUND", 1));
            return list;
        }
        return Collections.EMPTY_LIST;
    }
}

