/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.command.PropertyCommand;
import org.eclipse.birt.report.model.command.ShiftLibraryRecord;
import org.eclipse.birt.report.model.core.CachedMemberRef;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;

public class ShiftLibraryCommand
extends AbstractElementCommand {
    static final /* synthetic */ boolean $assertionsDisabled;

    public ShiftLibraryCommand(Module module) {
        super(module, module);
        if (!$assertionsDisabled && !(module instanceof ReportDesign)) {
            throw new AssertionError();
        }
    }

    public void shiftLibrary(Library library, int newPosn) throws SemanticException {
        int adjustedNewPosn;
        List libraries = this.module.getLibraries();
        if (!$assertionsDisabled && libraries.isEmpty()) {
            throw new AssertionError();
        }
        if (!libraries.contains(library)) {
            throw new LibraryException(library, new String[]{library.getNamespace()}, "Error.LibraryException.LIBRARY_NOT_FOUND");
        }
        int oldPosn = libraries.indexOf(library);
        if (oldPosn == (adjustedNewPosn = ShiftLibraryCommand.checkAndAdjustPosition(oldPosn, newPosn, libraries.size()))) {
            return;
        }
        this.getActivityStack().startTrans();
        ShiftLibraryRecord record = new ShiftLibraryRecord(this.module, oldPosn, adjustedNewPosn);
        this.getActivityStack().execute(record);
        PropertyCommand cmd = new PropertyCommand(this.module, this.module);
        ElementPropertyDefn propDefn = this.module.getPropertyDefn("libraries");
        cmd.moveItem(new CachedMemberRef(propDefn), oldPosn, newPosn);
        this.getActivityStack().commit();
    }

    static {
        $assertionsDisabled = !ShiftLibraryCommand.class.desiredAssertionStatus();
    }
}

