/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.elements.strategy;

import java.util.Iterator;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.strategy.CopyPolicy;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public class CopyForPastePolicy
extends CopyPolicy {
    private static final CopyForPastePolicy instance = new CopyForPastePolicy();

    private CopyForPastePolicy() {
    }

    public void execute(DesignElement source, DesignElement destination) {
        if (destination.getExtendsName() == null && !destination.isVirtualElement()) {
            this.clearDisplayName(destination);
            return;
        }
        destination.setExtendsName(null);
        destination.setBaseId(-1L);
        Iterator iter = null;
        DesignElement current = null;
        if (!source.isVirtualElement()) {
            for (current = source.getExtendsElement(); current != null; current = current.getExtendsElement()) {
                if (!current.hasUserProperties()) continue;
                iter = current.getLocalUserProperties().iterator();
                while (iter.hasNext()) {
                    UserPropertyDefn uDefn = (UserPropertyDefn)iter.next();
                    if (destination.getLocalUserPropertyDefn(uDefn.getName()) != null) continue;
                    destination.addUserPropertyDefn((UserPropertyDefn)uDefn.copy());
                }
            }
        }
        iter = source.getPropertyDefns().iterator();
        Module module = source.getRoot();
        block2: while (iter.hasNext()) {
            String propName;
            ElementPropertyDefn propDefn = (ElementPropertyDefn)iter.next();
            if (!propDefn.canInherit() && !propDefn.isStyleProperty() || "style".equals(propName = propDefn.getName()) || "extends".equals(propName) || "userProperties".equals(propName) || destination.getLocalProperty(null, propDefn) != null) continue;
            DesignElement designElement = current = source.isVirtualElement() ? source.getVirtualParent() : source.getExtendsElement();
            while (current != null) {
                Object value = current.getLocalProperty(module, propDefn);
                if (value != null) {
                    destination.setProperty(propDefn, ModelUtil.copyValue(propDefn, value));
                    continue block2;
                }
                current = current.isVirtualElement() ? current.getVirtualParent() : current.getExtendsElement();
            }
        }
        this.clearDisplayName(destination);
    }

    private void clearDisplayName(DesignElement e) {
        if (e.getLocalProperty(null, "displayName") != null) {
            e.setProperty("displayName", null);
        }
        if (e.getLocalProperty(null, "displayNameID") != null) {
            e.setProperty("displayNameID", null);
        }
    }

    public static CopyForPastePolicy getInstance() {
        return instance;
    }
}

