/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.metadata;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.birt.report.model.api.metadata.PropertyValueException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;

public class ListPropertyType
extends PropertyType {
    private static Logger logger;
    private static final String DISPLAY_NAME_KEY = "Property.list";
    static final /* synthetic */ boolean $assertionsDisabled;

    public ListPropertyType() {
        super(DISPLAY_NAME_KEY);
    }

    public int getTypeCode() {
        return 20;
    }

    public String getName() {
        return "list";
    }

    public Object validateValue(Module module, PropertyDefn defn, Object value) throws PropertyValueException {
        if (value == null) {
            return null;
        }
        logger.log(Level.SEVERE, "Invalid value type: " + value);
        throw new PropertyValueException(value, "Error.PropertyValueException.INVALID_VALUE", 20);
    }

    public String toString(Module module, PropertyDefn defn, Object value) {
        if (value == null) {
            return null;
        }
        if (!$assertionsDisabled && !(value instanceof List)) {
            throw new AssertionError();
        }
        List valueList = (List)value;
        if (valueList.isEmpty()) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        PropertyType type = defn.getSubType();
        if (!$assertionsDisabled && type == null) {
            throw new AssertionError();
        }
        for (int i = 0; i < valueList.size(); ++i) {
            Object item = valueList.get(i);
            String stringValue = type.toString(module, defn, item);
            if (sb.length() > 0) {
                sb.append("; ");
            }
            if (stringValue == null) continue;
            sb.append(stringValue);
        }
        return sb.toString();
    }

    public int toInteger(Module module, Object value) {
        if (value == null) {
            return 0;
        }
        return ((ArrayList)value).size();
    }

    static {
        $assertionsDisabled = !ListPropertyType.class.desiredAssertionStatus();
        logger = Logger.getLogger(ListPropertyType.class.getName());
    }
}

