/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.net.URL;
import java.util.ArrayList;
import org.eclipse.birt.report.model.api.command.LibraryException;
import org.eclipse.birt.report.model.api.elements.structures.IncludedLibrary;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.ListPropertyState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.StructureState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.xml.sax.SAXException;

public class IncludedLibrariesStructureListState
extends ListPropertyState {
    IncludedLibrariesStructureListState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    public AbstractParseState startElement(String tagName) {
        int tagValue = tagName.toLowerCase().hashCode();
        if (ParserSchemaConstants.STRUCTURE_TAG == tagValue) {
            return new IncludedLibraryStructureState(this.handler, this.element, this.propDefn, this.list);
        }
        return super.startElement(tagName);
    }

    class IncludedLibraryStructureState
    extends StructureState {
        IncludedLibraryStructureState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, ArrayList theList) {
            super(theHandler, element, propDefn, theList);
        }

        public void end() throws SAXException {
            super.end();
            IncludedLibrary includeLibrary = (IncludedLibrary)this.struct;
            if (StringUtil.isBlank(includeLibrary.getNamespace())) {
                String fileName = StringUtil.extractFileName(includeLibrary.getFileName());
                includeLibrary.setNamespace(fileName);
            }
            String namespace = includeLibrary.getNamespace();
            if (this.handler.getModule().isDuplicateNamespace(namespace)) {
                LibraryException ex = new LibraryException(this.handler.module, new String[]{namespace}, "Error.LibraryException.DUPLICATE_LIBRARY_NAMESPACE");
                this.handler.getErrorHandler().semanticError((Exception)((Object)ex));
                return;
            }
            URL url = this.handler.module.findResource(includeLibrary.getFileName(), 2);
            if (url != null && this.handler.module.getLibraryByLocation(url.toString()) != null) {
                LibraryException ex = new LibraryException(this.handler.module, new String[]{url.toString()}, "Error.LibraryException.LIBRARY_ALREADY_INCLUDED");
                this.handler.getErrorHandler().semanticWarning((Exception)((Object)ex));
                return;
            }
            if (this.handler.module instanceof Library) {
                Library library = (Library)this.handler.module;
                if (url != null && library.isRecursiveFile(url.toString()) || library.isRecursiveNamespace(includeLibrary.getNamespace())) {
                    LibraryException ex = new LibraryException(this.handler.module, new String[]{namespace}, "Error.LibraryException.LIBRARY_INCLUDED_RECURSIVELY");
                    this.handler.getErrorHandler().semanticError((Exception)((Object)ex));
                    return;
                }
            }
            this.handler.module.loadLibrarySilently(includeLibrary);
        }
    }
}

