/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.command;

import org.eclipse.birt.report.model.api.ModelException;
import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.i18n.ModelMessages;
import org.eclipse.birt.report.model.metadata.MetaDataException;

public class UserPropertyException
extends SemanticException {
    private static final long serialVersionUID = -2257635814080094408L;
    protected String propertyName = null;
    public static final String DESIGN_EXCEPTION_NAME_REQUIRED = "Error.UserPropertyException.NAME_REQUIRED";
    public static final String DESIGN_EXCEPTION_DUPLICATE_NAME = "Error.UserPropertyException.DUPLICATE_NAME";
    public static final String DESIGN_EXCEPTION_INVALID_TYPE = "Error.UserPropertyException.INVALID_TYPE";
    public static final String DESIGN_EXCEPTION_INVALID_DEFINITION = "Error.UserPropertyException.INVALID_DEFINITION";
    public static final String DESIGN_EXCEPTION_MISSING_CHOICES = "Error.UserPropertyException.MISSING_CHOICES";
    public static final String DESIGN_EXCEPTION_INVALID_DISPLAY_ID = "Error.UserPropertyException.INVALID_DISPLAY_ID";
    public static final String DESIGN_EXCEPTION_NOT_FOUND = "Error.UserPropertyException.NOT_FOUND";
    public static final String DESIGN_EXCEPTION_USER_PROP_DISALLOWED = "Error.UserPropertyException.USER_PROP_DISALLOWED";
    public static final String DESIGN_EXCEPTION_CHOICE_VALUE_REQUIRED = "Error.UserPropertyException.CHOICE_VALUE_REQUIRED";
    public static final String DESIGN_EXCEPTION_CHOICE_NAME_REQUIRED = "Error.UserPropertyException.CHOICE_NAME_REQUIRED";
    public static final String DESIGN_EXCEPTION_INVALID_CHOICE_VALUE = "Error.UserPropertyException.INVALID_CHOICE_VALUE";
    public static final String DESIGN_EXCEPTION_INVALID_DEFAULT_VALUE = "Error.UserPropertyException.INVALID_DEFAULT_VALUE";
    static final /* synthetic */ boolean $assertionsDisabled;

    public UserPropertyException(DesignElement obj, String name, String errCode) {
        super(obj, errCode);
        this.propertyName = name;
    }

    public UserPropertyException(DesignElement obj, String name, String errCode, MetaDataException cause) {
        super(obj, errCode, (Throwable)((Object)cause));
        this.propertyName = name;
    }

    public UserPropertyException(DesignElement obj, String name, String errCode, ModelException cause, String[] args) {
        super(obj, args, errCode, (Throwable)((Object)cause));
        this.propertyName = name;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public String getLocalizedMessage() {
        if (this.sResourceKey == DESIGN_EXCEPTION_NOT_FOUND || this.sResourceKey == DESIGN_EXCEPTION_DUPLICATE_NAME || this.sResourceKey == DESIGN_EXCEPTION_INVALID_DISPLAY_ID || this.sResourceKey == DESIGN_EXCEPTION_CHOICE_NAME_REQUIRED || this.sResourceKey == DESIGN_EXCEPTION_CHOICE_VALUE_REQUIRED || this.sResourceKey == DESIGN_EXCEPTION_INVALID_CHOICE_VALUE) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{this.propertyName});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_USER_PROP_DISALLOWED) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{UserPropertyException.getElementName(this.element)});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_INVALID_DEFAULT_VALUE) {
            if (!$assertionsDisabled && this.oaMessageArguments.length != 2) {
                throw new AssertionError();
            }
            return ModelMessages.getMessage(this.sResourceKey, new String[]{UserPropertyException.getElementName(this.element), this.propertyName, (String)this.oaMessageArguments[0], (String)this.oaMessageArguments[1]});
        }
        return ModelMessages.getMessage(this.sResourceKey);
    }

    static {
        $assertionsDisabled = !UserPropertyException.class.desiredAssertionStatus();
    }
}

