/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.elements;

import org.eclipse.birt.report.model.api.activity.SemanticException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.i18n.ModelMessages;

public class SemanticError
extends SemanticException {
    private static final long serialVersionUID = -285983593958407463L;
    public static final String DESIGN_EXCEPTION_INCONSITENT_TABLE_COL_COUNT = "Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT";
    public static final String DESIGN_EXCEPTION_INCONSITENT_TABLE_COL_COUNT_WITH_DROP = "Error.SemanticError.INCONSISTENT_TABLE_COL_COUNT_COZ_DROP";
    public static final String DESIGN_EXCEPTION_INCONSITENT_GRID_COL_COUNT = "Error.SemanticError.INCONSISTENT_GRID_COL_COUNT";
    public static final String DESIGN_EXCEPTION_OVERLAPPING_CELLS = "Error.SemanticError.OVERLAPPING_CELLS";
    public static final String DESIGN_EXCEPTION_INCONSITENT_DROP_HEADINGS = "Error.SemanticError.INCONSISTENT_TABLE_DROP_HEADINGS";
    public static final String DESIGN_EXCEPTION_INVALID_PAGE_SIZE = "Error.SemanticError.INVALID_PAGE_SIZE";
    public static final String DESIGN_EXCEPTION_MISSING_PAGE_SIZE = "Error.SemanticError.MISSING_PAGE_SIZE";
    public static final String DESIGN_EXCEPTION_CANNOT_SPECIFY_PAGE_SIZE = "Error.SemanticError.CANNOT_SPECIFY_PAGE_SIZE";
    public static final String DESIGN_EXCEPTION_INVALID_PAGE_MARGINS = "Error.SemanticError.INVALID_PAGE_MARGINS";
    public static final String DESIGN_EXCEPTION_MISSING_MASTER_PAGE = "Error.SemanticError.MISSING_MASTER_PAGE";
    public static final String DESIGN_EXCEPTION_INVALID_MULTI_COLUMN = "Error.SemanticError.INVALID_MULTI_COLUMN";
    public static final String DESIGN_EXCEPTION_INVALID_ELEMENT_REF = "Error.SemanticError.INVALID_ELEMENT_REF";
    public static final String DESIGN_EXCEPTION_INVALID_STRUCTURE_REF = "Error.SemanticError.INVALID_STRUCTURE_REF";
    public static final String DESIGN_EXCEPTION_MISSING_SQL_STMT = "Error.SemanticError.MISSING_SQL_STMT";
    public static final String DESIGN_EXCEPTION_MISSING_DATA_SET = "Error.SemanticError.MISSING_DATA_SET";
    public static final String DESIGN_EXCEPTION_IMAGE_FILE_NOT_EXIST = "Error.SemanticError.IMAGE_FILE_NOT_FOUND";
    public static final String DESIGN_EXCEPTION_INVALID_PROPERTY_NAME = "Error.SemanticError.INVALID_PROPERTY_NAME";
    public static final String DESIGN_EXCEPTION_UNSUPPORTED_ELEMENT = "Error.SemanticError.UNSUPPORTED_ELEMENT";
    public static final String DESIGN_EXCEPTION_AT_LEAST_ONE_COLUMN = "Error.SemanticError.AT_LEAST_ONE_COLUMN";
    public static final String DESIGN_EXCEPTION_DUPLICATE_GROUP_NAME = "Error.SemanticError.DUPLICATE_GROUP_NAME";
    public static final String DESIGN_EXCEPTION_INVALID_CUSTOM_COLOR_NAME = "Error.SemanticError.INVALID_CUSTOM_COLOR_NAME";
    public static final String DESIGN_EXCEPTION_DUPLICATE_CUSTOM_COLOR_NAME = "Error.SemanticError.DUPLICATE_CUSTOM_COLOR_NAME";
    public static final String DESIGN_EXCEPTION_EXTENSION_NOT_FOUND = "Error.SemanticError.EXTENSION_NOT_FOUND";
    public static final String DESIGN_EXCEPTION_MISSING_EXTENSION = "Error.SemanticError.MISSING_EXTENSION";
    public static final String DESIGN_EXCEPTION_PROPERTY_COPY_FORBIDDEN = "Error.SemanticError.PROPERTY_COPY_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_ROW_COPY_FORBIDDEN = "Error.SemanticError.ROW_COPY_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_ROW_PASTE_FORBIDDEN = "Error.SemanticError.ROW_PASTE_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_ROW_INSERTANDPASTE_FORBIDDEN = "Error.SemanticError.ROW_INSERTANDPASTE_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_ROW_INSERT_FORBIDDEN = "Error.SemanticError.ROW_INSERT_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_ROW_SHIFT_FORBIDDEN = "Error.SemanticError.ROW_SHIFT_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_COLUMN_COPY_FORBIDDEN = "Error.SemanticError.COLUMN_COPY_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_COLUMN_PASTE_FORBIDDEN = "Error.SemanticError.COLUMN_PASTE_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_COLUMN_PASTE_DIFFERENT_LAYOUT = "Error.SemanticError.COLUMN_PASTE_DIFFERENT_LAYOUT";
    public static final String DESIGN_EXCEPTION_COLUMN_INSERT_FORBIDDEN = "Error.SemanticError.COLUMN_INSERT_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_INVALID_SCALAR_PARAMETER_TYPE = "Error.SemanticError.INVALID_SCALAR_PARAMETER_TYPE";
    public static final String DESIGN_EXCEPTION_MISSING_TEMPLATE_PARAMETER_TYPE = "Error.SemanticError.MISSING_TEMPLATE_PARAMETER_TYPE";
    public static final String DESIGN_EXCEPTION_INVALID_LIBRARY_REFERENCE = "Error.SemanticError.INVALID_LIBRARY_REFERENCE";
    public static final String DESIGN_EXCEPTION_INCONSISTENT_TEMPLATE_PARAMETER_TYPE = "Error.SemanticError.INCONSISTENT_TEMPLATE_PARAMETER_TYPE";
    public static final String DESIGN_EXCEPTION_INVALID_PROPERTY_BINDING_ID = "Error.SemanticError.INVALID_PROPERTY_BINDING_ID";
    public static final String DESIGN_EXCEPTION_PROPERTY_BINDING_FORBIDDEN = "Error.SemanticError.PROPERTY_BINDING_FORBIDDEN";
    public static final String DESIGN_EXCEPTION_INVALID_MASTER_PAGE_CONTEXT_CONTAINMENT = "Error.SemanticError.INVALID_MASTER_PAGE_CONTEXT_CONTAINMENT";
    public static final String DESIGN_EXCEPTION_DATA_SET_MISSED_IN_JOINT_DATA_SET = "Error.SemanticError.DATA_SET_MISSED_IN_JOINT_DATA_SET";
    public static final String DESIGN_EXCEPTION_MISSING_COLUMN_BINDING = "Error.SemanticError.MISSING_COLUMN_BINDING";
    public static final int ERROR = 0;
    public static final int WARNING = 1;
    private int errorLevel = 0;
    static final /* synthetic */ boolean $assertionsDisabled;

    public SemanticError(DesignElement element, String errCode) {
        super(element, errCode);
    }

    public SemanticError(DesignElement element, String[] values, String errCode) {
        super(element, values, errCode);
    }

    public SemanticError(DesignElement element, String errCode, int level) {
        super(element, errCode);
        this.errorLevel = level;
    }

    public SemanticError(DesignElement element, String[] values, String errCode, int level) {
        super(element, values, errCode);
        this.errorLevel = level;
    }

    public String getLocalizedMessage() {
        if (this.sResourceKey == DESIGN_EXCEPTION_UNSUPPORTED_ELEMENT || this.sResourceKey == DESIGN_EXCEPTION_MISSING_EXTENSION) {
            return ModelMessages.getMessage(this.sResourceKey, new String[]{this.element.getElementName()});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_INVALID_ELEMENT_REF || this.sResourceKey == DESIGN_EXCEPTION_INVALID_STRUCTURE_REF) {
            if (!$assertionsDisabled && this.oaMessageArguments == null) {
                throw new AssertionError();
            }
            return ModelMessages.getMessage(this.sResourceKey, new String[]{this.element.getIdentifier(), (String)this.oaMessageArguments[0], (String)this.oaMessageArguments[1]});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_DUPLICATE_GROUP_NAME || this.sResourceKey == DESIGN_EXCEPTION_EXTENSION_NOT_FOUND || this.sResourceKey == DESIGN_EXCEPTION_MISSING_COLUMN_BINDING) {
            if (!$assertionsDisabled && this.oaMessageArguments == null) {
                throw new AssertionError();
            }
            return ModelMessages.getMessage(this.sResourceKey, new String[]{this.element.getIdentifier(), (String)this.oaMessageArguments[0]});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_IMAGE_FILE_NOT_EXIST || this.sResourceKey == DESIGN_EXCEPTION_INVALID_PROPERTY_NAME) {
            if (!$assertionsDisabled && this.oaMessageArguments == null) {
                throw new AssertionError();
            }
            return ModelMessages.getMessage(this.sResourceKey, new String[]{(String)this.oaMessageArguments[0], this.element.getIdentifier()});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_INVALID_CUSTOM_COLOR_NAME || this.sResourceKey == DESIGN_EXCEPTION_DUPLICATE_CUSTOM_COLOR_NAME || this.sResourceKey == DESIGN_EXCEPTION_PROPERTY_COPY_FORBIDDEN) {
            if (!$assertionsDisabled && this.oaMessageArguments == null) {
                throw new AssertionError();
            }
            return ModelMessages.getMessage(this.sResourceKey, new String[]{(String)this.oaMessageArguments[0]});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_OVERLAPPING_CELLS) {
            if (!$assertionsDisabled && this.oaMessageArguments == null) {
                throw new AssertionError();
            }
            if (this.oaMessageArguments[1] == null || StringUtil.isBlank(this.oaMessageArguments[1].toString())) {
                return ModelMessages.getMessage(this.sResourceKey, new String[]{(String)this.oaMessageArguments[0]});
            }
            return ModelMessages.getMessage(this.sResourceKey, new String[]{(String)this.oaMessageArguments[0] + " \"" + (String)this.oaMessageArguments[1] + "\""});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_MISSING_DATA_SET) {
            String name = this.element.getName();
            if (StringUtil.isBlank(name)) {
                return ModelMessages.getMessage(this.sResourceKey, new String[]{"The " + this.element.getElementName()});
            }
            return ModelMessages.getMessage(this.sResourceKey, new String[]{"The " + this.element.getElementName() + " \"" + name + "\""});
        }
        if (this.sResourceKey == DESIGN_EXCEPTION_INVALID_PROPERTY_BINDING_ID) {
            if (!$assertionsDisabled && this.oaMessageArguments.length != 1) {
                throw new AssertionError();
            }
            return ModelMessages.getMessage(this.sResourceKey, new String[]{this.element.getIdentifier(), (String)this.oaMessageArguments[0]});
        }
        if (this.oaMessageArguments != null) {
            return ModelMessages.getMessage(this.sResourceKey, this.oaMessageArguments);
        }
        return ModelMessages.getMessage(this.sResourceKey, new String[]{this.element.getIdentifier()});
    }

    public int getErrorLevel() {
        return this.errorLevel;
    }

    static {
        $assertionsDisabled = !SemanticError.class.desiredAssertionStatus();
    }
}

