/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.command;

import java.util.List;
import org.eclipse.birt.report.model.activity.AbstractElementCommand;
import org.eclipse.birt.report.model.activity.ActivityStack;
import org.eclipse.birt.report.model.api.StyleHandle;
import org.eclipse.birt.report.model.api.ThemeHandle;
import org.eclipse.birt.report.model.api.command.NameException;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.api.validators.ThemeStyleNameValidator;
import org.eclipse.birt.report.model.command.NameRecord;
import org.eclipse.birt.report.model.command.NameSpaceRecord;
import org.eclipse.birt.report.model.command.RenameInNameSpaceRecord;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Library;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.metadata.ElementDefn;

public class NameCommand
extends AbstractElementCommand {
    static final /* synthetic */ boolean $assertionsDisabled;

    public NameCommand(Module module, DesignElement obj) {
        super(module, obj);
    }

    public void setName(String name) throws NameException {
        name = StringUtil.trimString(name);
        String oldName = this.element.getName();
        if (name == null && oldName == null || name != null && oldName != null && name.equals(oldName)) {
            return;
        }
        this.checkName(name);
        ActivityStack stack = this.getActivityStack();
        NameRecord rename = new NameRecord(this.element, name);
        stack.startTrans(rename.getLabel());
        stack.execute(rename);
        this.renameSymbolFrom(oldName);
        stack.commit();
    }

    public void checkName(String name) throws NameException {
        ElementDefn metaData = (ElementDefn)this.element.getDefn();
        if (name == null) {
            if (this.element.hasDerived() || this.element.hasReferences()) {
                throw new NameException(this.element, name, "Error.NameException.HAS_REFERENCES");
            }
            if (metaData.getNameOption() == 2) {
                throw new NameException(this.element, name, "Error.NameException.NAME_REQUIRED");
            }
            if (this.module instanceof Library && this.element.getContainer() instanceof Library) {
                throw new NameException(this.element, name, "Error.NameException.NAME_REQUIRED");
            }
        } else {
            if (!this.isNameValidInContext(name)) {
                throw new NameException(this.element, name, "Error.NameException.DUPLICATE");
            }
            if (metaData.getNameOption() == 0) {
                throw new NameException(this.element, name, "Error.NameException.NAME_FORBIDDEN");
            }
            if (name.indexOf(".") != -1) {
                throw new NameException(this.element, name, "Error.NameException.DOT_FORBIDDEN");
            }
            if (!this.element.isManagedByNameSpace()) {
                return;
            }
            int ns = metaData.getNameSpaceID();
            DesignElement existedElement = this.getModule().getNameSpace(ns).getElement(name);
            if (existedElement != null) {
                throw new NameException(this.element, name, "Error.NameException.DUPLICATE");
            }
        }
    }

    protected void addElement() throws NameException {
        this.checkName(this.element.getName());
        this.addSymbol();
    }

    protected void dropElement() {
        this.dropSymbol();
    }

    private void addSymbol() {
        if (this.element.getName() == null) {
            return;
        }
        if (!this.element.isManagedByNameSpace()) {
            return;
        }
        if (!$assertionsDisabled && this.element.getRoot() == null) {
            throw new AssertionError();
        }
        int ns = ((ElementDefn)this.element.getDefn()).getNameSpaceID();
        DesignElement existedElement = this.getModule().getNameSpace(ns).getElement(this.element.getName());
        if (!$assertionsDisabled && existedElement != null) {
            throw new AssertionError();
        }
        if (existedElement == null) {
            this.getActivityStack().execute(new NameSpaceRecord(this.getModule(), ns, this.element, true));
        }
    }

    private void dropSymbol() {
        if (this.element.getName() == null) {
            return;
        }
        int ns = ((ElementDefn)this.element.getDefn()).getNameSpaceID();
        if (this.module.getNameSpace(ns).getElement(this.element.getName()) != this.element) {
            return;
        }
        this.getActivityStack().execute(new NameSpaceRecord(this.getModule(), ns, this.element, false));
    }

    private void renameSymbolFrom(String oldName) {
        if (this.element.isManagedByNameSpace()) {
            RenameInNameSpaceRecord record = new RenameInNameSpaceRecord(this.getModule(), this.element, oldName, this.element.getName());
            this.getActivityStack().execute(record);
        }
    }

    private boolean isNameValidInContext(String name) {
        List errors;
        DesignElement tmpContainer;
        return !(this.element instanceof Style) || !((tmpContainer = this.element.getContainer()) instanceof Theme) || (errors = ThemeStyleNameValidator.getInstance().validateForRenamingStyle((ThemeHandle)tmpContainer.getHandle(this.module), (StyleHandle)this.element.getHandle(this.module), name)).isEmpty();
    }

    static {
        $assertionsDisabled = !NameCommand.class.desiredAssertionStatus();
    }
}

