/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.ComputedColumn;
import org.eclipse.birt.report.model.api.elements.structures.DataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.OdaDataSetParameter;
import org.eclipse.birt.report.model.api.elements.structures.OdaDesignerState;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.GraphicMasterPage;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.parser.AbstractPropertyState;
import org.eclipse.birt.report.model.parser.Base64PropertyState;
import org.eclipse.birt.report.model.parser.CompatibleColumnDataTypeState;
import org.eclipse.birt.report.model.parser.CompatibleFormatPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleIgnorePropertyState;
import org.eclipse.birt.report.model.parser.CompatibleMiscExpressionState;
import org.eclipse.birt.report.model.parser.CompatibleOnRowPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleOperatorState;
import org.eclipse.birt.report.model.parser.CompatiblePageBreakPropState;
import org.eclipse.birt.report.model.parser.CompatiblePropertyTypeState;
import org.eclipse.birt.report.model.parser.CompatibleRenamedPropertyState;
import org.eclipse.birt.report.model.parser.CompatibleVerticalAlignState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.RecoverableError;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.xml.sax.SAXException;

class PropertyState
extends AbstractPropertyState {
    private static final int GROUP_START_PROP = "groupStart".toLowerCase().hashCode();
    private static final int CHEET_SHEET = "cheetSheet".toLowerCase().hashCode();
    private static final int FILTER_OPERATOR_MEMBER = "operator".toLowerCase().hashCode();
    private static final int MAPRULE_OPERATOR_MEMBER = "operator".toLowerCase().hashCode();
    private static final int DATE_TIME_FORMAT_STRUCT = "DateTimeFormatValue".toLowerCase().hashCode();
    private static final int NUMBER_FORMAT_STRUCT = "NumberFormatValue".toLowerCase().hashCode();
    private static final int STRING_FORMAT_STRUCT = "StringFormatValue".toLowerCase().hashCode();
    private static final int PARAM_FORMAT_STRUCT = "ParameterFormatValue".toLowerCase().hashCode();
    private static final int HEADER_HEIGHT = "headerHeight".toLowerCase().hashCode();
    private static final int FOOTER_HEIGHT = "footerHeight".toLowerCase().hashCode();
    private static final int PAGE_BREAK_BEFORE_PROP = "pageBreakBefore".toLowerCase().hashCode();
    private static final int PAGE_BREAK_AFTER_PROP = "pageBreakAfter".toLowerCase().hashCode();
    private static final int PAGE_BREAK_INSIDE_PROP = "pageBreakInside".toLowerCase().hashCode();
    private static final int THUMBNAIL_PROP = "thumbnail".toLowerCase().hashCode();
    private static final int DATA_MEMBER = "data".toLowerCase().hashCode();
    private static final int CONTENT_AS_BLOB_MEMBER = "stateContentAsBlob".toLowerCase().hashCode();
    private static final int ON_CREATE_METHOD = "onCreate".toLowerCase().hashCode();
    private static final int CACHED_ROW_COUNT_PROP = "cachedRowCount".toLowerCase().hashCode();
    private static final int CHOICE_VERTICAL_ALIGN = "verticalAlign".toLowerCase().hashCode();
    private static final int DEFAULT_VALUE_PROP = "defaultValue".toLowerCase().hashCode();
    private static final int DATA_TYPE_MEMBER = "dataType".toLowerCase().hashCode();
    protected PropertyDefn propDefn = null;

    PropertyState(ModuleParserHandler theHandler, DesignElement element) {
        super(theHandler, element);
    }

    PropertyState(ModuleParserHandler theHandler, DesignElement element, PropertyDefn propDefn, IStructure struct) {
        super(theHandler, element);
        this.propDefn = propDefn;
        this.struct = struct;
    }

    protected void setName(String name) {
        super.setName(name);
        this.propDefn = this.struct != null ? (PropertyDefn)this.struct.getDefn().getMember(name) : this.element.getPropertyDefn(name);
    }

    public void end() throws SAXException {
        String value = this.text.toString();
        this.doEnd(value);
    }

    protected void doEnd(String value) {
        if (this.struct != null) {
            this.setMember(this.struct, this.propDefn.getName(), this.name, value);
            return;
        }
        if ("style".equalsIgnoreCase(this.name)) {
            if (!this.element.getDefn().hasStyle()) {
                DesignParserException e = new DesignParserException(new String[]{this.name}, "Error.DesignParserException.UNDEFINED_PROPERTY");
                RecoverableError.dealUndefinedProperty(this.handler, e);
                return;
            }
            ((StyledElement)this.element).setStyleName(value);
        } else {
            this.setProperty(this.name, value);
        }
    }

    protected AbstractParseState generalJumpTo() {
        if (this.element instanceof ReportDesign && THUMBNAIL_PROP == this.nameValue) {
            Base64PropertyState state = new Base64PropertyState(this.handler, this.element, "8859_1");
            state.setName(this.name);
            return state;
        }
        if (this.struct instanceof EmbeddedImage && DATA_MEMBER == this.nameValue) {
            Base64PropertyState state = new Base64PropertyState(this.handler, this.element, this.propDefn, this.struct, "8859_1");
            state.setName(this.name);
            return state;
        }
        if (this.struct instanceof OdaDesignerState && CONTENT_AS_BLOB_MEMBER == this.nameValue) {
            Base64PropertyState state = new Base64PropertyState(this.handler, this.element, this.propDefn, this.struct, "8859_1");
            state.setName(this.name);
            return state;
        }
        if (ON_CREATE_METHOD == this.nameValue) {
            CompatibleMiscExpressionState state = new CompatibleMiscExpressionState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        return super.generalJumpTo();
    }

    protected AbstractParseState versionConditionalJumpTo() {
        IPropertyDefn jmpDefn = null;
        jmpDefn = this.struct != null ? this.struct.getDefn().getMember(this.name) : this.element.getPropertyDefn(this.name);
        if (this.handler.versionNumber <= 3020700) {
            PropertyState state;
            if (this.element instanceof ListGroup && GROUP_START_PROP == this.nameValue) {
                CompatibleRenamedPropertyState state2 = new CompatibleRenamedPropertyState(this.handler, this.element, "groupStart");
                state2.setName("intervalBase");
                return state2;
            }
            if (this.element instanceof ReportDesign && CHEET_SHEET == this.nameValue) {
                CompatibleRenamedPropertyState state3 = new CompatibleRenamedPropertyState(this.handler, this.element, "cheetSheet");
                state3.setName("cheatSheet");
                return state3;
            }
            int jmpDefnValue = -1;
            int jmpStructDefnValue = -1;
            if (jmpDefn != null) {
                jmpDefnValue = jmpDefn.getName().toLowerCase().hashCode();
                IStructureDefn structDefn = jmpDefn.getStructDefn();
                if (structDefn != null) {
                    jmpStructDefnValue = structDefn.getName().toLowerCase().hashCode();
                }
            }
            if (FILTER_OPERATOR_MEMBER == jmpDefnValue || MAPRULE_OPERATOR_MEMBER == jmpDefnValue) {
                state = new CompatibleOperatorState(this.handler, this.element, this.propDefn, this.struct);
                state.setName(this.name);
                return state;
            }
            if (DATE_TIME_FORMAT_STRUCT == jmpStructDefnValue || NUMBER_FORMAT_STRUCT == jmpStructDefnValue || STRING_FORMAT_STRUCT == jmpStructDefnValue || PARAM_FORMAT_STRUCT == jmpStructDefnValue) {
                state = new CompatibleFormatPropertyState(this.handler, this.element, this.propDefn, this.struct);
                state.setName(this.name);
                ((CompatibleFormatPropertyState)state).createStructure();
                return state;
            }
            if (this.element instanceof GraphicMasterPage && (HEADER_HEIGHT == this.nameValue || FOOTER_HEIGHT == this.nameValue)) {
                return new CompatibleIgnorePropertyState(this.handler, this.element);
            }
            if (this.element instanceof ListingElement || this.element instanceof GroupElement) {
                if ("pageBreakInterval".equalsIgnoreCase(this.name) && this.element instanceof GroupElement) {
                    return new CompatibleIgnorePropertyState(this.handler, this.element);
                }
                if (this.name.equalsIgnoreCase("onStart") || this.name.equalsIgnoreCase("onFinish")) {
                    return new CompatibleIgnorePropertyState(this.handler, this.element);
                }
                if ("onRow".equalsIgnoreCase(this.name) && !(this.element instanceof TableItem)) {
                    return new CompatibleIgnorePropertyState(this.handler, this.element);
                }
                if ("onRow".equalsIgnoreCase(this.name)) {
                    return new CompatibleOnRowPropertyState(this.handler, this.element);
                }
            }
            if (this.element instanceof GroupElement && ("onCreate".equalsIgnoreCase(this.name) || "onRender".equalsIgnoreCase(this.name))) {
                return new CompatibleIgnorePropertyState(this.handler, this.element);
            }
            if (PAGE_BREAK_BEFORE_PROP == this.nameValue || PAGE_BREAK_AFTER_PROP == this.nameValue || PAGE_BREAK_INSIDE_PROP == this.nameValue) {
                state = new CompatiblePageBreakPropState(this.handler, this.element);
                state.setName(this.name);
                return state;
            }
        }
        if (this.handler.versionNumber < 3020700 && this.element instanceof DataSet && CACHED_ROW_COUNT_PROP == this.nameValue) {
            CompatibleRenamedPropertyState state = new CompatibleRenamedPropertyState(this.handler, this.element, "cachedRowCount");
            state.setName("dataSetRowLimit");
            return state;
        }
        if (this.handler.versionNumber < 3020200 && CHOICE_VERTICAL_ALIGN == this.nameValue) {
            CompatibleVerticalAlignState state = new CompatibleVerticalAlignState(this.handler, this.element);
            state.setName("verticalAlign");
            return state;
        }
        if (this.handler.versionNumber < 3020400 && this.element instanceof ScalarParameter && DEFAULT_VALUE_PROP == this.nameValue) {
            CompatiblePropertyTypeState state = new CompatiblePropertyTypeState(this.handler, this.element);
            state.setName("defaultValue");
            return state;
        }
        if (this.handler.versionNumber <= 3020000 && this.struct instanceof DataSetParameter && "isNullable".equals(this.name)) {
            CompatibleRenamedPropertyState state = new CompatibleRenamedPropertyState(this.handler, this.element, this.propDefn, this.struct, "isNullable");
            state.setName("allowNull");
            return state;
        }
        if (ON_CREATE_METHOD == this.nameValue && this.handler.versionNumber < 3020000) {
            CompatibleMiscExpressionState state = new CompatibleMiscExpressionState(this.handler, this.element);
            state.setName(this.name);
            return state;
        }
        if (this.struct instanceof ComputedColumn && "aggregrateOn".toLowerCase().hashCode() == this.nameValue && (this.element instanceof ScalarParameter || this.element instanceof ReportItem) & this.handler.versionNumber <= 3020200) {
            CompatibleRenamedPropertyState state = new CompatibleRenamedPropertyState(this.handler, this.element, this.propDefn, this.struct, "aggregrateOn");
            state.setName("aggregateOn");
            return state;
        }
        if (this.handler.versionNumber < 3020600 && (this.struct instanceof DataSetParameter || this.struct instanceof OdaDataSetParameter) && DATA_TYPE_MEMBER == this.nameValue) {
            CompatibleColumnDataTypeState state = new CompatibleColumnDataTypeState(this.handler, this.element, this.propDefn, this.struct);
            state.setName("dataType");
            return state;
        }
        return super.versionConditionalJumpTo();
    }
}

