/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.ElementFactory;
import org.eclipse.birt.report.model.api.ExtendedItemHandle;
import org.eclipse.birt.report.model.api.IllegalOperationException;
import org.eclipse.birt.report.model.api.command.ExtendsException;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.metadata.IElementDefn;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.Structure;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.DataSource;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.ReportDesign;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.Theme;
import org.eclipse.birt.report.model.extension.IExtendableElement;
import org.eclipse.birt.report.model.metadata.ElementDefn;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ElementRefValue;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.SlotDefn;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructRefValue;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.util.ModelUtil;
import org.eclipse.birt.report.model.util.StructureRefUtil;

public class ReportDesignSerializer
extends ElementVisitor {
    private ReportDesign targetDesign = null;
    private ReportDesign sourceDesign = null;
    private Stack elements = new Stack();
    private Map externalElements = new LinkedHashMap();
    private Map externalStructs = new LinkedHashMap();
    private DesignElement currentNewElement = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ReportDesign getTarget() {
        return this.targetDesign;
    }

    public void visitReportDesign(ReportDesign obj) {
        this.sourceDesign = obj;
        this.targetDesign = this.localizeDesign(obj);
        this.visitSlots(obj, this.targetDesign, 9);
        this.localizeExternalSelectors();
        this.addExternalElements();
        this.addExternalStructures();
        this.release();
        this.targetDesign.getVersionManager().setVersion(this.sourceDesign.getVersionManager().getVersion());
    }

    private void release() {
        this.elements = null;
        this.externalElements = null;
        this.externalStructs = null;
        this.currentNewElement = null;
    }

    public void visitDesignElement(DesignElement obj) {
        int slotCount;
        DesignElement newElement = this.localize(obj);
        ElementDefn elementDefn = (ElementDefn)obj.getDefn();
        if (elementDefn.isContainer() && (slotCount = elementDefn.getSlotCount()) > 0) {
            this.visitSlots(obj, newElement, slotCount);
        }
        this.currentNewElement = newElement;
    }

    private void addExternalStructures() {
        ArrayList<EmbeddedImage> images = (ArrayList<EmbeddedImage>)this.targetDesign.getLocalProperty((Module)this.targetDesign, "images");
        if (images == null) {
            images = new ArrayList<EmbeddedImage>();
            this.targetDesign.setProperty("images", images);
        }
        Iterator embeddedImages = this.externalStructs.values().iterator();
        while (embeddedImages.hasNext()) {
            EmbeddedImage image = (EmbeddedImage)embeddedImages.next();
            this.targetDesign.rename(image);
            images.add(image);
        }
    }

    private void addExternalElements() {
        DesignElement[] elementArray = new DesignElement[this.externalElements.size()];
        this.externalElements.keySet().toArray(elementArray);
        for (int i = 0; i < elementArray.length; ++i) {
            DesignElement originalElement = elementArray[i];
            int slotId = originalElement.getContainerSlot();
            DesignElement tmpElement = (DesignElement)this.externalElements.get(originalElement);
            DesignElement tmpContainer = this.getTargetContainer(originalElement, tmpElement);
            if (tmpContainer == null) continue;
            tmpContainer.getSlot(slotId).add(tmpElement);
            tmpElement.setContainer(tmpContainer, slotId);
            this.targetDesign.manageId(tmpElement, true);
            ModelUtil.addElement2NameSpace(this.targetDesign, tmpElement);
        }
    }

    public void visitStyle(Style obj) {
        this.visitDesignElement(obj);
    }

    public void visitTheme(Theme obj) {
    }

    public void visitReportItem(ReportItem obj) {
        this.visitStyledElement(obj);
    }

    public void visitScalarParameter(ScalarParameter obj) {
        this.visitParameter(obj);
    }

    public void visitStyledElement(StyledElement obj) {
        this.visitDesignElement(obj);
        this.localizeStyle((StyledElement)this.currentNewElement, obj);
    }

    private void localizeStyle(StyledElement target, StyledElement source) {
        HashSet notEmptyProperties = new HashSet();
        this.localizeSelfStyleProperties(target, source, notEmptyProperties);
        notEmptyProperties.clear();
    }

    private void localizeExternalSelectors() {
        if (!$assertionsDisabled && !this.elements.isEmpty()) {
            throw new AssertionError();
        }
        this.elements.push(this.targetDesign);
        Theme theme = this.sourceDesign.getTheme(this.sourceDesign);
        if (theme == null) {
            this.elements.pop();
            return;
        }
        Module tmpRoot = theme.getRoot();
        ContainerSlot styles = theme.getSlot(0);
        for (int i = 0; i < styles.getCount(); ++i) {
            Style tmpStyle = (Style)styles.getContent(i);
            this.visitExternalSelector(tmpStyle, tmpRoot);
        }
        this.elements.pop();
    }

    private void localizeSelfStyleProperties(StyledElement target, StyledElement source, Set notEmptyProperties) {
        StyledElement tmpElement = source;
        while (tmpElement != null) {
            Module root = tmpElement.getRoot();
            this.localizePrivateStyleProperties(target, tmpElement, root, notEmptyProperties);
            Style style = (Style)tmpElement.getStyle();
            if (style != null) {
                Module styleRoot = style.getRoot();
                if (styleRoot != this.sourceDesign) {
                    this.localizePrivateStyleProperties(target, style, styleRoot, notEmptyProperties);
                } else {
                    target.setStyleName(tmpElement.getStyleName());
                }
            }
            if (tmpElement.isVirtualElement()) {
                tmpElement = (StyledElement)tmpElement.getVirtualParent();
                continue;
            }
            tmpElement = (StyledElement)tmpElement.getExtendsElement();
        }
    }

    private void localizePrivateStyleProperties(DesignElement target, DesignElement source, Module root, Set notEmptyProperties) {
        if (!source.hasLocalPropertyValues()) {
            return;
        }
        IElementDefn defn = source.getDefn();
        Iterator iter = source.propertyWithLocalValueIterator();
        while (iter.hasNext()) {
            ElementPropertyDefn targetProp;
            String propName;
            ElementPropertyDefn prop = (ElementPropertyDefn)defn.getProperty((String)iter.next());
            if (prop == null || !prop.isStyleProperty() || notEmptyProperties.contains(propName = prop.getName()) || (targetProp = target.getPropertyDefn(propName)) == null) continue;
            if (target.getLocalProperty((Module)this.targetDesign, prop) != null) {
                notEmptyProperties.add(propName);
                continue;
            }
            Object value = source.getLocalProperty(root, prop);
            if (value == null) continue;
            switch (targetProp.getTypeCode()) {
                case 20: {
                    target.setProperty(targetProp, ModelUtil.copyValue(targetProp, value));
                    break;
                }
                case 16: {
                    this.handleStructureValue(target, targetProp, value);
                    break;
                }
                default: {
                    target.setProperty(targetProp, ModelUtil.copyValue(targetProp, value));
                }
            }
            notEmptyProperties.add(propName);
        }
    }

    public void visitMasterPage(MasterPage obj) {
        this.visitStyledElement(obj);
    }

    public void visitGroup(GroupElement obj) {
        this.visitDesignElement(obj);
    }

    public void visitRow(TableRow obj) {
        this.visitStyledElement(obj);
    }

    public void visitCell(Cell obj) {
        this.visitStyledElement(obj);
    }

    public void visitColumn(TableColumn obj) {
        this.visitStyledElement(obj);
    }

    public void visitDataSet(DataSet obj) {
        this.visitDesignElement(obj);
    }

    public void visitDataSource(DataSource obj) {
        this.visitDesignElement(obj);
    }

    public void visitTemplateParameterDefinition(TemplateParameterDefinition obj) {
        this.visitDesignElement(obj);
    }

    private void visitSlots(DesignElement obj, DesignElement newElement, int slotCount) {
        this.elements.push(newElement);
        for (int i = 0; i < slotCount; ++i) {
            this.visitContents(obj.getSlot(i));
        }
        this.elements.pop();
    }

    private DesignElement createNewElement(DesignElement element) {
        int ns;
        DesignElement sourceContainer = element.getContainer();
        SlotDefn slotDefn = (SlotDefn)sourceContainer.getDefn().getSlot(element.getContainerSlot());
        DesignElement newElement = this.newElement(element.getDefn().getName(), element.getName(), slotDefn).getElement();
        Set externalOriginalElements = this.externalElements.keySet();
        if (externalOriginalElements.contains(element)) {
            return newElement;
        }
        if (element instanceof ReportDesign) {
            return newElement;
        }
        DesignElement container = (DesignElement)this.elements.peek();
        newElement.setID(element.getID());
        int slotId = element.getContainerSlot();
        newElement.setContainer(container, slotId);
        container.getSlot(slotId).add(newElement);
        if (slotDefn.isManagedByNameSpace() && newElement.getName() != null && (ns = ((ElementDefn)newElement.getDefn()).getNameSpaceID()) >= 0) {
            this.targetDesign.getNameSpace(ns).insert(newElement);
        }
        this.targetDesign.addElementID(newElement);
        return newElement;
    }

    private IStructure visitExternalStruct(IStructure struct) {
        IStructure newStrcut = struct.copy();
        this.cacheMapping(struct, newStrcut);
        return newStrcut;
    }

    private DesignElement localize(DesignElement element) {
        DesignElement newElement = this.createNewElement(element);
        this.localizePropertyValues(element, newElement);
        return newElement;
    }

    private ReportDesign localizeDesign(ReportDesign source) {
        ReportDesign design = new ReportDesign(source.getSession());
        this.localizePropertyValues(source, design);
        return design;
    }

    private DesignElement visitExternalElement(DesignElement element) {
        if (element instanceof Theme) {
            return null;
        }
        ElementFactory factory = new ElementFactory(this.sourceDesign);
        DesignElement newElement = factory.newElement(element.getDefn().getName(), element.getName()).getElement();
        this.localizePropertyValues(element, newElement);
        this.cacheMapping(element, newElement);
        return newElement;
    }

    private void visitExternalSelector(Style element, Module elementRoot) {
        String tmpStyleName = element.getName().toLowerCase();
        if (MetaDataDictionary.getInstance().getPredefinedStyle(tmpStyleName) == null) {
            return;
        }
        Style sourceDesignStyle = (Style)this.targetDesign.findNativeStyle(tmpStyleName);
        if (sourceDesignStyle == null) {
            ElementFactory factory = new ElementFactory(this.targetDesign);
            DesignElement newElement = factory.newElement(element.getDefn().getName(), element.getName()).getElement();
            this.localizePropertyValues(element, newElement);
            this.cacheMapping(element, newElement);
            newElement.setName(tmpStyleName);
            return;
        }
        Iterator iter1 = element.propertyWithLocalValueIterator();
        while (iter1.hasNext()) {
            String elem = (String)iter1.next();
            if (sourceDesignStyle.getLocalProperty((Module)this.targetDesign, elem) != null) continue;
            Object value = element.getLocalProperty(elementRoot, elem);
            sourceDesignStyle.setProperty(elem, value);
        }
    }

    private void localizeUserPropDefn(DesignElement element, DesignElement newElement) {
        Iterator iter = null;
        DesignElement current = null;
        if (!element.isVirtualElement()) {
            for (current = element.getExtendsElement(); current != null; current = current.getExtendsElement()) {
                if (!current.hasUserProperties()) continue;
                iter = current.getLocalUserProperties().iterator();
                while (iter.hasNext()) {
                    UserPropertyDefn uDefn = (UserPropertyDefn)iter.next();
                    if (element.getLocalUserPropertyDefn(uDefn.getName()) != null) continue;
                    newElement.addUserPropertyDefn((UserPropertyDefn)uDefn.copy());
                }
            }
        }
    }

    private void localizePropertyValues(DesignElement element, DesignElement newElement) {
        this.localizeUserPropDefn(element, newElement);
        if (element instanceof IExtendableElement) {
            ModelUtil.duplicateExtensionIdentifier(element, newElement, element.getRoot());
        }
        Iterator iter = element.getPropertyDefns().iterator();
        block6: while (iter.hasNext()) {
            Object value;
            ElementPropertyDefn propDefn = (ElementPropertyDefn)iter.next();
            String propName = propDefn.getName();
            if ("extends".equals(propName) || "userProperties".equals(propName) || "theme".equals(propName) || "libraries".equals(propName) || propDefn.isStyleProperty() && !(element instanceof Style) || "style".equals(propName) || (value = element.getStrategy().getPropertyFromElement(this.targetDesign, element, propDefn)) == null) continue;
            switch (propDefn.getTypeCode()) {
                case 15: {
                    this.handleElementRefValue(newElement, (PropertyDefn)propDefn, (ElementRefValue)value);
                    continue block6;
                }
                case 19: {
                    this.handleStructureRefValue(newElement, propDefn, (StructRefValue)value);
                    continue block6;
                }
                case 20: {
                    if (propDefn.getSubTypeCode() == 15) {
                        this.handleElementRefValueList(newElement, propDefn, (List)value);
                        continue block6;
                    }
                    if (newElement.getLocalProperty(null, propDefn) != null) continue block6;
                    newElement.setProperty(propDefn, ModelUtil.copyValue(propDefn, value));
                    continue block6;
                }
                case 16: {
                    this.handleStructureValue(newElement, propDefn, value);
                    continue block6;
                }
            }
            if (newElement.getLocalProperty(null, propDefn) != null) continue;
            newElement.setProperty(propDefn, value);
        }
    }

    private void handleStructureValue(DesignElement newElement, PropertyDefn propDefn, Object valueList) {
        if (propDefn.isList() && "images".equalsIgnoreCase(propDefn.getName())) {
            ArrayList images = newElement.getListProperty(this.targetDesign, "images");
            if (images == null) {
                images = new ArrayList();
                newElement.setProperty(propDefn, images);
            }
            this.localizeEmbeddedImage((List)valueList, images);
        } else {
            newElement.setProperty(propDefn, this.createNewStructureValue(propDefn, valueList));
        }
    }

    private Object createNewStructureValue(PropertyDefn propDefn, Object value) {
        Cloneable newValue = null;
        if (propDefn.isList()) {
            List sourceValue = (List)value;
            newValue = new ArrayList();
            for (int i = 0; i < sourceValue.size(); ++i) {
                Structure newStruct = this.doCreateNewStructureValue((Structure)sourceValue.get(i));
                ((List)((Object)newValue)).add(newStruct);
            }
        } else {
            newValue = this.doCreateNewStructureValue((Structure)value);
        }
        return newValue;
    }

    private Structure doCreateNewStructureValue(Structure struct) {
        Structure newStruct = (Structure)struct.copy();
        Iterator iter = struct.getObjectDefn().propertiesIterator();
        block4: while (iter.hasNext()) {
            StructPropertyDefn memberDefn = (StructPropertyDefn)iter.next();
            Object value = struct.getLocalProperty((Module)this.sourceDesign, memberDefn);
            if (value == null) continue;
            switch (memberDefn.getTypeCode()) {
                case 15: {
                    this.handleElementRefValue(newStruct, (PropertyDefn)memberDefn, (ElementRefValue)value);
                    continue block4;
                }
                case 16: {
                    newStruct.setProperty(memberDefn, this.createNewStructureValue(memberDefn, value));
                    continue block4;
                }
            }
            newStruct.setProperty(memberDefn, ModelUtil.copyValue(memberDefn, value));
        }
        return newStruct;
    }

    private void handleElementRefValue(Structure structure, PropertyDefn propDefn, ElementRefValue value) {
        DesignElement refElement = value.getElement();
        if (refElement != null && refElement.getRoot() != this.sourceDesign) {
            DesignElement newRefEelement = this.getCache(refElement);
            if (newRefEelement == null) {
                newRefEelement = this.visitExternalElement(refElement);
                refElement.apply(this);
            }
            if (!$assertionsDisabled && newRefEelement == null) {
                throw new AssertionError();
            }
            structure.setProperty(propDefn, (Object)new ElementRefValue(null, newRefEelement));
        } else {
            structure.setProperty(propDefn, (Object)new ElementRefValue(value.getLibraryNamespace(), value.getName()));
        }
    }

    private void handleElementRefValueList(DesignElement newElement, PropertyDefn propDefn, List valueList) {
        ArrayList<ElementRefValue> values = new ArrayList<ElementRefValue>();
        for (int i = 0; i < valueList.size(); ++i) {
            ElementRefValue item = (ElementRefValue)valueList.get(i);
            DesignElement refElement = item.getElement();
            if (refElement != null && refElement.getRoot() != this.sourceDesign) {
                DesignElement newRefEelement = this.getCache(refElement);
                if (newRefEelement == null) {
                    newRefEelement = this.visitExternalElement(refElement);
                    refElement.apply(this);
                }
                values.add(new ElementRefValue(null, newRefEelement));
                continue;
            }
            newElement.setProperty(propDefn, (Object)item);
        }
        newElement.setProperty(propDefn, values);
    }

    private void handleStructureRefValue(DesignElement newElement, PropertyDefn propDefn, StructRefValue value) {
        if (!this.isLocalImage(value.getQualifiedReference())) {
            EmbeddedImage targetEmbeddedImage = (EmbeddedImage)value.getTargetStructure();
            EmbeddedImage newEmbeddedIamge = this.localizeExternalEmbeddedImage(targetEmbeddedImage);
            newElement.setProperty(propDefn, (Object)new StructRefValue(null, newEmbeddedIamge));
        } else {
            newElement.setProperty(propDefn, ModelUtil.copyValue(propDefn, value));
        }
    }

    private void handleElementRefValue(DesignElement newElement, PropertyDefn propDefn, ElementRefValue value) {
        DesignElement refElement = value.getElement();
        if (refElement != null && refElement.getRoot() != this.sourceDesign) {
            DesignElement newRefEelement = this.getCache(refElement);
            if (newRefEelement == null) {
                newRefEelement = this.visitExternalElement(refElement);
                refElement.apply(this);
            }
            if (newRefEelement != null) {
                newElement.setProperty(propDefn, (Object)new ElementRefValue(null, newRefEelement));
            }
        } else {
            newElement.setProperty(propDefn, (Object)new ElementRefValue(value.getLibraryNamespace(), value.getName()));
        }
    }

    private void localizeEmbeddedImage(List sourceEmbeddedImage, List targetEmeddedImage) {
        for (int i = 0; i < sourceEmbeddedImage.size(); ++i) {
            EmbeddedImage sourceImage = (EmbeddedImage)sourceEmbeddedImage.get(i);
            if (targetEmeddedImage.contains(sourceImage)) continue;
            EmbeddedImage newEmeddedImage = (EmbeddedImage)sourceImage.copy();
            this.localizeEmbeddedImageValues(sourceImage, newEmeddedImage);
            targetEmeddedImage.add(newEmeddedImage);
        }
    }

    private void localizeEmbeddedImageValues(EmbeddedImage sourceEmbeddedImage, EmbeddedImage targetEmeddedImage) {
        EmbeddedImage tmpEmeddedImage = sourceEmbeddedImage;
        while (tmpEmeddedImage != null && (targetEmeddedImage.getData(null) == null || targetEmeddedImage.getType(null) == null)) {
            targetEmeddedImage.setData(tmpEmeddedImage.getData(this.sourceDesign));
            targetEmeddedImage.setType(tmpEmeddedImage.getType(this.sourceDesign));
            StructRefValue refValue = (StructRefValue)tmpEmeddedImage.getProperty((Module)this.sourceDesign, "libReference");
            if (refValue == null) break;
            tmpEmeddedImage = (EmbeddedImage)refValue.getTargetStructure();
        }
        targetEmeddedImage.setProperty("libReference", null);
    }

    private EmbeddedImage localizeExternalEmbeddedImage(EmbeddedImage sourceEmbeddedImage) {
        EmbeddedImage newEmeddedImage = (EmbeddedImage)this.getCache(sourceEmbeddedImage);
        if (newEmeddedImage != null) {
            return newEmeddedImage;
        }
        newEmeddedImage = (EmbeddedImage)this.visitExternalStruct(sourceEmbeddedImage);
        this.localizeEmbeddedImageValues(sourceEmbeddedImage, newEmeddedImage);
        return newEmeddedImage;
    }

    private void cacheMapping(DesignElement sourceElement, DesignElement targetElement) {
        this.externalElements.put(sourceElement, targetElement);
    }

    private void cacheMapping(IStructure sourceStruct, IStructure targetStruct) {
        this.externalStructs.put(sourceStruct, targetStruct);
    }

    private IStructure getCache(IStructure sourceStruct) {
        return (IStructure)this.externalStructs.get(sourceStruct);
    }

    private DesignElement getCache(DesignElement sourceElement) {
        return (DesignElement)this.externalElements.get(sourceElement);
    }

    private boolean isLocalImage(String imageName) {
        StructureDefn defn = (StructureDefn)MetaDataDictionary.getInstance().getStructure("EmbeddedImage");
        return StructureRefUtil.findNativeStructure(this.targetDesign, defn, imageName) != null;
    }

    private DesignElement getTargetContainer(DesignElement sourceElement, DesignElement target) {
        DesignElement sourceContainer = sourceElement.getContainer();
        if (sourceContainer instanceof Theme) {
            return this.targetDesign;
        }
        DesignElement tmpContainer = (DesignElement)this.externalElements.get(sourceContainer);
        if (tmpContainer == null) {
            long containerId = sourceContainer.getID();
            tmpContainer = this.targetDesign.getElementByID(containerId);
        }
        if (tmpContainer == null) {
            return null;
        }
        if (sourceContainer.getElementName().equalsIgnoreCase(tmpContainer.getElementName())) {
            return tmpContainer;
        }
        if (sourceContainer instanceof Module && tmpContainer == this.targetDesign) {
            return tmpContainer;
        }
        return tmpContainer;
    }

    public DesignElementHandle newElement(String elementTypeName, String name) {
        ElementDefn elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getExtension(elementTypeName);
        if (elemDefn != null) {
            return this.newExtensionElement(elementTypeName, name);
        }
        elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(elementTypeName);
        if (elemDefn != null) {
            DesignElement element = ModelUtil.newElement(this.targetDesign, elementTypeName, name);
            if (element == null) {
                return null;
            }
            return element.getHandle(this.targetDesign);
        }
        return null;
    }

    public DesignElementHandle newElement(String elementTypeName, String name, SlotDefn slotDefn) {
        ElementDefn elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getExtension(elementTypeName);
        if (elemDefn != null) {
            return this.newExtensionElement(elementTypeName, name);
        }
        elemDefn = (ElementDefn)MetaDataDictionary.getInstance().getElement(elementTypeName);
        if (elemDefn != null) {
            DesignElement element = ReportDesignSerializer.newElement(this.targetDesign, elementTypeName, name, slotDefn.isManagedByNameSpace());
            if (element == null) {
                return null;
            }
            return element.getHandle(this.targetDesign);
        }
        return null;
    }

    public static DesignElement newElement(Module module, String elementTypeName, String name, boolean makeUniqueName) {
        DesignElement element = ModelUtil.newElement(elementTypeName, name);
        if (makeUniqueName) {
            module.makeUniqueName(element);
        }
        return element;
    }

    private DesignElementHandle newExtensionElement(String elementTypeName, String name) {
        MetaDataDictionary dd = MetaDataDictionary.getInstance();
        ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(elementTypeName);
        if (extDefn == null) {
            return null;
        }
        String extensionPoint = extDefn.getExtensionPoint();
        if ("org.eclipse.birt.report.model.reportItemModel".equalsIgnoreCase(extensionPoint)) {
            return this.newExtendedItem(name, elementTypeName);
        }
        return null;
    }

    public ExtendedItemHandle newExtendedItem(String name, String extensionName) {
        try {
            return this.newExtendedItem(name, extensionName, null);
        }
        catch (ExtendsException e) {
            if (!$assertionsDisabled) {
                throw new AssertionError();
            }
            return null;
        }
    }

    private ExtendedItemHandle newExtendedItem(String name, String extensionName, ExtendedItemHandle parent) throws ExtendsException {
        ExtendedItemHandle handle;
        block6: {
            MetaDataDictionary dd = MetaDataDictionary.getInstance();
            ExtensionElementDefn extDefn = (ExtensionElementDefn)dd.getExtension(extensionName);
            if (extDefn == null) {
                return null;
            }
            if (parent != null && !$assertionsDisabled && ((ExtendedItem)parent.getElement()).getExtDefn() != extDefn) {
                throw new AssertionError();
            }
            if (!(extDefn instanceof PeerExtensionElementDefn)) {
                throw new IllegalOperationException("Only report item extension can be created through this method.");
            }
            ExtendedItem element = new ExtendedItem(name);
            element.setProperty("extensionName", (Object)extensionName);
            if (parent != null) {
                element.getHandle(this.targetDesign).setExtends(parent);
            }
            this.targetDesign.makeUniqueName(element);
            handle = element.handle(this.targetDesign);
            try {
                handle.loadExtendedElement();
            }
            catch (ExtendedElementException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        return handle;
    }

    static {
        $assertionsDisabled = !ReportDesignSerializer.class.desiredAssertionStatus();
    }
}

