/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.util;

import java.util.Stack;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.ErrorHandler;
import org.eclipse.birt.report.model.util.ParseState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XMLParserHandler
extends DefaultHandler {
    protected Stack stateStack = new Stack();
    protected final ErrorHandler errorHandler;
    protected AbstractParseState topState;
    static final /* synthetic */ boolean $assertionsDisabled;

    public XMLParserHandler(ErrorHandler errorHandler) {
        if (!$assertionsDisabled && errorHandler == null) {
            throw new AssertionError();
        }
        this.errorHandler = errorHandler;
    }

    public void startDocument() throws SAXException {
        super.startDocument();
        if (!$assertionsDisabled && !this.stateStack.isEmpty()) {
            throw new AssertionError();
        }
        this.pushState(this.createStartState());
    }

    public void endDocument() throws SAXException {
        super.endDocument();
        if (!$assertionsDisabled && this.stateStack.size() != 1) {
            throw new AssertionError();
        }
        this.topState.end();
        this.popState();
    }

    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    protected void pushState(AbstractParseState state) {
        if (!$assertionsDisabled && state == null) {
            throw new AssertionError();
        }
        state.context = this.errorHandler.getCurrentElement();
        this.stateStack.push(state);
        this.topState = state;
    }

    private AbstractParseState popState() {
        if (!$assertionsDisabled && this.stateStack.isEmpty()) {
            throw new AssertionError();
        }
        AbstractParseState state = (AbstractParseState)this.stateStack.pop();
        if (this.stateStack.size() > 0) {
            this.topState = (AbstractParseState)this.stateStack.lastElement();
            this.topState.endElement(state);
        }
        return state;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        this.errorHandler.setCurrentElement(qName);
        AbstractParseState newState = this.topState.startElement(qName);
        newState.elementName = qName;
        this.pushState(newState);
        newState.parseAttrs(atts);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        AbstractParseState state = this.topState;
        state.end();
        this.popState();
        if (!this.stateStack.isEmpty()) {
            this.topState.endElement(state);
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.stateStack.isEmpty()) {
            this.topState.text.append(ch, start, length);
        }
    }

    public abstract AbstractParseState createStartState();

    public void setDocumentLocator(Locator theLocator) {
        super.setDocumentLocator(theLocator);
        this.errorHandler.setDocumentLocator(theLocator);
    }

    public void error(SAXParseException e) throws SAXException {
        this.errorHandler.semanticError(new XMLParserException(e));
    }

    public void warning(SAXParseException e) throws SAXException {
        this.errorHandler.semanticError(new XMLParserException(e));
    }

    public void fatalError(SAXParseException e) throws SAXException {
        this.errorHandler.semanticError(new XMLParserException(e));
    }

    static {
        $assertionsDisabled = !XMLParserHandler.class.desiredAssertionStatus();
    }

    public class InnerAnyTagState
    extends InnerParseState {
        public AbstractParseState startElement(String tagName) {
            return new InnerAnyTagState();
        }
    }

    public class InnerParseState
    extends ParseState {
        public InnerParseState() {
            super(XMLParserHandler.this);
        }
    }
}

