/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import java.util.HashMap;
import org.eclipse.birt.core.framework.FrameworkException;
import org.eclipse.birt.core.framework.IConfigurationElement;
import org.eclipse.birt.core.framework.IExtension;
import org.eclipse.birt.core.framework.IExtensionPoint;
import org.eclipse.birt.core.framework.IExtensionRegistry;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.data.engine.aggregation.BuiltInAggregationFactory;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;

public class AggregationFactory {
    private static final String ATTRIBUTE_AGGREGATION_CLASS = "aggregationClass";
    private static final String ATTRIBUTE_AGGREGATION_NAME = "name";
    private static final String EXTENSION_POINT = "org.eclipse.birt.data.aggregation";
    private static final String ELEMENT_AGGREGATIONS = "Aggregations";
    private static final String ELEMENT_AGGREGATION = "Aggregation";
    private static AggregationFactory instance = null;
    private static HashMap aggregations = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AggregationFactory getInstance() throws DataException {
        if (instance == null) {
            Class clazz = AggregationFactory.class;
            synchronized (clazz) {
                if (instance == null) {
                    instance = new AggregationFactory();
                }
            }
        }
        return instance;
    }

    public static void destroyInstance() {
        instance = null;
        aggregations = null;
    }

    private AggregationFactory() throws DataException {
        this.populateAggregations();
    }

    private void populateAggregations() throws DataException {
        aggregations = new HashMap();
        this.populateBuiltInAggregations();
        this.populateExtendedAggregations();
    }

    private void populateBuiltInAggregations() {
        String[] builtInAggrNames = BuiltInAggregationFactory.getInstance().getAggregationNames();
        for (int i = 0; i < builtInAggrNames.length; ++i) {
            aggregations.put(builtInAggrNames[i], BuiltInAggregationFactory.getInstance().getAggregation(builtInAggrNames[i]));
        }
    }

    private void populateExtendedAggregations() throws DataException {
        IExtensionRegistry extReg = Platform.getExtensionRegistry();
        IExtensionPoint extPoint = extReg.getExtensionPoint(EXTENSION_POINT);
        if (extPoint == null) {
            return;
        }
        IExtension[] exts = extPoint.getExtensions();
        if (exts == null) {
            return;
        }
        for (int e = 0; e < exts.length; ++e) {
            IConfigurationElement[] configElems = exts[e].getConfigurationElements();
            if (configElems == null) continue;
            for (int i = 0; i < configElems.length; ++i) {
                if (!configElems[i].getName().equals(ELEMENT_AGGREGATIONS)) continue;
                IConfigurationElement[] subElems = configElems[i].getChildren(ELEMENT_AGGREGATION);
                for (int j = 0; j < subElems.length; ++j) {
                    String name = subElems[j].getAttribute(ATTRIBUTE_AGGREGATION_NAME);
                    try {
                        if (aggregations.put(name.toUpperCase().trim(), subElems[j].createExecutableExtension(ATTRIBUTE_AGGREGATION_CLASS)) == null) continue;
                        throw new DataException("date.engine.DuplicateAggregationName", name);
                    }
                    catch (FrameworkException exception) {
                        DataException ep = new DataException("data.engine.CannotInstantiateAggregationFactory", name);
                        throw ep;
                    }
                }
            }
        }
    }

    public IAggregation getAggregation(String name) {
        return (IAggregation)aggregations.get(name.toUpperCase().trim());
    }
}

