/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.aggregation;

import java.util.HashMap;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.aggregation.SummaryAccumulator;
import org.eclipse.birt.data.engine.api.aggregation.Accumulator;
import org.eclipse.birt.data.engine.api.aggregation.IAggregation;
import org.eclipse.birt.data.engine.core.DataException;

public class TotalMode
implements IAggregation {
    static /* synthetic */ Class class$org$eclipse$birt$data$engine$aggregation$TotalMode;

    public String getName() {
        return "MODE";
    }

    public int getType() {
        return 0;
    }

    public boolean[] getParameterDefn() {
        return new boolean[]{true};
    }

    public Accumulator newAccumulator() {
        return new MyAccumulator();
    }

    private class MyAccumulator
    extends SummaryAccumulator {
        private HashMap valueMap;
        private int topCount;
        private int secondCount;
        private Double topValue;
        static final /* synthetic */ boolean $assertionsDisabled;

        private MyAccumulator() {
        }

        public void start() {
            super.start();
            this.valueMap = new HashMap();
            this.topCount = 0;
            this.secondCount = 0;
            this.topValue = null;
        }

        public void onRow(Object[] args) throws DataException {
            if (!$assertionsDisabled && args.length <= 0) {
                throw new AssertionError();
            }
            if (args[0] != null) {
                try {
                    Double value = DataTypeUtil.toDouble((Object)args[0]);
                    Integer count = (Integer)this.valueMap.get(value);
                    count = count == null ? new Integer(1) : new Integer(count + 1);
                    this.valueMap.put(value, count);
                    if (count > this.topCount) {
                        this.topValue = value;
                        this.secondCount = this.topCount;
                        this.topCount = count;
                    } else if (count > this.secondCount) {
                        this.secondCount = count;
                    }
                }
                catch (BirtException e) {
                    throw new DataException("data.engine.DataConversionError", e);
                }
            }
        }

        public void finish() throws DataException {
            super.finish();
            this.valueMap = null;
        }

        public Object getSummaryValue() {
            if (!$assertionsDisabled && this.topCount < this.secondCount) {
                throw new AssertionError();
            }
            if (this.topCount == this.secondCount) {
                return null;
            }
            return this.topValue;
        }

        static {
            $assertionsDisabled = !(class$org$eclipse$birt$data$engine$aggregation$TotalMode == null ? (class$org$eclipse$birt$data$engine$aggregation$TotalMode = TotalMode.class$("org.eclipse.birt.data.engine.aggregation.TotalMode")) : class$org$eclipse$birt$data$engine$aggregation$TotalMode).desiredAssertionStatus();
        }
    }
}

