/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IConditionalExpression;
import org.eclipse.birt.data.engine.api.IScriptExpression;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.expression.ExpressionCompilerUtil;
import org.eclipse.birt.data.engine.impl.ExprManager;
import org.eclipse.birt.data.engine.impl.GroupBindingColumn;

class ExprManagerUtil {
    private ExprManager exprManager;

    private ExprManagerUtil(ExprManager em) {
        this.exprManager = em;
    }

    public static void validateColumnBinding(ExprManager exprManager) throws DataException {
        ExprManagerUtil util = new ExprManagerUtil(exprManager);
        util.checkColumnBindingExpression();
        util.checkDependencyCycle();
        util.checkGroupNameValidation();
    }

    private void checkGroupNameValidation() throws DataException {
        HashMap map = this.getGroupKeys();
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            Integer level = (Integer)it.next();
            this.exprManager.setEntryGroupLevel(level);
            if (ExpressionCompilerUtil.hasColumnRow(map.get(level).toString(), this.exprManager)) continue;
            this.exprManager.setEntryGroupLevel(0);
            if (!this.isColumnBindingExist(map.get(level).toString())) {
                throw new DataException("data.engine.ColumnBindingNotExist", map.get(level).toString());
            }
            throw new DataException("data.engine.InvalidGroupKeyName", new Object[]{map.get(level).toString(), level});
        }
        this.exprManager.setEntryGroupLevel(0);
    }

    private boolean isColumnBindingExist(String columnName) {
        List bindings = this.exprManager.getBindingExprs();
        for (int i = 0; i < bindings.size(); ++i) {
            GroupBindingColumn gbc = (GroupBindingColumn)bindings.get(i);
            if (gbc.getExpression(columnName) == null) continue;
            return true;
        }
        return false;
    }

    private void checkDependencyCycle() throws DataException {
        ArrayList<Node> result = new ArrayList<Node>();
        Iterator it = this.getColumnNames().iterator();
        while (it.hasNext()) {
            String name = it.next().toString();
            Node n = new Node(name);
            IBaseExpression expr = this.exprManager.getExpr(name);
            if (expr != null) {
                if (!(expr instanceof IScriptExpression) && !(expr instanceof IConditionalExpression)) {
                    throw new DataException("data.engine.BadDataExpression");
                }
                List l = null;
                try {
                    if (expr instanceof IScriptExpression) {
                        l = ExpressionCompilerUtil.extractColumnExpression((IScriptExpression)expr);
                    } else if (expr instanceof IConditionalExpression) {
                        l = ExpressionCompilerUtil.extractColumnExpression((IConditionalExpression)expr);
                    }
                }
                catch (DataException e) {
                    // empty catch block
                }
                if (l != null) {
                    for (int j = 0; j < l.size(); ++j) {
                        n.addChild(new Node(l.get(j) == null ? null : l.get(j).toString()));
                    }
                }
            }
            result.add(n);
        }
        Node[] source = new Node[result.size()];
        for (int i = 0; i < source.length; ++i) {
            source[i] = (Node)result.get(i);
        }
        this.validateNodes(source);
    }

    private void checkColumnBindingExpression() throws DataException {
        List list = this.getColumnNames();
        for (int i = 0; i < list.size(); ++i) {
            String name = list.get(i).toString();
            IBaseExpression expr = this.exprManager.getExpr(name);
            if (expr == null) continue;
            if (!(expr instanceof IScriptExpression) && !(expr instanceof IConditionalExpression)) {
                throw new DataException("data.engine.BadDataExpression");
            }
            List l = null;
            try {
                if (expr instanceof IScriptExpression) {
                    l = ExpressionCompilerUtil.extractColumnExpression((IScriptExpression)expr);
                } else if (expr instanceof IConditionalExpression) {
                    l = ExpressionCompilerUtil.extractColumnExpression((IConditionalExpression)expr);
                }
            }
            catch (DataException e) {
                // empty catch block
            }
            if (l == null) continue;
            for (int j = 0; j < l.size(); ++j) {
                this.checkColumnBindingExist(l.get(j).toString(), list);
            }
        }
    }

    private void checkColumnBindingExist(String bindingName, List binding) throws DataException {
        if ("__rownum".equals(bindingName) || "_outer".equals(bindingName)) {
            return;
        }
        for (int i = 0; i < binding.size(); ++i) {
            if (!bindingName.equals(binding.get(i).toString())) continue;
            return;
        }
        throw new DataException("data.engine.ColumnBindingNotExist", bindingName);
    }

    private void validateNodes(Node[] source) throws DataException {
        Node[] preparedNodes = this.populateNodeList(source);
        for (int i = 0; i < preparedNodes.length; ++i) {
            this.isValidNode(preparedNodes[i], preparedNodes[i]);
        }
    }

    private void isValidNode(Node startNode, Node candidateNode) throws DataException {
        Object[] nodes = startNode.getChildren().toArray();
        for (int i = 0; i < nodes.length; ++i) {
            if (candidateNode.equals(nodes[i]) || startNode.equals(nodes[i])) {
                throw new DataException("data.engine.ColumnBindingCycle", ((Node)nodes[i]).getValue());
            }
            this.isValidNode((Node)nodes[i], candidateNode);
        }
    }

    private Node[] populateNodeList(Node[] source) {
        int i;
        Node[] result = new Node[source.length];
        for (i = 0; i < result.length; ++i) {
            result[i] = new Node(source[i].getValue());
        }
        for (i = 0; i < result.length; ++i) {
            List l = source[i].getChildren();
            for (int j = 0; j < l.size(); ++j) {
                Node n = this.getMatchedNode((Node)l.get(j), result);
                if (n == null) continue;
                result[i].addChild(n);
            }
        }
        return result;
    }

    private Node getMatchedNode(Node node, Node[] nodes) {
        for (int i = 0; i < nodes.length; ++i) {
            if (!nodes[i].equals(node)) continue;
            return nodes[i];
        }
        return null;
    }

    private List getColumnNames() {
        List bindingExprs = this.exprManager.getBindingExprs();
        Map autoBindingExprMap = this.exprManager.getAutoBindingExprMap();
        ArrayList l = new ArrayList();
        l.addAll(autoBindingExprMap.keySet());
        for (int i = 0; i < bindingExprs.size(); ++i) {
            l.addAll(((GroupBindingColumn)bindingExprs.get(i)).getColumnNames());
        }
        return l;
    }

    private HashMap getGroupKeys() {
        List bindingExprs = this.exprManager.getBindingExprs();
        HashMap<Integer, String> l = new HashMap<Integer, String>();
        for (int i = 0; i < bindingExprs.size(); ++i) {
            String key = ((GroupBindingColumn)bindingExprs.get(i)).getGroupKey();
            Integer groupLevel = new Integer(((GroupBindingColumn)bindingExprs.get(i)).getGroupLevel());
            if (key == null) continue;
            l.put(groupLevel, key);
        }
        return l;
    }

    static class Node {
        private List children;
        private String value;

        Node(String value) {
            this.value = value;
            this.children = new ArrayList();
        }

        String getValue() {
            return this.value;
        }

        void addChild(Node n) {
            this.children.add(n);
        }

        List getChildren() {
            return this.children;
        }

        public boolean equals(Object o) {
            return o instanceof Node && ((Node)o).value.equals(this.value);
        }
    }
}

