/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultIterator;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.impl.document.QueryResultIDUtil;
import org.eclipse.birt.data.engine.impl.document.QueryResultInfo;
import org.eclipse.birt.data.engine.impl.document.RDLoad;
import org.eclipse.birt.data.engine.impl.document.RDUtil;
import org.eclipse.birt.data.engine.impl.document.ResultIterator;
import org.eclipse.birt.data.engine.impl.document.ResultIterator2;

public class QueryResults
implements IQueryResults {
    private DataEngineContext context;
    private String queryResultID;
    private IResultIterator resultIterator;
    private IResultMetaData resultMetaData;
    private String subQueryName;
    private int currParentIndex;
    static final /* synthetic */ boolean $assertionsDisabled;

    public QueryResults(DataEngineContext context, String queryResultID) {
        this(context, queryResultID, null, null, -1);
    }

    QueryResults(DataEngineContext context, String queryResultID, IResultMetaData resultMetaData, String subQueryName, int currParentIndex) {
        if (!$assertionsDisabled && context == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && queryResultID == null) {
            throw new AssertionError();
        }
        if (subQueryName != null && !$assertionsDisabled && resultMetaData == null) {
            throw new AssertionError();
        }
        this.context = context;
        this.queryResultID = queryResultID;
        this.resultMetaData = resultMetaData;
        this.subQueryName = subQueryName;
        this.currParentIndex = currParentIndex;
    }

    public IPreparedQuery getPreparedQuery() {
        return null;
    }

    public IResultMetaData getResultMetaData() throws BirtException {
        if (this.resultMetaData == null) {
            this.resultMetaData = this.getRDLoad().loadResultMetaData();
        }
        return this.resultMetaData;
    }

    public IResultIterator getResultIterator() throws BirtException {
        if (this.resultIterator == null) {
            IBaseQueryDefinition queryDefn;
            this.resultIterator = this.subQueryName == null ? ((queryDefn = this.getRDLoad().loadQueryDefn(0, 2)).usesDetails() ? new ResultIterator(this.context, this, this.queryResultID) : new ResultIterator2(this.context, this, this.queryResultID, queryDefn.getGroups().size())) : new ResultIterator(this.context, this, this.queryResultID, this.subQueryName, this.currParentIndex);
        }
        return this.resultIterator;
    }

    private RDLoad getRDLoad() throws DataException {
        String baseID = QueryResultIDUtil.get1PartID(this.queryResultID);
        if (baseID == null) {
            baseID = this.queryResultID;
        }
        RDLoad rdLoad = RDUtil.newLoad(this.context, new QueryResultInfo(baseID, this.subQueryName, this.currParentIndex));
        return rdLoad;
    }

    public void close() throws BirtException {
        if (this.resultIterator != null) {
            this.resultIterator.close();
        }
    }

    public String getID() {
        return this.queryResultID;
    }

    static {
        $assertionsDisabled = !QueryResults.class.desiredAssertionStatus();
    }
}

