/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.impl.document;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.birt.core.archive.RAInputStream;
import org.eclipse.birt.core.util.IOUtil;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.core.DataException;

public class RDSubQueryUtil {
    private DataEngineContext context;
    private String queryResultID;
    private String subQueryName;
    private int groupLevel;
    private int[] subQueryInfo;

    RDSubQueryUtil(DataEngineContext context, String queryResultID, String subQueryName) {
        this.context = context;
        this.queryResultID = queryResultID;
        this.subQueryName = subQueryName;
    }

    public static void doSave(OutputStream stream, int groupLevel, int[] subQueryInfo) throws DataException {
        if (subQueryInfo == null) {
            return;
        }
        try {
            IOUtil.writeInt((OutputStream)stream, (int)groupLevel);
            int size = subQueryInfo.length;
            IOUtil.writeInt((OutputStream)stream, (int)size);
            for (int i = 0; i < size; ++i) {
                IOUtil.writeInt((OutputStream)stream, (int)subQueryInfo[i]);
            }
            stream.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.SaveReportDocumentError", (Throwable)e, "Subquery");
        }
    }

    int getSubQueryIndex(int currParentIndex) throws DataException {
        this.loadSubQuery();
        return RDSubQueryUtil.findSubQueryIndex(currParentIndex, this.groupLevel, this.subQueryInfo);
    }

    private void loadSubQuery() throws DataException {
        if (this.subQueryInfo != null) {
            return;
        }
        RAInputStream stream = this.context.getInputStream(this.queryResultID, this.subQueryName, 42);
        try {
            BufferedInputStream bis = new BufferedInputStream((InputStream)stream);
            this.groupLevel = IOUtil.readInt((InputStream)bis);
            int size = IOUtil.readInt((InputStream)bis);
            this.subQueryInfo = new int[size];
            for (int i = 0; i < size; ++i) {
                this.subQueryInfo[i] = IOUtil.readInt((InputStream)bis);
            }
            bis.close();
            stream.close();
        }
        catch (IOException e) {
            throw new DataException("data.engine.LoadReportDocumentError", (Throwable)e, "Subquery");
        }
    }

    private static int findSubQueryIndex(int currParentIndex, int groupLevel, int[] subQueryInfo) {
        int subQueryIndex;
        if (groupLevel == 0) {
            return 0;
        }
        int subQueryCount = subQueryInfo.length / 2;
        for (subQueryIndex = 0; subQueryIndex < subQueryCount && currParentIndex >= subQueryInfo[subQueryIndex * 2 + 1]; ++subQueryIndex) {
        }
        return subQueryIndex;
    }
}

