/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.impl;

import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.report.model.adapter.oda.IODAFactory;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataSetType;
import org.eclipse.datatools.connectivity.oda.util.manifest.DataTypeMapping;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;

class ODAFactory
implements IODAFactory {
    ODAFactory() {
    }

    public String getUpdatedDataType(String dataSourceId, String dataSetId, int nativeCode, String romDataType, String choiceName) throws BirtException {
        DataSetType setType = null;
        try {
            ExtensionManifest manifest = ManifestExplorer.getInstance().getExtensionManifest(dataSourceId);
            if (manifest == null) {
                return null;
            }
            setType = manifest.getDataSetType(dataSetId);
        }
        catch (OdaException e) {
            // empty catch block
        }
        if (setType == null) {
            return null;
        }
        DataTypeMapping typeMapping = setType.getDataTypeMapping(nativeCode);
        if (typeMapping == null) {
            return null;
        }
        int odaDataTypeCode = typeMapping.getOdaScalarDataTypeCode();
        if (ODAFactory.isCompatible(romDataType, odaDataTypeCode)) {
            return romDataType;
        }
        int[] odaDataTypeCodes = typeMapping.getAlternativeOdaDataTypeCodes();
        for (int i = 0; i < odaDataTypeCodes.length; ++i) {
            if (!ODAFactory.isCompatible(romDataType, odaDataTypeCodes[i])) continue;
            return romDataType;
        }
        int apiDataType = DataTypeUtil.toApiDataType((int)odaDataTypeCode);
        return ODAFactory.convertApiTypeToROMType(choiceName, apiDataType);
    }

    private static String convertApiTypeToROMColumnType(int apiDataType) {
        switch (apiDataType) {
            case 0: {
                return "any";
            }
            case 2: {
                return "integer";
            }
            case 5: {
                return "string";
            }
            case 6: {
                return "date-time";
            }
            case 4: {
                return "decimal";
            }
            case 3: {
                return "float";
            }
            case 1: {
                return "boolean";
            }
        }
        return "any";
    }

    private static String convertApiTypeToROMParameterType(int apiDataType) {
        switch (apiDataType) {
            case 2: {
                return "integer";
            }
            case 5: {
                return "string";
            }
            case 6: {
                return "dateTime";
            }
            case 4: {
                return "decimal";
            }
            case 3: {
                return "float";
            }
            case 1: {
                return "boolean";
            }
            case 0: {
                return "any";
            }
        }
        return "any";
    }

    private static String convertApiTypeToROMType(String choiceName, int apiDataType) {
        if ("columnDataType".equalsIgnoreCase(choiceName)) {
            return ODAFactory.convertApiTypeToROMColumnType(apiDataType);
        }
        if ("paramType".equalsIgnoreCase(choiceName)) {
            return ODAFactory.convertApiTypeToROMParameterType(apiDataType);
        }
        return null;
    }

    private static boolean isCompatible(String romDataType, int odaDataTypeCode) throws BirtException {
        int apiDataType = DataTypeUtil.toApiDataType((int)odaDataTypeCode);
        if (-1 == apiDataType) {
            return true;
        }
        String convertedType = ODAFactory.convertApiTypeToROMParameterType(apiDataType);
        return convertedType != null && convertedType.equalsIgnoreCase(romDataType);
    }
}

