/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.emitter.html;

import java.util.logging.Level;
import org.eclipse.birt.report.engine.emitter.XMLWriter;

public class HTMLWriter
extends XMLWriter {
    static final /* synthetic */ boolean $assertionsDisabled;

    public HTMLWriter() {
        this.bImplicitCloseTag = false;
    }

    public void closeTag(String tagName) {
        if (tagName == null) {
            return;
        }
        if ("br".equalsIgnoreCase(tagName) || "img".equalsIgnoreCase(tagName)) {
            this.closeNoEndTag();
        } else {
            super.closeTag(tagName);
        }
    }

    public void closeNoEndTag() {
        --this.indentCount;
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        this.bPairedFlag = true;
    }

    public void style(String name, String value) {
        if (!($assertionsDisabled || name != null && name.length() > 0)) {
            throw new AssertionError();
        }
        if (value == null || value.length() == 0) {
            return;
        }
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
            this.bPairedFlag = true;
        }
        if (this.bIndent) {
            ++this.indentCount;
            this.printWriter.println();
            this.printWriter.print(super.indent());
            --this.indentCount;
        }
        this.printWriter.print(name);
        this.printWriter.print(" {");
        this.printWriter.print(value);
        this.printWriter.print('}');
    }

    public void writeCode(String code) {
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
            this.bPairedFlag = true;
        }
        if (this.bIndent) {
            this.printWriter.println();
            this.printWriter.print(super.indent());
        }
        this.printWriter.print(code);
    }

    public void startWriter() {
        this.printWriter.print("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\">");
    }

    protected String getEscapedStr(String s, boolean whitespace) {
        StringBuffer result = null;
        int spacePos = 1;
        char[] s2char = s.toCharArray();
        int max = s2char.length;
        int delta = 0;
        for (int i = 0; i < max; ++i) {
            char c = s2char[i];
            String replacement = null;
            if (whitespace && c == ' ') {
                boolean replace = false;
                if (spacePos % 2 == 1) {
                    replace = true;
                } else {
                    int nextNext;
                    int last = i - 1 >= 0 ? s2char[i - 1] : 10;
                    int next = i + 1 < max ? s2char[i + 1] : 10;
                    int n = nextNext = i + 2 < max ? s2char[i + 2] : 10;
                    if (last == 10 || next == 10 || next == 13 && nextNext == 10) {
                        replace = true;
                    }
                }
                if (replace) {
                    replacement = "&nbsp;";
                }
                ++spacePos;
            } else {
                spacePos = 0;
            }
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd')) {
                replacement = "";
                log.log(Level.WARNING, "Ignore the illegal XML character: 0x{0};", Integer.toHexString(c));
            } else if (c == '&') {
                replacement = "&amp;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c == '\t') {
                replacement = "&nbsp;";
            } else if (c == '\r') {
                int n = i + 1;
                if (n < max && s2char[n] == '\n') {
                    replacement = "";
                }
            } else if (c == '\n') {
                replacement = "<br>";
            } else if (c >= '\u0080') {
                replacement = "&#x" + Integer.toHexString(c) + ';';
            }
            if (replacement == null) continue;
            if (result == null) {
                result = new StringBuffer(s);
            }
            result.replace(i + delta, i + delta + 1, replacement);
            delta += replacement.length() - 1;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    public void textForHtmlItem(String value) {
        if (value == null || value.length() == 0) {
            return;
        }
        if (!this.bPairedFlag) {
            this.printWriter.print('>');
            this.bPairedFlag = true;
        }
        String stringToPrint = this.getEscapedStrForHtmlItem(value);
        this.printWriter.print(stringToPrint);
        this.bText = true;
    }

    protected String getEscapedStrForHtmlItem(String s) {
        StringBuffer result = null;
        char[] s2char = s.toCharArray();
        int max = s2char.length;
        int delta = 0;
        for (int i = 0; i < max; ++i) {
            char c = s2char[i];
            String replacement = null;
            if (!(c == '\t' || c == '\n' || c == '\r' || c >= ' ' && c <= '\ud7ff' || c >= '\ue000' && c <= '\ufffd')) {
                replacement = "";
                log.log(Level.WARNING, "Ignore the illegal XML character: 0x{0};", Integer.toHexString(c));
            } else if (c == '&') {
                replacement = "&amp;";
            } else if (c == '<') {
                replacement = "&lt;";
            } else if (c == '>') {
                replacement = "&gt;";
            } else if (c >= '\u0080') {
                replacement = "&#x" + Integer.toHexString(c) + ';';
            }
            if (replacement == null) continue;
            if (result == null) {
                result = new StringBuffer(s);
            }
            result.replace(i + delta, i + delta + 1, replacement);
            delta += replacement.length() - 1;
        }
        if (result == null) {
            return s;
        }
        return result.toString();
    }

    static {
        $assertionsDisabled = !HTMLWriter.class.desiredAssertionStatus();
    }
}

