/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.extension;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.extension.ExtendedElementException;
import org.eclipse.birt.report.model.api.extension.IPropertyDefinition;
import org.eclipse.birt.report.model.api.extension.IReportItem;
import org.eclipse.birt.report.model.api.extension.IReportItemFactory;
import org.eclipse.birt.report.model.api.metadata.IElementPropertyDefn;
import org.eclipse.birt.report.model.api.metadata.IPropertyDefn;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.extension.ModelExtensibilityProvider;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.ExtensionModelPropertyDefn;
import org.eclipse.birt.report.model.metadata.MethodInfo;
import org.eclipse.birt.report.model.metadata.PeerExtensionElementDefn;
import org.eclipse.birt.report.model.util.ModelUtil;

public class PeerExtensibilityProvider
extends ModelExtensibilityProvider {
    IReportItem reportItem = null;
    HashMap extensionPropValues = new HashMap();
    static final /* synthetic */ boolean $assertionsDisabled;

    public PeerExtensibilityProvider(DesignElement element, String extensionName) {
        super(element, extensionName);
    }

    public List getPropertyDefns() {
        List props = super.getPropertyDefns();
        PeerExtensionElementDefn extDefn = (PeerExtensionElementDefn)this.getExtDefn();
        if (extDefn == null) {
            return props;
        }
        IPropertyDefinition[] dynamicProps = this.getExtensionModelPropertyDefns();
        if (dynamicProps != null) {
            for (int i = 0; i < dynamicProps.length; ++i) {
                IPropertyDefinition extProp = dynamicProps[i];
                props.add(new ExtensionModelPropertyDefn(extProp, extDefn.getReportItemFactory().getMessages()));
            }
        }
        return props;
    }

    public List getModelMethodDefns() {
        ArrayList<ExtensionModelPropertyDefn> methods = new ArrayList<ExtensionModelPropertyDefn>();
        PeerExtensionElementDefn extDefn = (PeerExtensionElementDefn)this.getExtDefn();
        if (extDefn == null) {
            return null;
        }
        if (extDefn.getMethods() != null) {
            methods.addAll(extDefn.getMethods());
        }
        if (this.reportItem == null) {
            return null;
        }
        IPropertyDefinition[] dynamicMethods = this.reportItem.getMethods();
        if (dynamicMethods != null) {
            for (int i = 0; i < dynamicMethods.length; ++i) {
                IPropertyDefinition extProp = dynamicMethods[i];
                MethodInfo methodInfo = (MethodInfo)extProp.getMethodInfo();
                ExtensionModelPropertyDefn modelPropDefn = new ExtensionModelPropertyDefn(extProp, extDefn.getReportItemFactory().getMessages());
                modelPropDefn.setDetails(methodInfo);
                methods.add(modelPropDefn);
            }
        }
        return methods;
    }

    public IPropertyDefn getPropertyDefn(String propName) {
        IPropertyDefn propDefn = super.getPropertyDefn(propName);
        if (propDefn == null) {
            PeerExtensionElementDefn extDefn = (PeerExtensionElementDefn)this.getExtDefn();
            IPropertyDefinition[] extProps = this.getExtensionModelPropertyDefns();
            if (extProps != null) {
                for (int i = 0; i < extProps.length; ++i) {
                    if (!propName.equalsIgnoreCase(extProps[i].getName())) continue;
                    return new ExtensionModelPropertyDefn(extProps[i], extDefn.getReportItemFactory().getMessages());
                }
            }
        }
        return propDefn;
    }

    private IPropertyDefinition[] getExtensionModelPropertyDefns() {
        if (this.reportItem == null) {
            return null;
        }
        return this.reportItem.getPropertyDefinitions();
    }

    protected List getStyleMasks() {
        return Collections.EMPTY_LIST;
    }

    public Object getExtensionProperty(String propName) {
        if (this.isExtensionXMLProperty(propName)) {
            if (this.reportItem != null) {
                String retValue;
                block8: {
                    ByteArrayOutputStream stream = this.reportItem.serialize(propName);
                    if (stream == null) {
                        return null;
                    }
                    retValue = null;
                    try {
                        retValue = stream.toString("UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        if ($assertionsDisabled) break block8;
                        throw new AssertionError();
                    }
                }
                return retValue;
            }
        } else if (this.isExtensionModelProperty(propName)) {
            if (!$assertionsDisabled && this.reportItem == null) {
                throw new AssertionError();
            }
            return this.reportItem.getProperty(propName);
        }
        return this.extensionPropValues.get(propName);
    }

    public void setExtensionProperty(ElementPropertyDefn prop, Object value) {
        if (this.isExtensionXMLProperty(prop.getName())) {
            if (this.reportItem != null) {
                try {
                    if (value != null) {
                        byte[] raw;
                        block13: {
                            raw = null;
                            try {
                                raw = value.toString().getBytes("UTF-8");
                            }
                            catch (UnsupportedEncodingException e) {
                                if ($assertionsDisabled) break block13;
                                throw new AssertionError();
                            }
                        }
                        this.reportItem.deserialize(prop.getName(), new ByteArrayInputStream(raw));
                    }
                    this.reportItem.deserialize(prop.getName(), new ByteArrayInputStream(new byte[0]));
                }
                catch (ExtendedElementException e) {
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
            } else {
                this.setExtensionPropertyValue(prop.getName(), value);
            }
        } else if (this.isExtensionModelProperty(prop.getName())) {
            if (!$assertionsDisabled && this.reportItem == null) {
                throw new AssertionError();
            }
            this.reportItem.setProperty(prop.getName(), value);
        } else {
            this.setExtensionPropertyValue(prop.getName(), value);
        }
    }

    private void setExtensionPropertyValue(String propName, Object value) {
        if (value != null) {
            this.extensionPropValues.put(propName, value);
        } else {
            this.extensionPropValues.remove(propName);
        }
    }

    public void initializeReportItem(Module module) throws ExtendedElementException {
        if (this.reportItem != null) {
            return;
        }
        PeerExtensionElementDefn extDefn = (PeerExtensionElementDefn)this.getExtDefn();
        if (extDefn == null) {
            throw new ExtendedElementException(this.element, "org.eclipse.birt.report.model", "Error.SemanticError.EXTENSION_NOT_FOUND", null);
        }
        IReportItemFactory elementFactory = extDefn.getReportItemFactory();
        if (!$assertionsDisabled && elementFactory == null) {
            throw new AssertionError();
        }
        this.reportItem = elementFactory.newReportItem(this.element.getHandle(module));
        List localPropDefns = this.getExtDefn().getLocalProperties();
        for (int i = 0; i < localPropDefns.size(); ++i) {
            byte[] raw;
            ElementPropertyDefn propDefn;
            block12: {
                propDefn = (ElementPropertyDefn)localPropDefns.get(i);
                if (!$assertionsDisabled && !propDefn.isExtended()) {
                    throw new AssertionError();
                }
                if (propDefn.getTypeCode() != 12 || !propDefn.canInherit()) continue;
                Object value = this.extensionPropValues.get(propDefn.getName());
                if (value == null) {
                    ExtendedItem parent = (ExtendedItem)ModelUtil.getParent(this.element);
                    while (parent != null) {
                        PeerExtensibilityProvider parentProvider = parent.getExtensibilityProvider();
                        HashMap propValues = parentProvider.extensionPropValues;
                        value = propValues.get(propDefn.getName());
                        if (value == null) {
                            parent = (ExtendedItem)ModelUtil.getParent(this.element);
                            continue;
                        }
                        break;
                    }
                } else {
                    this.extensionPropValues.remove(propDefn.getName());
                }
                if (value == null) continue;
                raw = null;
                try {
                    raw = value.toString().getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    if ($assertionsDisabled) break block12;
                    throw new AssertionError();
                }
            }
            this.reportItem.deserialize(propDefn.getName(), new ByteArrayInputStream(raw));
        }
    }

    public boolean isExtensionModelProperty(String propName) {
        IPropertyDefinition[] extProps;
        if (this.reportItem != null && (extProps = this.reportItem.getPropertyDefinitions()) != null) {
            for (int i = 0; i < extProps.length; ++i) {
                IPropertyDefinition extProp = extProps[i];
                if (!$assertionsDisabled && extProp == null) {
                    throw new AssertionError();
                }
                if (!propName.equals(extProp.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExtensionXMLProperty(String propName) {
        IElementPropertyDefn propDefn;
        ExtensionElementDefn extDefn = this.getExtDefn();
        return extDefn != null && (propDefn = extDefn.getProperty(propName)) != null && 12 == propDefn.getTypeCode();
    }

    public void copyFrom(PeerExtensibilityProvider source) {
        this.reportItem = null;
        if (source.reportItem != null) {
            this.reportItem = source.reportItem.copy();
        }
        this.extensionPropValues = new HashMap();
        Iterator it = source.extensionPropValues.keySet().iterator();
        while (it.hasNext()) {
            String propName = (String)it.next();
            ElementPropertyDefn propDefn = this.element.getPropertyDefn(propName);
            Object value = source.extensionPropValues.get(propName);
            Object valueToSet = ModelUtil.copyValue(propDefn, value);
            this.extensionPropValues.put(propName, valueToSet);
        }
    }

    public IReportItem getExtensionElement() {
        return this.reportItem;
    }

    public IPropertyDefinition getScriptPropertyDefinition() {
        if (this.reportItem != null) {
            return this.reportItem.getScriptPropertyDefinition();
        }
        return null;
    }

    public boolean hasLocalPropertyValues() {
        return !this.extensionPropValues.isEmpty() || this.reportItem != null;
    }

    static {
        $assertionsDisabled = !PeerExtensibilityProvider.class.desiredAssertionStatus();
    }
}

