/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.parser.DataItemState;
import org.eclipse.birt.report.model.parser.DesignParseState;
import org.eclipse.birt.report.model.parser.DesignParserException;
import org.eclipse.birt.report.model.parser.ExtendedItemState;
import org.eclipse.birt.report.model.parser.FreeFormState;
import org.eclipse.birt.report.model.parser.GraphicMasterPageState;
import org.eclipse.birt.report.model.parser.GridItemState;
import org.eclipse.birt.report.model.parser.ImageState;
import org.eclipse.birt.report.model.parser.JointDataSetState;
import org.eclipse.birt.report.model.parser.LabelState;
import org.eclipse.birt.report.model.parser.LineItemState;
import org.eclipse.birt.report.model.parser.ListItemState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.OdaDataSetState;
import org.eclipse.birt.report.model.parser.OdaDataSourceState;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.RectangleState;
import org.eclipse.birt.report.model.parser.ScriptDataSetState;
import org.eclipse.birt.report.model.parser.ScriptDataSourceState;
import org.eclipse.birt.report.model.parser.SimpleMasterPageState;
import org.eclipse.birt.report.model.parser.TableItemState;
import org.eclipse.birt.report.model.parser.TemplateDataSetState;
import org.eclipse.birt.report.model.parser.TextDataItemState;
import org.eclipse.birt.report.model.parser.TextItemState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.AnyElementState;
import org.eclipse.birt.report.model.util.VersionUtil;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public abstract class ModuleState
extends DesignParseState {
    protected Module module = null;

    public ModuleState(ModuleParserHandler theHandler) {
        super(theHandler);
        this.module = theHandler.getModule();
    }

    public DesignElement getElement() {
        return this.module;
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        String version = attrs.getValue("version");
        if (!StringUtil.isBlank(version)) {
            int result;
            try {
                this.handler.versionNumber = VersionUtil.parseVersion(version);
                result = 3020700 < this.handler.versionNumber ? -1 : (3020700 == this.handler.versionNumber ? 0 : 1);
            }
            catch (NumberFormatException ex) {
                DesignParserException e = new DesignParserException(new String[]{version}, "Error.DesignParserException.INVALID_VERSION");
                throw new XMLParserException((Exception)((Object)e));
            }
            catch (IllegalArgumentException ex) {
                DesignParserException e = new DesignParserException(new String[]{version}, "Error.DesignParserException.INVALID_VERSION");
                throw new XMLParserException((Exception)((Object)e));
            }
            if (result < 0) {
                DesignParserException e = new DesignParserException(new String[]{version}, "Error.DesignParserException.UNSUPPORTED_VERSION");
                throw new XMLParserException((Exception)((Object)e));
            }
            if (result == 0) {
                this.handler.isCurrentVersion = true;
            }
        }
        this.module.getVersionManager().setVersion(version);
        super.parseAttrs(attrs);
    }

    class SlotState
    extends InnerParseState {
        private int slotID;

        public SlotState(int slotID) {
            this.slotID = slotID;
        }

        public AbstractParseState startElement(String tagName) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.BROWSER_CONTROL_TAG == tagValue) {
                return new AnyElementState(ModuleState.this.handler);
            }
            if (ParserSchemaConstants.FREE_FORM_TAG == tagValue) {
                return new FreeFormState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if (ParserSchemaConstants.DATA_TAG == tagValue) {
                return new DataItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if (ParserSchemaConstants.EXTENDED_ITEM_TAG == tagValue) {
                return new ExtendedItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if (ParserSchemaConstants.GRID_TAG == tagValue) {
                return new GridItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if (ParserSchemaConstants.IMAGE_TAG == tagValue) {
                return new ImageState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if (ParserSchemaConstants.INCLUDE_TAG == tagValue) {
                return new AnyElementState(ModuleState.this.handler);
            }
            if (ParserSchemaConstants.LABEL_TAG == tagValue) {
                return new LabelState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if (ParserSchemaConstants.TEXT_TAG == tagValue) {
                return new TextItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if (ParserSchemaConstants.LINE_TAG == tagValue) {
                return new LineItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if (ParserSchemaConstants.LIST_TAG == tagValue) {
                return new ListItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if (ParserSchemaConstants.RECTANGLE_TAG == tagValue) {
                return new RectangleState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if (ParserSchemaConstants.TABLE_TAG == tagValue) {
                return new TableItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if (ParserSchemaConstants.TEXT_TAG == tagValue) {
                return new TextItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            if (ParserSchemaConstants.TOC_TAG == tagValue) {
                return new AnyElementState(ModuleState.this.handler);
            }
            if (ParserSchemaConstants.MULTI_LINE_DATA_TAG == tagValue || ParserSchemaConstants.TEXT_DATA_TAG == tagValue) {
                return new TextDataItemState(ModuleState.this.handler, ModuleState.this.module, this.slotID);
            }
            return super.startElement(tagName);
        }
    }

    class PageSetupState
    extends InnerParseState {
        PageSetupState() {
        }

        public AbstractParseState startElement(String tagName) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.GRAPHIC_MASTER_PAGE_TAG == tagValue) {
                return new GraphicMasterPageState(ModuleState.this.handler);
            }
            if (ParserSchemaConstants.SIMPLE_MASTER_PAGE_TAG == tagValue) {
                return new SimpleMasterPageState(ModuleState.this.handler);
            }
            if (ParserSchemaConstants.PAGE_SEQUENCE_TAG == tagValue) {
                return new AnyElementState(ModuleState.this.handler);
            }
            return super.startElement(tagName);
        }
    }

    class TranslationState
    extends InnerParseState {
        private String resourceKey;
        private String locale;

        TranslationState(String key) {
            this.resourceKey = null;
            this.locale = null;
            this.resourceKey = key;
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            this.locale = attrs.getValue("locale");
            this.locale = StringUtil.trimString(this.locale);
            if (ModuleState.this.module.findTranslation(this.resourceKey, this.locale) != null) {
                ModuleState.this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.DUPLICATE_TRANSLATION_LOCALE")));
                return;
            }
            super.parseAttrs(attrs);
        }

        public void end() throws SAXException {
            ModuleState.this.module.addTranslation(new Translation(this.resourceKey, this.locale, this.text.toString()));
            super.end();
        }
    }

    class ResourceState
    extends InnerParseState {
        private String key;

        ResourceState() {
            this.key = null;
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            this.key = attrs.getValue("key");
            if (StringUtil.isEmpty(this.key)) {
                ModuleState.this.handler.getErrorHandler().semanticError((Exception)((Object)new DesignParserException("Error.DesignParserException.MESSAGE_KEY_REQUIRED")));
                return;
            }
            super.parseAttrs(attrs);
        }

        public AbstractParseState startElement(String tagName) {
            if ("translation".equalsIgnoreCase(tagName)) {
                return new TranslationState(this.key);
            }
            return super.startElement(tagName);
        }
    }

    class TranslationsState
    extends InnerParseState {
        TranslationsState() {
        }

        public AbstractParseState startElement(String tagName) {
            if ("resource".equalsIgnoreCase(tagName)) {
                return new ResourceState();
            }
            return super.startElement(tagName);
        }
    }

    class DataSetsState
    extends InnerParseState {
        DataSetsState() {
        }

        public AbstractParseState startElement(String tagName) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.SCRIPT_DATA_SET_TAG == tagValue) {
                return new ScriptDataSetState(ModuleState.this.handler);
            }
            if (ParserSchemaConstants.ODA_DATA_SET_TAG == tagValue || ParserSchemaConstants.EXTENDED_DATA_SET_TAG == tagValue) {
                return new OdaDataSetState(ModuleState.this.handler);
            }
            if (ParserSchemaConstants.TEMPLATE_DATA_SET_TAG == tagValue) {
                return new TemplateDataSetState(ModuleState.this.handler);
            }
            if (ParserSchemaConstants.JOINT_DATA_SET_TAG == tagValue) {
                return new JointDataSetState(ModuleState.this.handler);
            }
            return super.startElement(tagName);
        }
    }

    class DataSourcesState
    extends InnerParseState {
        DataSourcesState() {
        }

        public AbstractParseState startElement(String tagName) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.SCRIPT_DATA_SOURCE_TAG == tagValue) {
                return new ScriptDataSourceState(ModuleState.this.handler);
            }
            if (ParserSchemaConstants.ODA_DATA_SOURCE_TAG == tagValue || ParserSchemaConstants.EXTENDED_DATA_SOURCE_TAG == tagValue) {
                return new OdaDataSourceState(ModuleState.this.handler);
            }
            return super.startElement(tagName);
        }
    }

    class InnerParseState
    extends AbstractParseState {
        InnerParseState() {
        }

        public XMLParserHandler getHandler() {
            return ModuleState.this.handler;
        }
    }
}

