/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import org.eclipse.birt.report.model.api.elements.table.BasicLayoutStrategies;
import org.eclipse.birt.report.model.api.elements.table.LayoutTable;
import org.eclipse.birt.report.model.core.ContainerSlot;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.parser.GroupState;
import org.eclipse.birt.report.model.parser.ListingItemState;
import org.eclipse.birt.report.model.parser.ModuleParserHandler;
import org.eclipse.birt.report.model.parser.ParserSchemaConstants;
import org.eclipse.birt.report.model.parser.TableColumnState;
import org.eclipse.birt.report.model.parser.TableRowState;
import org.eclipse.birt.report.model.util.AbstractParseState;
import org.eclipse.birt.report.model.util.XMLParserException;
import org.eclipse.birt.report.model.util.XMLParserHandler;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class TableItemState
extends ListingItemState {
    static final /* synthetic */ boolean $assertionsDisabled;

    public TableItemState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
        super(handler, theContainer, slot);
    }

    public void parseAttrs(Attributes attrs) throws XMLParserException {
        this.element = new TableItem();
        this.initElement(attrs);
    }

    public AbstractParseState startElement(String tagName) {
        int tagValue = tagName.toLowerCase().hashCode();
        if (ParserSchemaConstants.COLUMN_TAG == tagValue) {
            return new TableColumnState(this.handler, this.element, 4);
        }
        if (ParserSchemaConstants.HEADER_TAG == tagValue) {
            return new TableBandState(this.element, 0);
        }
        if (ParserSchemaConstants.GROUP_TAG == tagValue) {
            return new TableGroupState(this.handler, this.element, 1);
        }
        if (ParserSchemaConstants.DETAIL_TAG == tagValue) {
            return new TableBandState(this.element, 2);
        }
        if (ParserSchemaConstants.FOOTER_TAG == tagValue) {
            return new TableBandState(this.element, 3);
        }
        return super.startElement(tagName);
    }

    public void end() throws SAXException {
        super.end();
        if (!$assertionsDisabled && !(this.element instanceof TableItem)) {
            throw new AssertionError();
        }
        LayoutTable layoutTable = ((TableItem)this.element).getLayoutModel(this.handler.getModule());
        BasicLayoutStrategies.appliesStrategies(layoutTable, false);
        this.setCompatibleOnRowMethod();
    }

    private void setCompatibleOnRowMethod() {
        String onRowValue = (String)this.handler.tempValue.get(this.element);
        if (onRowValue == null) {
            return;
        }
        ContainerSlot detail = this.element.getSlot(2);
        for (int i = 0; i < detail.getCount(); ++i) {
            TableRow row = (TableRow)detail.getContent(i);
            if (row.getLocalProperty(this.handler.getModule(), "onCreate") != null) continue;
            row.setProperty("onCreate", (Object)onRowValue);
        }
    }

    static {
        $assertionsDisabled = !TableItemState.class.desiredAssertionStatus();
    }

    class TableBandState
    extends AbstractParseState {
        protected int rowSlotID;
        protected DesignElement table;

        public TableBandState(DesignElement container, int slot) {
            this.table = container;
            this.rowSlotID = slot;
        }

        public XMLParserHandler getHandler() {
            return TableItemState.this.handler;
        }

        public AbstractParseState startElement(String tagName) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.ROW_TAG == tagValue) {
                return new TableRowState(TableItemState.this.handler, this.table, this.rowSlotID);
            }
            return super.startElement(tagName);
        }
    }

    class TableGroupState
    extends GroupState {
        public TableGroupState(ModuleParserHandler handler, DesignElement theContainer, int slot) {
            super(handler, theContainer, slot);
        }

        public void parseAttrs(Attributes attrs) throws XMLParserException {
            this.group = new TableGroup();
            super.parseAttrs(attrs);
        }

        public AbstractParseState startElement(String tagName) {
            int tagValue = tagName.toLowerCase().hashCode();
            if (ParserSchemaConstants.HEADER_TAG == tagValue) {
                return new TableBandState(this.group, 0);
            }
            if (ParserSchemaConstants.FOOTER_TAG == tagValue) {
                return new TableBandState(this.group, 1);
            }
            return super.startElement(tagName);
        }
    }
}

