/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.birt.report.model.util.XMLWriter;

public class DocumentXMLWriter
extends XMLWriter {
    static final /* synthetic */ boolean $assertionsDisabled;

    public DocumentXMLWriter(File outputFile, String signature) throws IOException {
        super(outputFile, signature);
    }

    public DocumentXMLWriter(OutputStream os, String signature) throws IOException {
        super(os, signature);
    }

    public void attribute(String attrName, String value) {
        if (value == null) {
            return;
        }
        this.checkAttribute();
        if (!$assertionsDisabled && !this.elementActive) {
            throw new AssertionError();
        }
        this.out.print(" ");
        this.out.print(attrName);
        this.out.print("=\"");
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (c == '&') {
                this.out.print("&amp;");
                continue;
            }
            if (c == '<') {
                this.out.print("&lt;");
                continue;
            }
            if (c == '\"') {
                this.out.print("&quot;");
                continue;
            }
            if (c < ' ') {
                this.out.print("&#x");
                this.out.print(Integer.toHexString(c));
                this.out.print(';');
                continue;
            }
            this.out.print(c);
        }
        this.out.print("\"");
    }

    protected void emitStartTag(String tagName) {
        this.elementStack.push(tagName);
        this.elementActive = true;
        this.out.print("<");
        this.out.print(tagName);
    }

    public void endElement() {
        if (!this.pendingElementStack.isEmpty()) {
            this.pendingElementStack.pop();
            return;
        }
        if (!$assertionsDisabled && this.elementStack.size() <= 0) {
            throw new AssertionError();
        }
        String tagName = (String)this.elementStack.pop();
        if (this.elementActive) {
            this.out.print("/>");
        } else {
            this.out.print("</");
            this.out.print(tagName);
            this.out.print(">");
        }
        this.elementActive = false;
    }

    public void literal(String text) {
        this.out.print(text);
    }

    public void text(String text) {
        this.closeTextTag();
        if (text == null) {
            return;
        }
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                this.out.print("&amp;");
                continue;
            }
            if (c == '<') {
                this.out.print("&lt;");
                continue;
            }
            this.out.print(c);
        }
    }

    public void textCDATA(String text) {
        this.closeTextTag();
        if (text == null) {
            return;
        }
        this.out.print("<![CDATA[");
        this.out.print(text);
        this.out.print("]]>");
    }

    protected void checkAttribute() {
        this.flushPendingElements();
    }

    protected void printLine() {
    }

    static {
        $assertionsDisabled = !DocumentXMLWriter.class.desiredAssertionStatus();
    }
}

