/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.birt.report.model.util.XMLWriter;

public class IndentableXMLWriter
extends XMLWriter {
    protected static final int MAX_CHARS_PER_LINE = 80;
    public static final String LINE_SEPARATOR = "\n";
    protected static final String TAB = "    ";
    protected ArrayList cachedIndents = new ArrayList();
    private String lastTagName = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    public IndentableXMLWriter(File outputFile, String signature) throws IOException {
        super(outputFile, signature);
    }

    public IndentableXMLWriter(OutputStream os, String signature) throws IOException {
        super(os, signature);
    }

    protected IndentableXMLWriter() {
    }

    protected void emitStartTag(String tagName) {
        this.lastTagName = tagName;
        this.literal(this.getIndent(this.elementStack.size()));
        super.emitStartTag(tagName);
    }

    public void endElement() {
        String tagName = "";
        if (!this.elementStack.isEmpty()) {
            tagName = (String)this.elementStack.peek();
        }
        if (!(this.elementStack.isEmpty() || tagName.equalsIgnoreCase(this.lastTagName) || !this.pendingElementStack.isEmpty() && (this.pendingElementStack.isEmpty() || tagName.equals(this.pendingElementStack.peek())))) {
            this.literal(this.getIndent(this.elementStack.size() - 1));
        }
        this.lastTagName = tagName;
        super.endElement();
    }

    private String getIndent(int level) {
        String indent = "";
        if (this.cachedIndents.size() == 0) {
            this.cachedIndents.add(indent);
        } else if (this.cachedIndents.size() <= level) {
            indent = (String)this.cachedIndents.get(this.cachedIndents.size() - 1);
            indent = indent + TAB;
            this.cachedIndents.add(indent);
        } else {
            indent = (String)this.cachedIndents.get(level);
        }
        return indent;
    }

    private String getCurElementIndent() {
        if (this.cachedIndents.size() == 0) {
            return "";
        }
        String indent = (String)this.cachedIndents.get(this.elementStack.size() - 1);
        return indent;
    }

    public void indentLongText(String text) {
        if (!$assertionsDisabled && text == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && text.length() < 80) {
            throw new AssertionError();
        }
        this.closeTextTag();
        String curTabs = this.getCurElementIndent().concat(TAB);
        this.literal(LINE_SEPARATOR + curTabs);
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if (c == '&') {
                this.literal("&amp;");
            } else if (c == '<') {
                this.literal("&lt;");
            } else {
                this.literal(Character.toString(c));
            }
            if (i + 1 == len || (i + 1) % 80 != 0) continue;
            this.literal(LINE_SEPARATOR + curTabs);
        }
        this.literal(LINE_SEPARATOR + this.getCurElementIndent());
    }

    static {
        $assertionsDisabled = !IndentableXMLWriter.class.desiredAssertionStatus();
    }
}

