/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.writer;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.core.UserPropertyDefn;
import org.eclipse.birt.report.model.api.elements.structures.Action;
import org.eclipse.birt.report.model.api.elements.structures.CachedMetaData;
import org.eclipse.birt.report.model.api.elements.structures.CustomColor;
import org.eclipse.birt.report.model.api.elements.structures.EmbeddedImage;
import org.eclipse.birt.report.model.api.elements.structures.ExtendedProperty;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.elements.structures.MapRule;
import org.eclipse.birt.report.model.api.elements.structures.OdaDesignerState;
import org.eclipse.birt.report.model.api.elements.structures.StyleRule;
import org.eclipse.birt.report.model.api.extension.IEncryptionHelper;
import org.eclipse.birt.report.model.api.metadata.IChoice;
import org.eclipse.birt.report.model.api.metadata.IChoiceSet;
import org.eclipse.birt.report.model.api.metadata.IStructureDefn;
import org.eclipse.birt.report.model.api.metadata.UserChoice;
import org.eclipse.birt.report.model.api.util.StringUtil;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.StyledElement;
import org.eclipse.birt.report.model.elements.AutoText;
import org.eclipse.birt.report.model.elements.CascadingParameterGroup;
import org.eclipse.birt.report.model.elements.Cell;
import org.eclipse.birt.report.model.elements.DataItem;
import org.eclipse.birt.report.model.elements.DataSet;
import org.eclipse.birt.report.model.elements.DataSource;
import org.eclipse.birt.report.model.elements.ElementVisitor;
import org.eclipse.birt.report.model.elements.ExtendedItem;
import org.eclipse.birt.report.model.elements.FreeForm;
import org.eclipse.birt.report.model.elements.GraphicMasterPage;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.GroupElement;
import org.eclipse.birt.report.model.elements.ImageItem;
import org.eclipse.birt.report.model.elements.JointDataSet;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.elements.LineItem;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ListItem;
import org.eclipse.birt.report.model.elements.ListingElement;
import org.eclipse.birt.report.model.elements.MasterPage;
import org.eclipse.birt.report.model.elements.OdaDataSet;
import org.eclipse.birt.report.model.elements.OdaDataSource;
import org.eclipse.birt.report.model.elements.Parameter;
import org.eclipse.birt.report.model.elements.ParameterGroup;
import org.eclipse.birt.report.model.elements.RectangleItem;
import org.eclipse.birt.report.model.elements.ReportItem;
import org.eclipse.birt.report.model.elements.ScalarParameter;
import org.eclipse.birt.report.model.elements.ScriptDataSet;
import org.eclipse.birt.report.model.elements.ScriptDataSource;
import org.eclipse.birt.report.model.elements.SimpleDataSet;
import org.eclipse.birt.report.model.elements.SimpleMasterPage;
import org.eclipse.birt.report.model.elements.Style;
import org.eclipse.birt.report.model.elements.TableColumn;
import org.eclipse.birt.report.model.elements.TableGroup;
import org.eclipse.birt.report.model.elements.TableItem;
import org.eclipse.birt.report.model.elements.TableRow;
import org.eclipse.birt.report.model.elements.TemplateDataSet;
import org.eclipse.birt.report.model.elements.TemplateElement;
import org.eclipse.birt.report.model.elements.TemplateParameterDefinition;
import org.eclipse.birt.report.model.elements.TemplateReportItem;
import org.eclipse.birt.report.model.elements.TextDataItem;
import org.eclipse.birt.report.model.elements.TextItem;
import org.eclipse.birt.report.model.elements.Translation;
import org.eclipse.birt.report.model.extension.oda.ODAProvider;
import org.eclipse.birt.report.model.extension.oda.OdaDummyProvider;
import org.eclipse.birt.report.model.metadata.ElementPropertyDefn;
import org.eclipse.birt.report.model.metadata.ExtensionElementDefn;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.metadata.PropertyDefn;
import org.eclipse.birt.report.model.metadata.PropertyType;
import org.eclipse.birt.report.model.metadata.StructPropertyDefn;
import org.eclipse.birt.report.model.metadata.StructureDefn;
import org.eclipse.birt.report.model.util.ContentIterator;
import org.eclipse.birt.report.model.util.XMLWriter;
import org.eclipse.birt.report.model.writer.BoundColumnsWriterMgr;
import org.eclipse.birt.report.model.writer.IndentableXMLWriter;

public abstract class ModuleWriter
extends ElementVisitor {
    protected static final String DEFAULT_NAME_SPACE = "http://www.eclipse.org/birt/2005/design";
    protected XMLWriter writer = null;
    protected static Base64 base;
    protected BoundColumnsWriterMgr boundColumnsMgr = null;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected abstract Module getModule();

    public void write(File outputFile) throws IOException {
        this.writer = new IndentableXMLWriter(outputFile, this.getModule().getUTFSignature());
        this.writeFile();
        this.writer.close();
    }

    public void write(OutputStream os) throws IOException {
        this.writer = new IndentableXMLWriter(os, this.getModule().getUTFSignature());
        this.writeFile();
    }

    protected final void writeFile() {
        this.boundColumnsMgr = new BoundColumnsWriterMgr(this.getModule().getVersionManager().getVersion());
        this.getModule().apply(this);
        this.getModule().getVersionManager().setVersion("3.2.7");
    }

    protected void attribute(DesignElement obj, String attr, String propName) {
        ElementPropertyDefn prop = obj.getPropertyDefn(propName);
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        Object value = obj.getLocalProperty(this.getModule(), prop);
        if (value == null) {
            return;
        }
        String xml = prop.getXmlValue(this.getModule(), value);
        if (xml == null) {
            return;
        }
        this.writer.attribute(attr, xml);
    }

    protected String getTagByPropertyType(PropertyDefn prop) {
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && prop.getTypeCode() == 16) {
            throw new AssertionError();
        }
        switch (prop.getTypeCode()) {
            case 7: {
                return "expression";
            }
            case 12: {
                return "xml-property";
            }
            case 18: {
                return "method";
            }
        }
        if (prop.isEncryptable()) {
            return "encrypted-property";
        }
        return "property";
    }

    protected void property(DesignElement obj, String propName) {
        this.writeProperty(obj, null, propName, false);
    }

    protected void property(IStructure structure, String memberName) {
        this.writeProperty(structure, null, memberName, false, false);
    }

    protected void propertyCDATA(DesignElement obj, String propName) {
        this.writeProperty(obj, null, propName, true);
    }

    protected void propertyCDATA(IStructure structure, String memberName) {
        this.writeProperty(structure, null, memberName, true, false);
    }

    protected void propertyWithoutName(IStructure structure, String memberName) {
        this.writeProperty(structure, null, memberName, false, true);
    }

    protected void resourceKey(DesignElement obj, String resourceKey, String resourceValue) {
        this.resourceKey(obj, resourceKey, resourceValue, false);
    }

    protected void resourceKey(DesignElement obj, String resourceKey, String resourceName, boolean cdata) {
        ElementPropertyDefn nameProp = (ElementPropertyDefn)obj.getDefn().getProperty(resourceName);
        if (!$assertionsDisabled && nameProp == null) {
            throw new AssertionError();
        }
        Object value = obj.getLocalProperty(this.getModule(), nameProp.getName());
        String xml = nameProp.getXmlValue(this.getModule(), value);
        ElementPropertyDefn keyProp = (ElementPropertyDefn)obj.getDefn().getProperty(resourceKey);
        if (!$assertionsDisabled && keyProp == null) {
            throw new AssertionError();
        }
        value = obj.getLocalProperty(this.getModule(), keyProp.getName());
        String xmlKey = keyProp.getXmlValue(this.getModule(), value);
        if (xmlKey == null && xml == null) {
            return;
        }
        if (nameProp.getTypeCode() == 8) {
            this.writeResouceKey("html-property", resourceName, xmlKey, xml, cdata);
        } else {
            this.writeResouceKey("text-property", resourceName, xmlKey, xml, cdata);
        }
    }

    protected void resourceKey(IStructure struct, String resourceKey, String resourceName) {
        StructureDefn structDefn = (StructureDefn)struct.getDefn();
        if (!$assertionsDisabled && structDefn == null) {
            throw new AssertionError();
        }
        StructPropertyDefn nameProp = (StructPropertyDefn)structDefn.getMember(resourceName);
        if (!$assertionsDisabled && nameProp == null) {
            throw new AssertionError();
        }
        Object value = struct.getLocalProperty(this.getModule(), nameProp);
        String xml = nameProp.getXmlValue(this.getModule(), value);
        StructPropertyDefn keyProp = (StructPropertyDefn)structDefn.getMember(resourceKey);
        if (!$assertionsDisabled && keyProp == null) {
            throw new AssertionError();
        }
        value = struct.getLocalProperty(this.getModule(), keyProp);
        String xmlKey = keyProp.getXmlValue(this.getModule(), value);
        if (xmlKey == null && xml == null) {
            return;
        }
        if (nameProp.getTypeCode() == 8) {
            this.writeResouceKey("html-property", resourceName, xmlKey, xml, false);
        } else {
            this.writeResouceKey("text-property", resourceName, xmlKey, xml, false);
        }
    }

    protected void resourceKeyCDATA(DesignElement obj, String resourceKey, String resourceValue) {
        this.resourceKey(obj, resourceKey, resourceValue, true);
    }

    protected void writeEntry(String tag, String name, String value, boolean cdata) {
        this.writer.startElement(tag);
        if (name != null) {
            this.writer.attribute("name", name);
        }
        if (cdata) {
            this.writer.textCDATA(value);
        } else {
            this.writer.text(value);
        }
        this.writer.endElement();
    }

    protected void writeExtendedProperties(List properties, String propName) {
        if (properties != null && properties.size() != 0) {
            this.writer.startElement("list-property");
            this.writer.attribute("name", propName);
            Iterator iter = properties.iterator();
            while (iter.hasNext()) {
                ExtendedProperty property = (ExtendedProperty)iter.next();
                this.writer.startElement("ex-property");
                if (property.getName() != null) {
                    this.writer.startElement("name");
                    this.writer.text(property.getName());
                    this.writer.endElement();
                }
                if (property.getValue() != null) {
                    this.writer.startElement("value");
                    this.writer.text(property.getValue());
                    this.writer.endElement();
                }
                this.writer.endElement();
            }
            this.writer.endElement();
        }
    }

    protected void writeLongIndentText(String tag, String name, String value) {
        this.writer.startElement(tag);
        if (name != null) {
            this.writer.attribute("name", name);
        }
        this.writer.indentLongText(value);
        this.writer.endElement();
    }

    protected void writeProperty(DesignElement obj, String tag, String propName, boolean cdata) {
        ElementPropertyDefn propDefn = obj.getPropertyDefn(propName);
        if (propDefn == null) {
            return;
        }
        Object value = obj.getLocalProperty(this.getModule(), propName);
        if (value == null) {
            return;
        }
        String xml = propDefn.getXmlValue(this.getModule(), value);
        if (xml == null) {
            return;
        }
        if (propDefn.isEncryptable()) {
            IEncryptionHelper helper = MetaDataDictionary.getInstance().getEncryptionHelper();
            xml = helper.encrypt(xml);
        }
        if (tag == null) {
            tag = this.getTagByPropertyType(propDefn);
        }
        if (propDefn.getTypeCode() == 18) {
            cdata = true;
        }
        this.writeEntry(tag, propDefn.getName(), xml, cdata);
    }

    protected void writeProperty(IStructure struct, String tag, String memberName, boolean cdata, boolean withoutName) {
        StructureDefn structDefn = (StructureDefn)struct.getDefn();
        if (!$assertionsDisabled && structDefn == null) {
            throw new AssertionError();
        }
        StructPropertyDefn propDefn = (StructPropertyDefn)structDefn.getMember(memberName);
        if (!$assertionsDisabled && propDefn == null) {
            throw new AssertionError();
        }
        Object value = struct.getLocalProperty(this.getModule(), propDefn);
        if (value == null) {
            return;
        }
        String xml = propDefn.getXmlValue(this.getModule(), value);
        if (xml == null) {
            return;
        }
        if (propDefn.isEncryptable()) {
            IEncryptionHelper helper = MetaDataDictionary.getInstance().getEncryptionHelper();
            xml = helper.encrypt(xml);
        }
        if (tag == null) {
            tag = this.getTagByPropertyType(propDefn);
        }
        if (propDefn.getTypeCode() == 18) {
            cdata = true;
        }
        if (withoutName) {
            this.writeEntry(tag, null, xml, cdata);
        } else {
            this.writeEntry(tag, memberName, xml, cdata);
        }
    }

    protected void writeResouceKey(String tagName, String name, String key, String xml, boolean cdata) {
        if (key == null && xml == null) {
            return;
        }
        this.writer.startElement(tagName);
        this.writer.attribute("name", name);
        this.writer.attribute("key", key);
        if (cdata) {
            this.writer.textCDATA(xml);
        } else {
            this.writer.text(xml);
        }
        this.writer.endElement();
    }

    protected void writeSimpleStructureList(DesignElement obj, String propName, String memberName) {
        ElementPropertyDefn prop = (ElementPropertyDefn)obj.getDefn().getProperty(propName);
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || prop.getTypeCode() == 16 && prop.isList())) {
            throw new AssertionError();
        }
        List list = (List)obj.getLocalProperty(this.getModule(), propName);
        if (list == null || list.size() == 0) {
            return;
        }
        this.writer.startElement("list-property");
        this.writer.attribute("name", propName);
        ElementPropertyDefn propDef = (ElementPropertyDefn)obj.getDefn().getProperty(propName);
        PropertyDefn memberDefn = (PropertyDefn)propDef.getStructDefn().getMember(memberName);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IStructure struct = (IStructure)iter.next();
            this.propertyWithoutName(struct, memberDefn.getName());
        }
        this.writer.endElement();
    }

    protected void writeStructure(DesignElement obj, String propName) {
        ElementPropertyDefn prop = (ElementPropertyDefn)obj.getDefn().getProperty(propName);
        if (prop == null) {
            return;
        }
        IStructure struct = (IStructure)obj.getLocalProperty(this.getModule(), propName);
        if (struct == null) {
            return;
        }
        this.writer.conditionalStartElement("structure");
        this.writer.attribute("name", propName);
        IStructureDefn structDefn = prop.getStructDefn();
        Iterator iter = structDefn.propertiesIterator();
        while (iter.hasNext()) {
            StructPropertyDefn strcutPropDefn = (StructPropertyDefn)iter.next();
            this.property(struct, strcutPropDefn.getName());
        }
        this.writer.endElement();
    }

    protected void writeSimplePropertyList(DesignElement obj, String propName) {
        ElementPropertyDefn prop = (ElementPropertyDefn)obj.getDefn().getProperty(propName);
        if (prop == null || prop.getTypeCode() != 20) {
            return;
        }
        List values = (List)obj.getLocalProperty(this.getModule(), propName);
        if (values == null || values.isEmpty()) {
            return;
        }
        this.writer.conditionalStartElement("simple-property-list");
        this.writer.attribute("name", propName);
        for (int i = 0; i < values.size(); ++i) {
            PropertyType type = prop.getSubType();
            String xmlValue = type.toXml(this.getModule(), prop, values.get(i));
            if (xmlValue == null) continue;
            this.writer.startElement("value");
            this.writer.text(xmlValue);
            this.writer.endElement();
        }
        this.writer.endElement();
    }

    protected void writeStructure(IStructure struct, String memberName) {
        IStructureDefn structDefn = struct.getDefn().getMember(memberName).getStructDefn();
        IStructure memberStruct = (IStructure)struct.getLocalProperty(null, (PropertyDefn)struct.getDefn().getMember(memberName));
        if (memberStruct == null) {
            return;
        }
        this.writer.conditionalStartElement("structure");
        this.writer.attribute("name", memberName);
        Iterator iter = structDefn.propertiesIterator();
        while (iter.hasNext()) {
            StructPropertyDefn strcutPropDefn = (StructPropertyDefn)iter.next();
            this.property(memberStruct, strcutPropDefn.getName());
        }
        this.writer.endElement();
    }

    protected void writeStructureList(DesignElement obj, String propName) {
        ElementPropertyDefn prop = (ElementPropertyDefn)obj.getDefn().getProperty(propName);
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || prop.getTypeCode() == 16 && prop.isList())) {
            throw new AssertionError();
        }
        List list = (List)obj.getLocalProperty(this.getModule(), propName);
        if (list == null || list.size() == 0) {
            return;
        }
        this.writer.startElement("list-property");
        this.writer.attribute("name", propName);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IStructure struct = (IStructure)iter.next();
            this.writer.startElement("structure");
            Iterator memberIter = prop.getStructDefn().propertiesIterator();
            while (memberIter.hasNext()) {
                PropertyDefn memberDefn = (PropertyDefn)memberIter.next();
                this.property(struct, memberDefn.getName());
            }
            this.writer.endElement();
        }
        this.writer.endElement();
    }

    protected void writeStructureList(IStructure obj, String memberName) {
        PropertyDefn prop = (PropertyDefn)obj.getDefn().getMember(memberName);
        if (!$assertionsDisabled && prop == null) {
            throw new AssertionError();
        }
        if (!($assertionsDisabled || prop.getTypeCode() == 16 && prop.isList())) {
            throw new AssertionError();
        }
        List list = (List)obj.getLocalProperty(this.getModule(), prop);
        if (list == null || list.size() == 0) {
            return;
        }
        this.writer.startElement("list-property");
        this.writer.attribute("name", memberName);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            IStructure struct = (IStructure)iter.next();
            this.writer.startElement("structure");
            Iterator memberIter = prop.getStructDefn().propertiesIterator();
            while (memberIter.hasNext()) {
                PropertyDefn memberDefn = (PropertyDefn)memberIter.next();
                this.property(struct, memberDefn.getName());
            }
            this.writer.endElement();
        }
        this.writer.endElement();
    }

    protected void writeUserPropertyDefns(DesignElement obj) {
        List props = obj.getLocalUserProperties();
        if (props == null || props.size() == 0) {
            return;
        }
        this.writer.startElement("list-property");
        this.writer.attribute("name", "userProperties");
        Iterator iter = props.iterator();
        while (iter.hasNext()) {
            IChoiceSet choiceSet;
            UserPropertyDefn propDefn = (UserPropertyDefn)iter.next();
            this.writer.startElement("structure");
            this.property(propDefn, "name");
            this.property(propDefn, "type");
            this.resourceKey(propDefn, "displayNameID", "displayName");
            if (propDefn.getDefault() != null) {
                this.writeEntry("property", "default", propDefn.getXmlValue(null, propDefn.getDefault()), false);
            }
            if ((choiceSet = propDefn.getChoices()) != null && choiceSet.getChoices() != null && choiceSet.getChoices().length > 0) {
                this.writer.startElement("list-property");
                this.writer.attribute("name", "choices");
                IChoice[] choices = choiceSet.getChoices();
                for (int i = 0; i < choices.length; ++i) {
                    UserChoice choice = (UserChoice)choices[i];
                    this.writer.startElement("structure");
                    this.writeEntry("property", "name", choice.getName(), false);
                    if (choice.getValue() != null) {
                        this.writeEntry("property", "value", choice.getValue().toString(), false);
                    }
                    this.writeResouceKey("text-property", "displayName", choice.getDisplayNameKey(), choice.getDisplayName(), false);
                    this.writer.endElement();
                }
                this.writer.endElement();
            }
            this.writer.endElement();
        }
        this.writer.endElement();
    }

    protected void writeUserPropertyValues(DesignElement obj) {
        List userProps = obj.getUserProperties();
        if (userProps == null || userProps.size() == 0) {
            return;
        }
        Iterator iter = userProps.iterator();
        while (iter.hasNext()) {
            UserPropertyDefn propDefn = (UserPropertyDefn)iter.next();
            this.property(obj, propDefn.getName());
        }
    }

    public void visitModule(Module obj) {
        this.writer.attribute("xmlns", DEFAULT_NAME_SPACE);
        this.writer.attribute("version", "3.2.7");
        this.writer.attribute("id", new Long(obj.getID()).toString());
        this.property(obj, "author");
        this.property(obj, "helpGuide");
        this.property(obj, "createdBy");
        this.property(obj, "units");
        this.property(obj, "base");
        this.property(obj, "includeResource");
        this.resourceKey(obj, "titleID", "title");
        this.property(obj, "comments");
        this.resourceKey(obj, "descriptionID", "description");
        this.writeUserPropertyDefns(obj);
        this.writeUserPropertyValues(obj);
        this.writeStructureList(obj, "propertyBindings");
        this.writeStructureList(obj, "scriptLibs");
    }

    protected void writeEmbeddedImages(Module obj) {
        List list = (List)obj.getLocalProperty(obj, "images");
        if (list != null && list.size() > 0) {
            this.writer.startElement("list-property");
            this.writer.attribute("name", "images");
            for (int i = 0; i < list.size(); ++i) {
                block7: {
                    EmbeddedImage image = (EmbeddedImage)list.get(i);
                    this.writer.startElement("structure");
                    this.property(image, "name");
                    this.property(image, "type");
                    this.property(image, "libReference");
                    try {
                        if (image.getLocalProperty(this.getModule(), (PropertyDefn)image.getDefn().getMember("data")) != null) {
                            byte[] data = base.encode(image.getData(this.getModule()));
                            String value = new String(data, "8859_1");
                            if (value.length() < 80) {
                                this.writeEntry("property", "data", value, false);
                            } else {
                                this.writeLongIndentText("property", "data", value);
                            }
                        }
                    }
                    catch (UnsupportedEncodingException e) {
                        if ($assertionsDisabled) break block7;
                        throw new AssertionError();
                    }
                }
                this.writer.endElement();
            }
            this.writer.endElement();
        }
    }

    protected void writeTranslations(Module obj) {
        String[] resourceKeys = obj.getTranslationResourceKeys();
        if (resourceKeys != null && resourceKeys.length > 0) {
            this.writer.startElement("translations");
            for (int i = 0; i < resourceKeys.length; ++i) {
                this.writer.startElement("resource");
                this.writer.attribute("key", resourceKeys[i]);
                List translations = obj.getTranslations(resourceKeys[i]);
                for (int j = 0; j < translations.size(); ++j) {
                    this.writer.startElement("translation");
                    Translation translation = (Translation)translations.get(j);
                    this.writer.attribute("locale", translation.getLocale());
                    this.writer.text(translation.getText());
                    this.writer.endElement();
                }
                this.writer.endElement();
            }
            this.writer.endElement();
        }
    }

    protected void writeCustomColors(Module obj) {
        List list = (List)obj.getLocalProperty(obj, "colorPalette");
        if (list != null && list.size() > 0) {
            this.writer.startElement("list-property");
            this.writer.attribute("name", "colorPalette");
            for (int i = 0; i < list.size(); ++i) {
                CustomColor color = (CustomColor)list.get(i);
                this.writer.startElement("structure");
                this.property(color, "name");
                this.property(color, "color");
                this.resourceKey(color, "displayNameID", "displayName");
                this.writer.endElement();
            }
            this.writer.endElement();
        }
    }

    public void visitScriptDataSource(ScriptDataSource obj) {
        this.writer.startElement("script-data-source");
        super.visitScriptDataSource(obj);
        this.property(obj, "open");
        this.property(obj, "close");
        this.writer.endElement();
    }

    public void visitOdaDataSource(OdaDataSource obj) {
        this.writer.startElement("oda-data-source");
        this.attribute(obj, "extensionID", "extensionID");
        super.visitOdaDataSource(obj);
        this.writeOdaDesignerState(obj, "designerState");
        List properties = (List)obj.getLocalProperty(this.getModule(), "privateDriverProperties");
        this.writeExtendedProperties(properties, "privateDriverProperties");
        this.writeOdaExtensionProperties(obj, "extensionID");
        this.writer.endElement();
    }

    private void writeOdaExtensionProperties(DesignElement obj, String extensionIDProp) {
        ExtensionElementDefn extDefn = null;
        if (obj instanceof OdaDataSource) {
            extDefn = ((OdaDataSource)obj).getExtDefn();
        } else if (obj instanceof OdaDataSet) {
            extDefn = ((OdaDataSet)obj).getExtDefn();
        }
        if (extDefn == null) {
            ODAProvider provider = null;
            if (obj instanceof OdaDataSource) {
                provider = ((OdaDataSource)obj).getProvider();
            }
            if (obj instanceof OdaDataSet) {
                provider = ((OdaDataSet)obj).getProvider();
            }
            if (provider instanceof OdaDummyProvider) {
                this.writeOdaDummyProperties(obj, provider);
            }
            return;
        }
        List list = extDefn.getLocalProperties();
        for (int i = 0; i < list.size(); ++i) {
            Object value;
            PropertyDefn prop = (PropertyDefn)list.get(i);
            if (extensionIDProp.equals(prop.getName()) || (value = obj.getLocalProperty(this.getModule(), prop.getName())) == null) continue;
            boolean cdata = false;
            if (prop.getTypeCode() == 12 || prop.getTypeCode() == 18) {
                cdata = true;
            }
            this.writeProperty(obj, this.getTagByPropertyType(prop), prop.getName(), cdata);
        }
    }

    private void writeOdaDummyProperties(DesignElement obj, ODAProvider provider) {
        if (!$assertionsDisabled && !(provider instanceof OdaDummyProvider)) {
            throw new AssertionError();
        }
        OdaDummyProvider dummyProvider = (OdaDummyProvider)provider;
        List propNames = dummyProvider.getPropertyNames();
        for (int i = 0; i < propNames.size(); ++i) {
            String propName = (String)propNames.get(i);
            String tagName = dummyProvider.getTagName(propName);
            String value = dummyProvider.getValue(propName);
            boolean cdata = false;
            if (dummyProvider.getPropertyTypeCode(propName) == 18 || dummyProvider.getPropertyTypeCode(propName) == 12) {
                cdata = true;
            }
            this.writeEntry(tagName, propName, value, cdata);
        }
    }

    public void visitScriptDataSet(ScriptDataSet obj) {
        this.writer.startElement("script-data-set");
        super.visitScriptDataSet(obj);
        this.writeStructureList(obj, "parameters");
        this.property(obj, "open");
        this.property(obj, "describe");
        this.property(obj, "fetch");
        this.property(obj, "close");
        this.writer.endElement();
    }

    public void visitFreeForm(FreeForm obj) {
        this.writer.startElement("free-form");
        super.visitFreeForm(obj);
        this.writeContents(obj, 0, "report-items");
        this.writer.endElement();
    }

    public void visitDataItem(DataItem obj) {
        this.boundColumnsMgr.dealData(obj, this.getModule());
        this.writer.startElement("data");
        super.visitDataItem(obj);
        this.property(obj, "resultSetColumn");
        this.resourceKey(obj, "helpTextID", "helpText");
        this.writeAction(obj, "action");
        this.writer.endElement();
    }

    public void visitTextDataItem(TextDataItem obj) {
        this.boundColumnsMgr.dealTextData(obj, this.getModule());
        this.writer.startElement("text-data");
        super.visitTextDataItem(obj);
        this.property(obj, "valueExpr");
        this.property(obj, "contentType");
        this.writer.endElement();
    }

    public void visitExtendedItem(ExtendedItem obj) {
        this.boundColumnsMgr.dealExtendedItem(obj, this.getModule());
        this.writer.startElement("extended-item");
        this.attribute(obj, "extensionName", "extensionName");
        super.visitExtendedItem(obj);
        this.resourceKey(obj, "altTextID", "altText");
        ExtensionElementDefn extDefn = obj.getExtDefn();
        if (extDefn != null) {
            List list = extDefn.getLocalProperties();
            for (int i = 0; i < list.size(); ++i) {
                PropertyDefn prop = (PropertyDefn)list.get(i);
                if ("extensionName".equals(prop.getName())) continue;
                if (prop.getTypeCode() != 12) {
                    this.writeProperty(obj, this.getTagByPropertyType(prop), prop.getName(), false);
                    continue;
                }
                this.writeProperty(obj, this.getTagByPropertyType(prop), prop.getName(), true);
            }
        }
        this.writeStructureList(obj, "filter");
        this.writer.endElement();
    }

    public void visitTextItem(TextItem obj) {
        this.boundColumnsMgr.dealText(obj, this.getModule());
        this.writer.startElement("text");
        super.visitTextItem(obj);
        this.property(obj, "contentType");
        this.resourceKeyCDATA(obj, "contentID", "content");
        this.writer.endElement();
    }

    public void visitLabel(Label obj) {
        this.boundColumnsMgr.dealLabel(obj, this.getModule());
        this.writer.startElement("label");
        super.visitLabel(obj);
        this.resourceKey(obj, "textID", "text");
        this.resourceKey(obj, "helpTextID", "helpText");
        this.writeAction(obj, "action");
        this.writer.endElement();
    }

    public void visitAutoText(AutoText obj) {
        this.writer.startElement("auto-text");
        super.visitAutoText(obj);
        this.property(obj, "type");
        this.writer.endElement();
    }

    public void visitList(ListItem obj) {
        this.boundColumnsMgr.dealList(obj, this.getModule());
        this.writer.startElement("list");
        super.visitList(obj);
        this.writeContents(obj, 0, "header");
        this.writeContents(obj, 1, null);
        this.writeContents(obj, 2, "detail");
        this.writeContents(obj, 3, "footer");
        this.writer.endElement();
    }

    public void visitListGroup(ListGroup obj) {
        this.writer.startElement("group");
        super.visitListGroup(obj);
        this.writeContents(obj, 0, "header");
        this.writeContents(obj, 1, "footer");
        this.writer.endElement();
    }

    public void visitTable(TableItem obj) {
        this.boundColumnsMgr.dealTable(obj, this.getModule());
        this.writer.startElement("table");
        super.visitTable(obj);
        this.resourceKey(obj, "captionID", "caption");
        this.writeColumns(obj, 4);
        this.writeContents(obj, 0, "header");
        this.writeContents(obj, 1, null);
        this.writeContents(obj, 2, "detail");
        this.writeContents(obj, 3, "footer");
        this.writer.endElement();
    }

    public void visitTableGroup(TableGroup obj) {
        this.writer.startElement("group");
        super.visitTableGroup(obj);
        this.writeContents(obj, 0, "header");
        this.writeContents(obj, 1, "footer");
        this.writer.endElement();
    }

    public void visitColumn(TableColumn obj) {
        this.writer.startElement("column");
        this.writer.attribute("id", new Long(obj.getID()).toString());
        this.attribute(obj, "viewAction", "viewAction");
        super.visitColumn(obj);
        this.property(obj, "width");
        this.property(obj, "repeat");
        this.property(obj, "suppressDuplicates");
        this.writeStructureList(obj, "visibility");
        this.writeStyle(obj);
        this.writer.endElement();
    }

    public void visitRow(TableRow obj) {
        this.writer.startElement("row");
        this.writer.attribute("id", new Long(obj.getID()).toString());
        this.attribute(obj, "viewAction", "viewAction");
        super.visitRow(obj);
        this.property(obj, "height");
        this.property(obj, "bookmark");
        this.property(obj, "suppressDuplicates");
        this.property(obj, "eventHandlerClass");
        this.property(obj, "onPrepare");
        this.property(obj, "onCreate");
        this.property(obj, "onRender");
        this.writeUserPropertyDefns(obj);
        this.writeUserPropertyValues(obj);
        this.writeStyle(obj);
        this.writeStructureList(obj, "visibility");
        this.writeContents(obj, 0, null);
        this.writer.endElement();
    }

    public void visitCell(Cell obj) {
        this.writer.startElement("cell");
        this.writer.attribute("id", new Long(obj.getID()).toString());
        this.attribute(obj, "viewAction", "viewAction");
        super.visitCell(obj);
        this.property(obj, "column");
        this.property(obj, "colSpan");
        this.property(obj, "rowSpan");
        this.property(obj, "drop");
        this.property(obj, "height");
        this.property(obj, "width");
        this.property(obj, "eventHandlerClass");
        this.property(obj, "onPrepare");
        this.property(obj, "onCreate");
        this.property(obj, "onRender");
        this.writeStyle(obj);
        this.writeContents(obj, 0, null);
        this.writer.endElement();
    }

    public void visitGrid(GridItem obj) {
        this.boundColumnsMgr.dealGrid(obj, this.getModule());
        this.writer.startElement("grid");
        super.visitGrid(obj);
        this.writeColumns(obj, 0);
        this.writeContents(obj, 1, null);
        this.writer.endElement();
    }

    public void visitLine(LineItem obj) {
        this.writer.startElement("line");
        super.visitLine(obj);
        this.property(obj, "orientation");
        this.writer.endElement();
    }

    public void visitGraphicMasterPage(GraphicMasterPage obj) {
        this.writer.startElement("graphic-master-page");
        super.visitGraphicMasterPage(obj);
        this.property(obj, "columns");
        this.property(obj, "columnSpacing");
        this.writeContents(obj, 0, "contents");
        this.writer.endElement();
    }

    public void visitSimpleMasterPage(SimpleMasterPage obj) {
        this.writer.startElement("simple-master-page");
        super.visitSimpleMasterPage(obj);
        this.property(obj, "showHeaderOnFirst");
        this.property(obj, "showFooterOnLast");
        this.property(obj, "floatingFooter");
        this.property(obj, "headerHeight");
        this.property(obj, "footerHeight");
        this.writeContents(obj, 0, "page-header");
        this.writeContents(obj, 1, "page-footer");
        this.writer.endElement();
    }

    public void visitParameterGroup(ParameterGroup obj) {
        this.writer.startElement("parameter-group");
        super.visitParameterGroup(obj);
        this.property(obj, "startExpanded");
        this.resourceKey(obj, "helpTextID", "helpText");
        this.writeContents(obj, 0, "parameters");
        this.writer.endElement();
    }

    public void visitCascadingParameterGroup(CascadingParameterGroup obj) {
        this.writer.startElement("cascading-parameter-group");
        super.visitParameterGroup(obj);
        this.property(obj, "startExpanded");
        this.resourceKey(obj, "helpTextID", "helpText");
        this.property(obj, "dataSet");
        this.property(obj, "promptText");
        this.property(obj, "dataSetMode");
        this.writeContents(obj, 0, "parameters");
        this.writeOverridenPropertyValues(obj);
        this.writer.endElement();
    }

    public void visitScalarParameter(ScalarParameter obj) {
        this.boundColumnsMgr.dealScalarParameter(obj, this.getModule());
        this.writer.startElement("scalar-parameter");
        super.visitScalarParameter(obj);
        this.property(obj, "valueType");
        this.property(obj, "dataType");
        this.resourceKey(obj, "promptTextID", "promptText");
        this.property(obj, "listLimit");
        this.property(obj, "concealValue");
        this.property(obj, "allowBlank");
        this.property(obj, "allowNull");
        this.property(obj, "controlType");
        this.property(obj, "alignment");
        this.property(obj, "dataSetName");
        this.property(obj, "valueExpr");
        this.property(obj, "labelExpr");
        this.property(obj, "mustMatch");
        this.property(obj, "fixedOrder");
        this.property(obj, "defaultValue");
        this.property(obj, "distinct");
        this.property(obj, "sortBy");
        this.property(obj, "sortDirection");
        this.writeStructure(obj, "format");
        this.writeStructureList(obj, "selectionList");
        this.writeStructureList(obj, "boundDataColumns");
        this.writer.endElement();
    }

    public void visitTemplateDataSet(TemplateDataSet obj) {
        this.writer.startElement("template-data-set");
        super.visitTemplateDataSet(obj);
        this.writer.endElement();
    }

    public void visitTemplateElement(TemplateElement obj) {
        this.attribute(obj, "name", "name");
        this.writer.attribute("id", new Long(obj.getID()).toString());
        this.resourceKey(obj, "displayNameID", "displayName");
        this.property(obj, "refTemplateParameter");
    }

    public void visitTemplateParameterDefinition(TemplateParameterDefinition obj) {
        this.writer.startElement("template-parameter-definition");
        this.attribute(obj, "name", "name");
        this.writer.attribute("id", new Long(obj.getID()).toString());
        this.property(obj, "allowedType");
        this.resourceKey(obj, "descriptionID", "description");
        this.writeContents(obj, 0, "default");
        this.writer.endElement();
    }

    public void visitTemplateReportItem(TemplateReportItem obj) {
        this.boundColumnsMgr.dealTemplateReportItem(obj, this.getModule());
        this.writer.startElement("template-report-item");
        super.visitTemplateReportItem(obj);
        this.writeStructureList(obj, "visibility");
        this.writeUserPropertyDefns(obj);
        this.writeUserPropertyValues(obj);
        this.writer.endElement();
    }

    public void visitStyle(Style obj) {
        this.writer.startElement("style");
        super.visitStyle(obj);
        this.writeStyleProps(obj);
        this.writer.endElement();
    }

    private void writeStyleProps(DesignElement obj) {
        StyleRule rule;
        int i;
        this.property(obj, "backgroundAttachment");
        this.property(obj, "backgroundColor");
        this.property(obj, "backgroundImage");
        this.property(obj, "backgroundPositionX");
        this.property(obj, "backgroundPositionY");
        this.property(obj, "backgroundRepeat");
        this.property(obj, "fontFamily");
        this.property(obj, "fontSize");
        this.property(obj, "fontWeight");
        this.property(obj, "fontStyle");
        this.property(obj, "fontVariant");
        this.property(obj, "color");
        this.property(obj, "textLineThrough");
        this.property(obj, "textOverline");
        this.property(obj, "textUnderline");
        this.property(obj, "borderBottomColor");
        this.property(obj, "borderBottomStyle");
        this.property(obj, "borderBottomWidth");
        this.property(obj, "borderLeftColor");
        this.property(obj, "borderLeftStyle");
        this.property(obj, "borderLeftWidth");
        this.property(obj, "borderRightColor");
        this.property(obj, "borderRightStyle");
        this.property(obj, "borderRightWidth");
        this.property(obj, "borderTopColor");
        this.property(obj, "borderTopStyle");
        this.property(obj, "borderTopWidth");
        this.property(obj, "marginTop");
        this.property(obj, "marginLeft");
        this.property(obj, "marginBottom");
        this.property(obj, "marginRight");
        this.property(obj, "paddingTop");
        this.property(obj, "paddingLeft");
        this.property(obj, "paddingBottom");
        this.property(obj, "paddingRight");
        this.property(obj, "numberAlign");
        this.writeStructure(obj, "dateTimeFormat");
        this.writeStructure(obj, "numberFormat");
        this.writeStructure(obj, "stringFormat");
        this.property(obj, "textAlign");
        this.property(obj, "textIndent");
        this.property(obj, "letterSpacing");
        this.property(obj, "lineHeight");
        this.property(obj, "orphans");
        this.property(obj, "textTransform");
        this.property(obj, "verticalAlign");
        this.property(obj, "whiteSpace");
        this.property(obj, "widows");
        this.property(obj, "wordSpacing");
        this.property(obj, "display");
        this.property(obj, "masterPage");
        this.property(obj, "pageBreakAfter");
        this.property(obj, "pageBreakBefore");
        this.property(obj, "pageBreakInside");
        this.property(obj, "showIfBlank");
        this.property(obj, "canShrink");
        ArrayList list = (ArrayList)obj.getLocalProperty(this.getModule(), "highlightRules");
        if (list != null && list.size() > 0) {
            this.writer.startElement("list-property");
            this.writer.attribute("name", "highlightRules");
            for (i = 0; i < list.size(); ++i) {
                rule = (HighlightRule)list.get(i);
                this.writer.startElement("structure");
                this.property(rule, "isDesignTime");
                this.property(rule, "operator");
                this.property(rule, "backgroundColor");
                this.property(rule, "borderTopStyle");
                this.property(rule, "borderTopWidth");
                this.property(rule, "borderTopColor");
                this.property(rule, "borderLeftStyle");
                this.property(rule, "borderLeftWidth");
                this.property(rule, "borderLeftColor");
                this.property(rule, "borderBottomStyle");
                this.property(rule, "borderBottomWidth");
                this.property(rule, "borderBottomColor");
                this.property(rule, "borderRightStyle");
                this.property(rule, "borderRightWidth");
                this.property(rule, "borderRightColor");
                this.property(rule, "fontFamily");
                this.property(rule, "fontSize");
                this.property(rule, "fontStyle");
                this.property(rule, "fontWeight");
                this.property(rule, "fontVariant");
                this.property(rule, "color");
                this.property(rule, "textUnderline");
                this.property(rule, "textOverline");
                this.property(rule, "textLineThrough");
                this.property(rule, "textAlign");
                this.property(rule, "textTransform");
                this.property(rule, "textIndent");
                this.property(rule, "numberAlign");
                this.writeStructure(rule, "dateTimeFormat");
                this.writeStructure(rule, "numberFormat");
                this.writeStructure(rule, "stringFormat");
                this.property(rule, "testExpr");
                this.property(rule, "value1");
                this.property(rule, "value2");
                this.writer.endElement();
            }
            this.writer.endElement();
        }
        if ((list = (ArrayList)obj.getLocalProperty(this.getModule(), "mapRules")) != null && list.size() > 0) {
            this.writer.startElement("list-property");
            this.writer.attribute("name", "mapRules");
            for (i = 0; i < list.size(); ++i) {
                rule = (MapRule)list.get(i);
                this.writer.startElement("structure");
                this.property(rule, "isDesignTime");
                this.property(rule, "testExpr");
                this.property(rule, "operator");
                this.property(rule, "value1");
                this.property(rule, "value2");
                this.resourceKey(rule, "displayID", "display");
                this.writer.endElement();
            }
            this.writer.endElement();
        }
    }

    protected void writeContents(DesignElement obj, int slot, String tag) {
        List list = obj.getSlot(slot).getContents();
        if (list.isEmpty()) {
            return;
        }
        if (obj.getExtendsElement() != null) {
            return;
        }
        if (tag != null) {
            this.writer.conditionalStartElement(tag);
        }
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            ((DesignElement)iter.next()).apply(this);
        }
        if (tag != null) {
            this.writer.endElement();
        }
    }

    protected void writeArrangedContents(DesignElement obj, int slot, String tag) {
        List list = obj.getSlot(slot).getContents();
        if (list.isEmpty()) {
            return;
        }
        LinkedList<DesignElement> newList = new LinkedList<DesignElement>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            int index;
            DesignElement element = (DesignElement)iter.next();
            DesignElement parent = element.getExtendsElement();
            if (!newList.contains(element)) {
                newList.add(element);
            }
            if (parent == null || !list.contains(parent)) continue;
            if (!newList.contains(parent)) {
                index = newList.indexOf(element);
                newList.add(index, parent);
                continue;
            }
            if (newList.indexOf(element) >= newList.indexOf(parent)) continue;
            newList.remove(parent);
            index = newList.indexOf(element);
            newList.add(index, parent);
        }
        if (tag != null) {
            this.writer.conditionalStartElement(tag);
        }
        iter = newList.iterator();
        while (iter.hasNext()) {
            ((DesignElement)iter.next()).apply(this);
        }
        if (tag != null) {
            this.writer.endElement();
        }
    }

    public void visitRectangle(RectangleItem obj) {
        this.writer.startElement("rectangle");
        super.visitRectangle(obj);
        this.writer.endElement();
    }

    public void visitImage(ImageItem obj) {
        this.boundColumnsMgr.dealImage(obj, this.getModule());
        this.writer.startElement("image");
        super.visitImage(obj);
        this.property(obj, "size");
        this.property(obj, "scale");
        this.property(obj, "source");
        String source = (String)obj.getLocalProperty(this.getModule(), "source");
        if ("url".equalsIgnoreCase(source) || "file".equalsIgnoreCase(source)) {
            this.property(obj, "uri");
        } else if ("embed".equalsIgnoreCase(source)) {
            this.property(obj, "imageName");
        } else if ("expr".equalsIgnoreCase(source)) {
            this.property(obj, "typeExpr");
            this.property(obj, "valueExpr");
        }
        this.resourceKey(obj, "altTextID", "altText");
        this.resourceKey(obj, "helpTextID", "helpText");
        this.writeAction(obj, "action");
        this.writer.endElement();
    }

    protected void writeAction(DesignElement obj, String propName) {
        Action action = (Action)obj.getLocalProperty(this.getModule(), propName);
        if (action == null) {
            return;
        }
        this.writeAction(action, propName);
    }

    protected void writeAction(Action action, String propName) {
        String linkType = (String)action.getProperty(this.getModule(), "linkType");
        this.writer.startElement("structure");
        this.writer.attribute("name", propName);
        this.property(action, "formatType");
        this.property(action, "linkType");
        if ("hyperlink".equalsIgnoreCase(linkType)) {
            this.property(action, "uri");
            this.property(action, "targetWindow");
            this.property(action, "targetFileType");
        } else if ("bookmark-link".equalsIgnoreCase(linkType)) {
            this.property(action, "targetBookmark");
            this.property(action, "targetBookmarkType");
        } else if ("drill-through".equalsIgnoreCase(linkType)) {
            this.property(action, "reportName");
            this.property(action, "targetBookmark");
            this.property(action, "targetBookmarkType");
            this.property(action, "targetWindow");
            this.property(action, "targetFileType");
            this.writeStructureList(action, "paramBindings");
            this.writeStructureList(action, "search");
        } else if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        this.writer.endElement();
    }

    public void visitDesignElement(DesignElement obj) {
        super.visitDesignElement(obj);
        this.attribute(obj, "name", "name");
        this.writer.attribute("id", new Long(obj.getID()).toString());
        this.attribute(obj, "extends", "extends");
        this.attribute(obj, "viewAction", "viewAction");
        this.property(obj, "comments");
        this.propertyCDATA(obj, "customXml");
        this.resourceKey(obj, "displayNameID", "displayName");
        this.property(obj, "eventHandlerClass");
        this.writeUserPropertyDefns(obj);
        this.writeUserPropertyValues(obj);
        this.writeStructureList(obj, "propertyMasks");
    }

    public void visitDataSet(DataSet obj) {
        super.visitDataSet(obj);
        this.writeStructureList(obj, "resultSetHints");
        this.writeStructureList(obj, "computedColumns");
        this.writeStructureList(obj, "columnHints");
        this.writeStructureList(obj, "filter");
        CachedMetaData metadata = (CachedMetaData)obj.getLocalProperty(this.getModule(), "cachedMetaData");
        if (metadata != null) {
            this.writer.startElement("structure");
            this.writer.attribute("name", "cachedMetaData");
            this.writeStructureList(metadata, "parameters");
            this.writeStructureList(metadata, "resultSet");
            this.writer.endElement();
        }
        this.property(obj, "rowFetchLimit");
    }

    public void visitSimpleDataSet(SimpleDataSet obj) {
        super.visitSimpleDataSet(obj);
        this.property(obj, "dataSource");
        this.property(obj, "beforeOpen");
        this.property(obj, "beforeClose");
        this.property(obj, "onFetch");
        this.property(obj, "afterOpen");
        this.property(obj, "afterClose");
        this.property(obj, "refTemplateParameter");
        this.property(obj, "dataSetRowLimit");
        this.writeStructureList(obj, "paramBindings");
    }

    public void visitDataSource(DataSource obj) {
        super.visitDataSource(obj);
        this.property(obj, "beforeOpen");
        this.property(obj, "beforeClose");
        this.property(obj, "afterOpen");
        this.property(obj, "afterClose");
    }

    public void visitParameter(Parameter obj) {
        super.visitParameter(obj);
        this.property(obj, "hidden");
        this.resourceKey(obj, "helpTextID", "helpText");
        this.property(obj, "validate");
    }

    public void visitReportItem(ReportItem obj) {
        super.visitReportItem(obj);
        this.property(obj, "x");
        this.property(obj, "y");
        this.property(obj, "height");
        this.property(obj, "width");
        this.property(obj, "dataSet");
        this.property(obj, "refTemplateParameter");
        this.writeStructureList(obj, "visibility");
        this.writeStructureList(obj, "paramBindings");
        this.writeStructureList(obj, "boundDataColumns");
        this.property(obj, "bookmark");
        this.property(obj, "toc");
        this.property(obj, "onPrepare");
        this.property(obj, "onCreate");
        this.property(obj, "onRender");
        this.property(obj, "onPageBreak");
        this.writeOverridenPropertyValues(obj);
    }

    public void visitMasterPage(MasterPage obj) {
        super.visitMasterPage(obj);
        this.property(obj, "type");
        String type = (String)obj.getLocalProperty(this.getModule(), "type");
        if ("custom".equalsIgnoreCase(type)) {
            this.property(obj, "height");
            this.property(obj, "width");
        }
        this.property(obj, "orientation");
        this.property(obj, "topMargin");
        this.property(obj, "leftMargin");
        this.property(obj, "bottomMargin");
        this.property(obj, "rightMargin");
        this.writeStyle(obj);
        this.writeOverridenPropertyValues(obj);
    }

    public void visitStyledElement(StyledElement obj) {
        super.visitStyledElement(obj);
        this.writeStyle(obj);
    }

    private void writeStyle(StyledElement obj) {
        this.property(obj, "style");
        this.writeStyleProps(obj);
    }

    public void visitListing(ListingElement obj) {
        super.visitListing(obj);
        this.property(obj, "repeatHeader");
        this.property(obj, "pageBreakInterval");
        this.writeStructureList(obj, "sort");
        this.writeStructureList(obj, "filter");
    }

    public void visitGroup(GroupElement obj) {
        this.writer.attribute("id", new Long(obj.getID()).toString());
        this.attribute(obj, "viewAction", "viewAction");
        super.visitGroup(obj);
        this.property(obj, "groupName");
        this.property(obj, "intervalBase");
        this.property(obj, "interval");
        this.property(obj, "intervalRange");
        this.property(obj, "sortDirection");
        this.property(obj, "sortType");
        this.property(obj, "keyExpr");
        this.property(obj, "toc");
        this.property(obj, "eventHandlerClass");
        this.property(obj, "onPrepare");
        this.property(obj, "onPageBreak");
        this.property(obj, "repeatHeader");
        this.property(obj, "hideDetail");
        this.property(obj, "pageBreakAfter");
        this.property(obj, "pageBreakBefore");
        this.writeUserPropertyDefns(obj);
        this.writeUserPropertyValues(obj);
        this.writeStructureList(obj, "sort");
        this.writeStructureList(obj, "filter");
    }

    public void visitOdaDataSet(OdaDataSet obj) {
        this.writer.startElement("oda-data-set");
        this.attribute(obj, "extensionID", "extensionID");
        super.visitOdaDataSet(obj);
        this.writeStructureList(obj, "parameters");
        this.writeStructureList(obj, "resultSet");
        if ((String)obj.getLocalProperty(this.getModule(), "queryText") != null) {
            this.property(obj, "queryText");
        }
        this.property(obj, "resultSetName");
        this.writeOdaDesignerState(obj, "designerState");
        this.propertyCDATA(obj, "designerValues");
        List properties = (List)obj.getLocalProperty(this.getModule(), "privateDriverProperties");
        this.writeExtendedProperties(properties, "privateDriverProperties");
        this.writeOdaExtensionProperties(obj, "extensionID");
        this.writer.endElement();
    }

    private void writeColumns(DesignElement obj, int slot) {
        if (!($assertionsDisabled || obj instanceof GridItem || obj instanceof TableItem)) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && slot != 0 && slot != 4) {
            throw new AssertionError();
        }
        boolean revert = true;
        if (revert) {
            this.writeContents(obj, slot, null);
            return;
        }
        List list = obj.getSlot(slot).getContents();
        if (list.isEmpty()) {
            return;
        }
        boolean needWrite = false;
        Iterator iter = list.iterator();
        while (iter.hasNext() && !needWrite) {
            DesignElement column = (DesignElement)iter.next();
            List propDefns = column.getPropertyDefns();
            Iterator iterDefn = propDefns.iterator();
            while (iterDefn.hasNext() && !needWrite) {
                PropertyDefn propDefn = (PropertyDefn)iterDefn.next();
                if (column.getLocalProperty(this.getModule(), propDefn.getName()) == null) continue;
                needWrite = true;
            }
        }
        if (needWrite) {
            iter = list.iterator();
            while (iter.hasNext()) {
                ((DesignElement)iter.next()).apply(this);
            }
        }
    }

    protected void writeOverridenPropertyValues(DesignElement obj) {
        if (obj.getExtendsElement() == null) {
            return;
        }
        this.writer.conditionalStartElement("overridden-values");
        ContentIterator iter = new ContentIterator(obj);
        while (iter.hasNext()) {
            DesignElement virtualElement = (DesignElement)iter.next();
            if (!virtualElement.hasLocalPropertyValues() && virtualElement.getStyle() == null && StringUtil.isBlank(virtualElement.getName())) continue;
            this.writer.conditionalStartElement("ref-entry");
            long baseId = virtualElement.getBaseId();
            this.writer.attribute("baseId", new Long(baseId).toString());
            this.writer.attribute("name", virtualElement.getName());
            if (!$assertionsDisabled && virtualElement.getExtendsElement() != null) {
                throw new AssertionError();
            }
            List propDefns = null;
            propDefns = virtualElement instanceof ExtendedItem ? ((ExtendedItem)virtualElement).getExtDefn().getProperties() : virtualElement.getPropertyDefns();
            for (int i = 0; i < propDefns.size(); ++i) {
                PropertyDefn propDefn = (PropertyDefn)propDefns.get(i);
                if ("name".equalsIgnoreCase(propDefn.getName()) || virtualElement instanceof ExtendedItem && "extensionName".equalsIgnoreCase(propDefn.getName())) continue;
                boolean cdata = false;
                if (propDefn.getTypeCode() == 18 || propDefn.getTypeCode() == 12) {
                    cdata = true;
                }
                if (propDefn.getTypeCode() == 16) {
                    if (propDefn.isList()) {
                        this.writeStructureList(virtualElement, propDefn.getName());
                        continue;
                    }
                    this.writeStructure(virtualElement, propDefn.getName());
                    continue;
                }
                if (propDefn.getTypeCode() == 20) {
                    this.writeSimplePropertyList(virtualElement, propDefn.getName());
                    continue;
                }
                this.writeProperty(virtualElement, this.getTagByPropertyType(propDefn), propDefn.getName(), cdata);
            }
            this.writer.endElement();
        }
        this.writer.endElement();
    }

    public void visitJointDataSet(JointDataSet obj) {
        this.writer.startElement("joint-data-set");
        super.visitJointDataSet(obj);
        this.writeStructureList(obj, "parameters");
        this.writeStructureList(obj, "resultSet");
        this.writeSimplePropertyList(obj, "dataSets");
        this.writeStructureList(obj, "joinConditions");
        this.writer.endElement();
    }

    private void writeOdaDesignerState(DesignElement obj, String propName) {
        block6: {
            OdaDesignerState designerState = (OdaDesignerState)obj.getLocalProperty(this.getModule(), propName);
            if (designerState == null) {
                return;
            }
            this.writer.startElement("structure");
            this.writer.attribute("name", "designerState");
            this.property(designerState, "version");
            this.property(designerState, "stateContentAsString");
            try {
                if (designerState.getContentAsBlob() != null) {
                    byte[] data = base.encode(designerState.getContentAsBlob());
                    String value = new String(data, "8859_1");
                    if (value.length() < 80) {
                        this.writeEntry("property", "stateContentAsBlob", value, false);
                    } else {
                        this.writeLongIndentText("property", "stateContentAsBlob", value);
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                if ($assertionsDisabled) break block6;
                throw new AssertionError();
            }
        }
        this.writer.endElement();
    }

    static {
        $assertionsDisabled = !ModuleWriter.class.desiredAssertionStatus();
        base = new Base64();
    }
}

