/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import com.ibm.icu.util.Calendar;
import java.util.Vector;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DateTimeDataElement;
import org.eclipse.birt.chart.model.data.impl.DateTimeDataElementImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IDataElementComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;

public class DateTimeDataElementComposite
extends Composite
implements IDataElementComposite,
Listener {
    private Button btnCheck;
    private DateTime pickerDate;
    private DateTime pickerTime;
    private Vector<Listener> vListeners = null;
    private final boolean isNullAllowed;

    public DateTimeDataElementComposite(Composite parent, int style, DateTimeDataElement data, boolean isNullAllowed) {
        super(parent, 0);
        this.isNullAllowed = isNullAllowed;
        GridLayout layout = new GridLayout(isNullAllowed ? 3 : 2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(768));
        if (isNullAllowed) {
            this.btnCheck = new Button((Composite)this, 32);
            this.btnCheck.addListener(13, (Listener)this);
        }
        this.pickerDate = new DateTime((Composite)this, 0x20 | style);
        this.pickerTime = new DateTime((Composite)this, 0x80 | style);
        this.pickerDate.addListener(13, (Listener)this);
        this.pickerTime.addListener(13, (Listener)this);
        this.pickerDate.setLayoutData((Object)new GridData(768));
        this.pickerTime.setLayoutData((Object)new GridData(768));
        this.vListeners = new Vector();
        this.setDataElement((DataElement)data);
    }

    public void setEnabled(boolean enabled) {
        if (this.isNullAllowed) {
            this.btnCheck.setEnabled(enabled);
            this.pickerDate.setEnabled(enabled && this.btnCheck.getSelection());
            this.pickerTime.setEnabled(enabled && this.btnCheck.getSelection());
        } else {
            this.pickerDate.setEnabled(enabled);
            this.pickerTime.setEnabled(enabled);
        }
    }

    public DataElement getDataElement() {
        if (this.isNullAllowed && !this.btnCheck.getSelection()) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(this.pickerDate.getYear(), this.pickerDate.getMonth(), this.pickerDate.getDay(), this.pickerTime.getHours(), this.pickerTime.getMinutes(), this.pickerTime.getSeconds());
        calendar.set(14, 0);
        return DateTimeDataElementImpl.create((Calendar)calendar);
    }

    public void handleEvent(Event event) {
        if (event.widget == this.btnCheck) {
            this.pickerDate.setEnabled(this.btnCheck.getSelection());
            this.pickerTime.setEnabled(this.btnCheck.getSelection());
        }
        event.widget = this;
        int i = 0;
        while (i < this.vListeners.size()) {
            Event e = new Event();
            e.data = this.getDataElement();
            e.widget = this;
            e.type = 0;
            this.vListeners.get(i).handleEvent(e);
            ++i;
        }
    }

    public void addListener(Listener listener) {
        this.vListeners.add(listener);
    }

    public void setDataElement(DataElement data) {
        if (data != null && !(data instanceof DateTimeDataElement)) {
            return;
        }
        if (this.isNullAllowed) {
            this.btnCheck.setSelection(data != null);
        }
        Calendar calendar = null;
        if (data == null) {
            calendar = Calendar.getInstance();
            calendar.set(10, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
        } else {
            calendar = ((DateTimeDataElement)data).getValueAsCalendar();
        }
        this.pickerDate.setYear(calendar.get(1));
        this.pickerDate.setMonth(calendar.get(2));
        this.pickerDate.setDay(calendar.get(5));
        this.pickerTime.setHours(calendar.get(11));
        this.pickerTime.setMinutes(calendar.get(12));
        this.pickerTime.setSeconds(calendar.get(13));
        this.setEnabled(data != null);
    }
}

