/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.composites;

import java.util.Collection;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.TriggerDataComposite;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class TriggerEditorDialog
extends TrayDialog {
    private final EList triggers;
    private final EObject cursorContainer;
    private final Collection vOriginalTriggers;
    private final ChartWizardContext wizardContext;
    private final boolean bEnableURLParameters;
    private final boolean bEnableShowTooltipValue;
    private final int iInteractivityType;
    private final String sTitle;
    private TriggerDataComposite triggerUI;

    public TriggerEditorDialog(Shell shellParent, EList triggers, EObject cursorContainer, ChartWizardContext wizardContext, String sTitle, int iInteractivityType, boolean bEnableURLParameters, boolean bEnableShowTooltipValue) {
        super(shellParent);
        this.triggers = triggers;
        this.cursorContainer = cursorContainer;
        this.wizardContext = wizardContext;
        this.bEnableURLParameters = bEnableURLParameters;
        this.bEnableShowTooltipValue = bEnableShowTooltipValue;
        this.sTitle = sTitle;
        this.iInteractivityType = iInteractivityType;
        this.vOriginalTriggers = EcoreUtil.copyAll((Collection)triggers);
    }

    protected Control createContents(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.Interactivity_ID");
        this.getShell().setText(Messages.getFormattedString("TriggerEditorDialog.Title.TriggerEditor", this.sTitle));
        return super.createContents(parent);
    }

    protected void setShellStyle(int newShellStyle) {
        super.setShellStyle(newShellStyle | 0x860 | 0x10 | 0x10000);
    }

    protected Control createDialogArea(Composite parent) {
        this.triggerUI = new TriggerDataComposite(parent, 0, this.triggers, this.cursorContainer, this.wizardContext, this.iInteractivityType, this.bEnableURLParameters, this.bEnableShowTooltipValue);
        GridData gdTriggerEditor = new GridData(1808);
        this.triggerUI.setLayoutData(gdTriggerEditor);
        return this.triggerUI;
    }

    public EList getTriggers() {
        return this.triggers;
    }

    protected void okPressed() {
        this.triggerUI.markSaveWhenClosing();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.triggers.clear();
        this.triggers.addAll(this.vOriginalTriggers);
        super.cancelPressed();
    }
}

