/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.type;

import java.util.Collection;
import java.util.Vector;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.BaseSampleData;
import org.eclipse.birt.chart.model.data.DataFactory;
import org.eclipse.birt.chart.model.data.OrthogonalSampleData;
import org.eclipse.birt.chart.model.data.SampleData;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.type.GanttSeries;
import org.eclipse.birt.chart.model.type.impl.GanttSeriesImpl;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DefaultChartSubTypeImpl;
import org.eclipse.birt.chart.ui.swt.DefaultChartTypeImpl;
import org.eclipse.birt.chart.ui.swt.HelpContentImpl;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartSubType;
import org.eclipse.birt.chart.ui.swt.interfaces.IHelpContent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.type.BarChart;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.swt.wizard.data.DefaultBaseSeriesComponent;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.graphics.Image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GanttChart
extends DefaultChartTypeImpl {
    public static final String TYPE_LITERAL = "Gantt Chart";
    protected static final String STANDARD_SUBTYPE_LITERAL = "Standard Gantt Chart";
    private static final String CHART_TITLE = Messages.getString("GanttChart.Txt.DefaultGanttChartTitle");
    private static final String sStandardDescription = Messages.getString("GanttChart.Txt.Description");
    private transient Image imgIcon = UIHelper.getImage((String)"icons/obj16/ganttcharticon.gif");
    private transient Image img2D = null;

    public String getName() {
        return TYPE_LITERAL;
    }

    public Image getImage() {
        return this.imgIcon;
    }

    public IHelpContent getHelp() {
        return new HelpContentImpl(TYPE_LITERAL, Messages.getString("GanttChart.Txt.HelpText"));
    }

    public Collection<IChartSubType> getChartSubtypes(String sDimension, Orientation orientation) {
        Vector<IChartSubType> vSubTypes = new Vector<IChartSubType>();
        if (sDimension.equals(TWO_DIMENSION_TYPE) || sDimension.equals(ChartDimension.TWO_DIMENSIONAL_LITERAL.getName())) {
            this.img2D = orientation.equals((Object)Orientation.VERTICAL_LITERAL) ? UIHelper.getImage((String)"icons/wizban/ganttchartimage.gif") : UIHelper.getImage((String)"icons/wizban/horizontalganttchartimage.gif");
            vSubTypes.add((IChartSubType)new DefaultChartSubTypeImpl(STANDARD_SUBTYPE_LITERAL, this.img2D, sStandardDescription, Messages.getString("GanttChart.SubType.Standard")));
        }
        return vSubTypes;
    }

    public Chart getModel(String sSubType, Orientation orientation, String sDimension, Chart currentChart) {
        ChartWithAxes newChart = null;
        if (currentChart != null && (newChart = (ChartWithAxes)this.getConvertedChart(currentChart, sSubType, orientation, sDimension)) != null) {
            return newChart;
        }
        newChart = ChartWithAxesImpl.create();
        newChart.setType(TYPE_LITERAL);
        newChart.setSubType(sSubType);
        newChart.setDimension(this.getDimensionFor(sDimension));
        newChart.setUnits("Points");
        newChart.setOrientation(orientation);
        ((Axis)newChart.getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setType(AxisType.LINEAR_LITERAL);
        ((Axis)newChart.getAxes().get(0)).setCategoryAxis(false);
        ((Axis)newChart.getAxes().get(0)).getScale().setStep(10.0);
        ((Axis)newChart.getAxes().get(0)).getLabel().setVisible(false);
        newChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        Series categorySeries = SeriesImpl.create();
        sdX.getSeries().add((Object)categorySeries);
        ((Axis)newChart.getAxes().get(0)).getSeriesDefinitions().add((Object)sdX);
        ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
        ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.DATE_TIME_LITERAL);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        sdY.getSeriesPalette().shift(0);
        Series valueSeries = GanttSeriesImpl.create();
        valueSeries.setLabelPosition(Position.ABOVE_LITERAL);
        sdY.getSeries().add((Object)valueSeries);
        ((Axis)((Axis)newChart.getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().add((Object)sdY);
        this.addSampleData((Chart)newChart);
        return newChart;
    }

    private void addSampleData(Chart newChart) {
        SampleData sd = DataFactory.eINSTANCE.createSampleData();
        sd.getBaseSampleData().clear();
        sd.getOrthogonalSampleData().clear();
        BaseSampleData sdBase = DataFactory.eINSTANCE.createBaseSampleData();
        sdBase.setDataSetRepresentation("5,15,25");
        sd.getBaseSampleData().add((Object)sdBase);
        OrthogonalSampleData oSample = DataFactory.eINSTANCE.createOrthogonalSampleData();
        oSample.setDataSetRepresentation("S01/01/2005 E02/01/2005 Label1,S01/15/2005 E02/15/2005 Label2,S02/01/2005 E03/01/2005 Label3");
        oSample.setSeriesDefinitionIndex(0);
        sd.getOrthogonalSampleData().add((Object)oSample);
        newChart.setSampleData(sd);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Chart getConvertedChart(Chart currentChart, String sNewSubType, Orientation newOrientation, String sNewDimension) {
        Chart helperModel = currentChart.copyInstance();
        ChartCacheManager.getInstance().cacheSeries(ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)helperModel));
        if (currentChart instanceof ChartWithAxes) {
            if (currentChart.getType().equals(TYPE_LITERAL)) {
                if (!currentChart.getSubType().equals(sNewSubType)) {
                    currentChart.setSubType(sNewSubType);
                    EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
                    int i = 0;
                    while (i < axes.size()) {
                        ((Axis)axes.get(i)).setPercent(false);
                        EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                        int j = 0;
                        while (j < seriesdefinitions.size()) {
                            Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                            series.setStacked(false);
                            ++j;
                        }
                        ++i;
                    }
                }
                if (!(currentChart instanceof ChartWithAxes) || ((ChartWithAxes)currentChart).getOrientation().equals((Object)newOrientation)) return currentChart;
                ((ChartWithAxes)currentChart).setOrientation(newOrientation);
                return currentChart;
            }
            if (!currentChart.getType().equals("Line Chart") && !currentChart.getType().equals("Area Chart") && !currentChart.getType().equals(BarChart.TYPE_LITERAL) && !currentChart.getType().equals("Tube Chart") && !currentChart.getType().equals("Cone Chart") && !currentChart.getType().equals("Pyramid Chart") && !currentChart.getType().equals("Scatter Chart") && !currentChart.getType().equals("Stock Chart") && !currentChart.getType().equals("Bubble Chart") && !currentChart.getType().equals("Difference Chart")) return null;
            currentChart.setType(TYPE_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setCategoryAxis(true);
            currentChart.setSubType(sNewSubType);
            currentChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
            EList axes = ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes();
            int i = 0;
            int seriesIndex = 0;
            while (i < axes.size()) {
                ((Axis)axes.get(i)).setPercent(false);
                ((Axis)axes.get(i)).setType(AxisType.DATE_TIME_LITERAL);
                EList seriesdefinitions = ((Axis)axes.get(i)).getSeriesDefinitions();
                int j = 0;
                while (j < seriesdefinitions.size()) {
                    Series series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                    series = this.getConvertedSeries(series, seriesIndex++);
                    series.setStacked(false);
                    ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                    ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                    ++j;
                }
                ++i;
            }
            currentChart.setSampleData(this.getConvertedSampleData(currentChart.getSampleData(), ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getType()));
        } else {
            currentChart = ChartWithAxesImpl.create();
            currentChart.setType(TYPE_LITERAL);
            currentChart.setSubType(sNewSubType);
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
            currentChart.setDimension(this.getDimensionFor(sNewDimension));
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setOrientation(Orientation.HORIZONTAL_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setType(AxisType.TEXT_LITERAL);
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).setCategoryAxis(true);
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).setOrientation(Orientation.VERTICAL_LITERAL);
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).setType(AxisType.DATE_TIME_LITERAL);
            currentChart.setBlock(helperModel.getBlock());
            currentChart.setDescription(helperModel.getDescription());
            currentChart.setGridColumnCount(helperModel.getGridColumnCount());
            currentChart.setSampleData(this.getConvertedSampleData(helperModel.getSampleData(), ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getType()));
            currentChart.setScript(helperModel.getScript());
            currentChart.setSeriesThickness(helperModel.getSeriesThickness());
            currentChart.setUnits(helperModel.getUnits());
            if (!helperModel.getType().equals("Pie Chart") && !helperModel.getType().equals("Meter Chart")) return null;
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().clear();
            ((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().add((Object)((SeriesDefinition)((ChartWithoutAxes)helperModel).getSeriesDefinitions().get(0)));
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().clear();
            ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions().addAll((Collection)((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeriesDefinitions());
            Series series = ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getDesignTimeSeries();
            ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().clear();
            ((SeriesDefinition)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getSeriesDefinitions().get(0)).getSeries().add((Object)series);
            EList seriesdefinitions = ((Axis)((Axis)((ChartWithAxes)currentChart).getAxes().get(0)).getAssociatedAxes().get(0)).getSeriesDefinitions();
            int j = 0;
            while (j < seriesdefinitions.size()) {
                series = ((SeriesDefinition)seriesdefinitions.get(j)).getDesignTimeSeries();
                series = this.getConvertedSeries(series, j);
                series.getLabel().setVisible(false);
                series.setStacked(false);
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().clear();
                ((SeriesDefinition)seriesdefinitions.get(j)).getSeries().add((Object)series);
                ++j;
            }
            currentChart.getLegend().setItemType(LegendItemType.SERIES_LITERAL);
            currentChart.getTitle().getLabel().getCaption().setValue(CHART_TITLE);
        }
        if (currentChart instanceof ChartWithAxes && !((ChartWithAxes)currentChart).getOrientation().equals((Object)newOrientation)) {
            ((ChartWithAxes)currentChart).setOrientation(newOrientation);
        }
        if (currentChart.getDimension().equals((Object)this.getDimensionFor(sNewDimension))) return currentChart;
        currentChart.setDimension(this.getDimensionFor(sNewDimension));
        return currentChart;
    }

    private Series getConvertedSeries(Series series, int seriesIndex) {
        if (series.getClass().getName().equals("org.eclipse.birt.chart.model.component.impl.SeriesImpl")) {
            return series;
        }
        GanttSeries ganttseries = (GanttSeries)ChartCacheManager.getInstance().findSeries(GanttSeriesImpl.class.getName(), seriesIndex);
        if (ganttseries == null) {
            ganttseries = (GanttSeries)GanttSeriesImpl.create();
        }
        ChartUIUtil.copyGeneralSeriesAttributes((Series)series, (Series)ganttseries);
        return ganttseries;
    }

    private SampleData getConvertedSampleData(SampleData currentSampleData, AxisType axisType) {
        EList bsdList = currentSampleData.getBaseSampleData();
        Vector<BaseSampleData> vNewBaseSampleData = new Vector<BaseSampleData>();
        int i = 0;
        while (i < bsdList.size()) {
            BaseSampleData bsd = (BaseSampleData)bsdList.get(i);
            bsd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)axisType, (String)bsd.getDataSetRepresentation(), (int)i));
            vNewBaseSampleData.add(bsd);
            ++i;
        }
        currentSampleData.getBaseSampleData().clear();
        currentSampleData.getBaseSampleData().addAll(vNewBaseSampleData);
        EList osdList = currentSampleData.getOrthogonalSampleData();
        Vector<OrthogonalSampleData> vNewOrthogonalSampleData = new Vector<OrthogonalSampleData>();
        int i2 = 0;
        while (i2 < osdList.size()) {
            OrthogonalSampleData osd = (OrthogonalSampleData)osdList.get(i2);
            osd.setDataSetRepresentation(ChartUIUtil.getConvertedSampleDataRepresentation((AxisType)AxisType.DATE_TIME_LITERAL, (String)osd.getDataSetRepresentation(), (int)i2));
            vNewOrthogonalSampleData.add(osd);
            ++i2;
        }
        currentSampleData.getOrthogonalSampleData().clear();
        currentSampleData.getOrthogonalSampleData().addAll(vNewOrthogonalSampleData);
        return currentSampleData;
    }

    public String[] getSupportedDimensions() {
        return new String[]{TWO_DIMENSION_TYPE};
    }

    public String getDefaultDimension() {
        return TWO_DIMENSION_TYPE;
    }

    public boolean supportsTransposition() {
        return false;
    }

    private ChartDimension getDimensionFor(String sDimension) {
        return ChartDimension.TWO_DIMENSIONAL_LITERAL;
    }

    public Orientation getDefaultOrientation() {
        return Orientation.HORIZONTAL_LITERAL;
    }

    public ISelectDataComponent getBaseUI(Chart chart, ISelectDataCustomizeUI selectDataUI, ChartWizardContext context, String sTitle) {
        return new DefaultBaseSeriesComponent((SeriesDefinition)ChartUIUtil.getBaseSeriesDefinitions((Chart)chart).get(0), context, sTitle);
    }

    public String getDisplayName() {
        return Messages.getString("GanttChart.Txt.DisplayName");
    }

    public Series getSeries() {
        return GanttSeriesImpl.create();
    }
}

