/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.data;

import java.util.ArrayList;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.DefaultSelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataComponent;
import org.eclipse.birt.chart.ui.swt.interfaces.ISelectDataCustomizeUI;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizardContext;
import org.eclipse.birt.chart.ui.util.UIHelper;
import org.eclipse.emf.common.util.EList;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class MultipleSeriesComponent
extends DefaultSelectDataComponent {
    private EList[] seriesDefnsArray;
    private ChartWizardContext context = null;
    private String sTitle = null;
    private static final String LABEL_GROUPING_YSERIES = Messages.getString("MultipleSeriesComponent.Label.OptionalYSeriesGrouping");
    private static final String LABEL_GROUPING_OVERLAY = Messages.getString("MultipleSeriesComponent.Label.OptionalOverlayGrouping");
    private static final String LABEL_GROUPING_WITHOUTAXIS = Messages.getString("MultipleSeriesComponent.Label.OptionalGrouping");
    private ISelectDataCustomizeUI selectDataUI = null;
    private ArrayList components = new ArrayList();
    private boolean isSingle = false;
    private boolean useFirstOnly = true;

    public MultipleSeriesComponent(EList[] seriesDefnsArray, ChartWizardContext context, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        this.seriesDefnsArray = seriesDefnsArray;
        this.context = context;
        this.sTitle = sTitle;
        this.selectDataUI = selectDataUI;
    }

    public MultipleSeriesComponent(EList seriesDefns, ChartWizardContext context, String sTitle, ISelectDataCustomizeUI selectDataUI) {
        this(new EList[]{seriesDefns}, context, sTitle, selectDataUI);
        this.isSingle = true;
    }

    public Composite createArea(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        cmp.setLayout((Layout)gridLayout);
        cmp.setLayoutData((Object)new GridData(768));
        Label topAngle = new Label(cmp, 0);
        topAngle.setImage(UIHelper.getImage((String)"icons/obj16/ra_topleft.gif"));
        int i = 0;
        while (i < this.seriesDefnsArray.length) {
            this.createRightGroupArea(cmp, i, this.seriesDefnsArray[i]);
            if (this.useFirstOnly) break;
            ++i;
        }
        Label bottomAngle = new Label(cmp, 0);
        bottomAngle.setImage(UIHelper.getImage((String)"icons/obj16/ra_bottomleft.gif"));
        return cmp;
    }

    private void createRightGroupArea(Composite parent, final int axisIndex, final EList seriesDefn) {
        final String strDesc = this.getGroupingDescription(axisIndex);
        DefaultSelectDataComponent subUIGroupY = new DefaultSelectDataComponent(){

            public Composite createArea(Composite parent) {
                Composite cmpGroup = new Composite(parent, 0);
                GridLayout glContent = new GridLayout();
                glContent.marginHeight = 0;
                glContent.marginWidth = 0;
                glContent.horizontalSpacing = 2;
                cmpGroup.setLayout((Layout)glContent);
                cmpGroup.setLayoutData((Object)new GridData(768));
                Label lblRightYGrouping = new Label(cmpGroup, 64);
                GridData gd = new GridData(768);
                lblRightYGrouping.setLayoutData((Object)gd);
                lblRightYGrouping.setText(strDesc);
                int selectedSeriesIndex = 0;
                if (!MultipleSeriesComponent.this.useFirstOnly) {
                    selectedSeriesIndex = MultipleSeriesComponent.this.selectDataUI.getSeriesIndex()[axisIndex];
                }
                SeriesDefinition sd = (SeriesDefinition)seriesDefn.get(selectedSeriesIndex);
                if (seriesDefn != null && !seriesDefn.isEmpty()) {
                    ISelectDataComponent subUI = MultipleSeriesComponent.this.selectDataUI.getAreaComponent(2, sd, MultipleSeriesComponent.this.context, MultipleSeriesComponent.this.sTitle);
                    subUI.createArea(cmpGroup);
                    MultipleSeriesComponent.this.components.add(subUI);
                }
                return cmpGroup;
            }
        };
        subUIGroupY.createArea(parent);
        this.components.add(subUIGroupY);
    }

    public void selectArea(boolean selected, Object data) {
        int i = 0;
        while (i < this.components.size()) {
            ((ISelectDataComponent)this.components.get(i)).selectArea(selected, data);
            ++i;
        }
    }

    public void dispose() {
        int i = 0;
        while (i < this.components.size()) {
            ((ISelectDataComponent)this.components.get(i)).dispose();
            ++i;
        }
        super.dispose();
    }

    private String getGroupingDescription(int axisIndex) {
        if (this.isSingle) {
            return LABEL_GROUPING_WITHOUTAXIS;
        }
        if (axisIndex == 0) {
            return LABEL_GROUPING_YSERIES;
        }
        return LABEL_GROUPING_OVERLAY;
    }
}

