/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.ui.swt.wizard.format.series;

import java.util.Collection;
import java.util.Hashtable;
import java.util.List;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.Orientation;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.StockSeries;
import org.eclipse.birt.chart.ui.extension.i18n.Messages;
import org.eclipse.birt.chart.ui.swt.composites.ExternalizedTextEditorComposite;
import org.eclipse.birt.chart.ui.swt.interfaces.IChartType;
import org.eclipse.birt.chart.ui.swt.interfaces.ITaskPopupSheet;
import org.eclipse.birt.chart.ui.swt.type.BubbleChart;
import org.eclipse.birt.chart.ui.swt.type.PieChart;
import org.eclipse.birt.chart.ui.swt.wizard.ChartAdapter;
import org.eclipse.birt.chart.ui.swt.wizard.ChartUIExtensionsImpl;
import org.eclipse.birt.chart.ui.swt.wizard.ChartWizard;
import org.eclipse.birt.chart.ui.swt.wizard.format.SubtaskSheetImpl;
import org.eclipse.birt.chart.ui.swt.wizard.format.popup.series.SeriesPaletteSheet;
import org.eclipse.birt.chart.ui.util.ChartCacheManager;
import org.eclipse.birt.chart.ui.util.ChartUIUtil;
import org.eclipse.birt.chart.util.LiteralHelper;
import org.eclipse.birt.chart.util.NameSet;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.TreeItem;

public class SeriesSheetImpl
extends SubtaskSheetImpl
implements SelectionListener {
    private static Hashtable<String, Series> htSeriesNames = null;
    private Collection<IChartType> cTypes = null;
    private Combo cmbColorBy;
    private ITaskPopupSheet popup = null;
    private static final int COLUMN_DETAIL = 7;
    private static final int HORIZONTAL_SPACING = 5;
    private Composite cmpList = null;

    public void createControl(Composite parent) {
        ChartUIUtil.bindHelp((Control)parent, (String)"org.eclipse.birt.chart.cshelp.FormatChartSeries_ID");
        this.cTypes = ChartUIExtensionsImpl.instance().getUIChartTypeExtensions(this.getContext().getClass().getSimpleName());
        this.cmpContent = new Composite(parent, 0);
        GridLayout glContent = new GridLayout(4, false);
        glContent.horizontalSpacing = 5;
        this.cmpContent.setLayout((Layout)glContent);
        GridData gd = new GridData(1808);
        this.cmpContent.setLayoutData((Object)gd);
        new Label(this.cmpContent, 0).setText(Messages.getString("ChartSheetImpl.Label.ColorBy"));
        this.cmbColorBy = new Combo(this.cmpContent, 12);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 3;
        this.cmbColorBy.setLayoutData((Object)gridData);
        NameSet ns = LiteralHelper.legendItemTypeSet;
        this.cmbColorBy.setItems(ns.getDisplayNames());
        this.cmbColorBy.select(ns.getSafeNameIndex(this.getChart().getLegend().getItemType().getName()));
        this.cmbColorBy.addSelectionListener((SelectionListener)this);
        ScrolledComposite cmpScroll = new ScrolledComposite(this.cmpContent, 768);
        gd = new GridData(1808);
        gd.horizontalSpan = 4;
        cmpScroll.setLayoutData((Object)gd);
        cmpScroll.setExpandVertical(true);
        cmpScroll.setExpandHorizontal(true);
        this.createSeriesOptions(cmpScroll);
        this.createButtonGroup(this.cmpContent);
    }

    private void createSeriesOptions(ScrolledComposite cmpScroll) {
        if (this.cmpList == null || this.cmpList.isDisposed()) {
            this.cmpList = new Composite((Composite)cmpScroll, 0);
            GridLayout glContent = new GridLayout(7, false);
            glContent.horizontalSpacing = 5;
            this.cmpList.setLayout((Layout)glContent);
            this.cmpList.setLayoutData((Object)new GridData(1808));
            cmpScroll.setContent((Control)this.cmpList);
        } else {
            Control[] children = this.cmpList.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        Label lblSeries = new Label(this.cmpList, 64);
        GridData gd = new GridData();
        gd.horizontalAlignment = 0x1000000;
        lblSeries.setLayoutData((Object)gd);
        lblSeries.setFont(JFaceResources.getBannerFont());
        lblSeries.setText(Messages.getString("SeriesSheetImpl.Label.Series"));
        Label lblTitle = new Label(this.cmpList, 64);
        GridData gd2 = new GridData();
        gd2.horizontalAlignment = 0x1000000;
        lblTitle.setLayoutData((Object)gd2);
        lblTitle.setFont(JFaceResources.getBannerFont());
        lblTitle.setText(Messages.getString("SeriesSheetImpl.Label.Title"));
        Label lblType = new Label(this.cmpList, 64);
        GridData gd3 = new GridData();
        gd3.horizontalAlignment = 0x1000000;
        lblType.setLayoutData((Object)gd3);
        lblType.setFont(JFaceResources.getBannerFont());
        lblType.setText(Messages.getString("SeriesSheetImpl.Label.Type"));
        Label lblZOrder = new Label(this.cmpList, 64);
        GridData gd4 = new GridData();
        gd4.horizontalAlignment = 0x1000000;
        lblZOrder.setLayoutData((Object)gd4);
        lblZOrder.setFont(JFaceResources.getBannerFont());
        lblZOrder.setText(Messages.getString("SeriesSheetImpl.Label.ZOrder"));
        Label lblVisible = new Label(this.cmpList, 64);
        GridData gd5 = new GridData();
        gd5.horizontalAlignment = 0x1000000;
        lblVisible.setLayoutData((Object)gd5);
        lblVisible.setFont(JFaceResources.getBannerFont());
        lblVisible.setText(Messages.getString("SeriesSheetImpl.Label.Visible"));
        Label lblStack = new Label(this.cmpList, 64);
        GridData gd6 = new GridData();
        gd6.horizontalAlignment = 0x1000000;
        lblStack.setLayoutData((Object)gd6);
        lblStack.setFont(JFaceResources.getBannerFont());
        lblStack.setText(Messages.getString("SeriesSheetImpl.Label.Stacked"));
        Label lblTranslucent = new Label(this.cmpList, 64);
        GridData gd7 = new GridData();
        gd7.horizontalAlignment = 0x1000000;
        lblTranslucent.setLayoutData((Object)gd7);
        lblTranslucent.setFont(JFaceResources.getBannerFont());
        lblTranslucent.setText(Messages.getString("SeriesSheetImpl.Label.Translucent"));
        int treeIndex = 0;
        if (this.getContext().getChartType() instanceof PieChart) {
            EList seriesDefns = ChartUIUtil.getBaseSeriesDefinitions((Chart)this.getChart());
            int i = 0;
            while (i < seriesDefns.size()) {
                new SeriesOptionChoser((SeriesDefinition)seriesDefns.get(i), Messages.getString("SeriesSheetImpl.Label.CategoryBaseSeries"), i, treeIndex++, false).placeComponents(this.cmpList);
                ++i;
            }
        }
        List allSeriesDefns = ChartUIUtil.getAllOrthogonalSeriesDefinitions((Chart)this.getChart());
        String text = this.getChart() instanceof ChartWithAxes ? Messages.getString("SeriesSheetImpl.Label.ValueYSeries") : Messages.getString("SeriesSheetImpl.Label.ValueOrthogonalSeries");
        int seriesIndex = 0;
        int i = 0;
        while (i < ChartUIUtil.getOrthogonalAxisNumber((Chart)this.getChart())) {
            boolean canStack = true;
            EList seriesDefns = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)this.getChart(), (int)i);
            int j = 0;
            while (j < seriesDefns.size()) {
                if (!((SeriesDefinition)seriesDefns.get(j)).getDesignTimeSeries().canBeStacked()) {
                    canStack = false;
                    break;
                }
                ++j;
            }
            j = 0;
            while (j < seriesDefns.size()) {
                new SeriesOptionChoser((SeriesDefinition)seriesDefns.get(j), allSeriesDefns.size() == 1 ? text : String.valueOf(text) + " - " + (seriesIndex + 1), seriesIndex++, treeIndex++, canStack, i).placeComponents(this.cmpList);
                ++j;
            }
            ++i;
        }
    }

    private void createButtonGroup(Composite parent) {
        Composite cmp = new Composite(parent, 0);
        cmp.setLayout((Layout)new GridLayout(6, false));
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 0x1000008;
        cmp.setLayoutData((Object)gridData);
        this.popup = new SeriesPaletteSheet(Messages.getString("SeriesSheetImpl.Label.SeriesPalette"), this.getContext(), this.getCategorySeriesDefinition(), this.getValueSeriesDefinition(), this.isGroupedSeries(), 35);
        Button btnSeriesPals = this.createToggleButton(cmp, ".Palette", Messages.getString("SeriesSheetImpl.Label.SeriesPalette&"), this.popup);
        btnSeriesPals.addSelectionListener((SelectionListener)this);
    }

    private SeriesDefinition getCategorySeriesDefinition() {
        SeriesDefinition sd = null;
        if (this.getChart() instanceof ChartWithAxes) {
            sd = (SeriesDefinition)((Axis)((ChartWithAxes)this.getChart()).getAxes().get(0)).getSeriesDefinitions().get(this.getIndex());
        } else if (this.getChart() instanceof ChartWithoutAxes) {
            sd = (SeriesDefinition)((ChartWithoutAxes)this.getChart()).getSeriesDefinitions().get(this.getIndex());
        }
        return sd;
    }

    private SeriesDefinition[] getValueSeriesDefinition() {
        SeriesDefinition[] sds = null;
        if (this.getChart() instanceof ChartWithAxes) {
            sds = ((ChartWithAxes)this.getChart()).getSeriesForLegend();
        } else if (this.getChart() instanceof ChartWithoutAxes) {
            sds = (SeriesDefinition[])((SeriesDefinition)((ChartWithoutAxes)this.getChart()).getSeriesDefinitions().get(0)).getSeriesDefinitions().toArray((Object[])new SeriesDefinition[0]);
        }
        return sds;
    }

    public void widgetSelected(SelectionEvent e) {
        if (this.detachPopup(e.widget)) {
            return;
        }
        if (this.isRegistered(e.widget)) {
            this.attachPopup(((Button)e.widget).getData().toString());
        }
        if (e.widget.equals(this.cmbColorBy) && !this.getChart().getLegend().getItemType().getName().equals(LiteralHelper.legendItemTypeSet.getNameByDisplayName(this.cmbColorBy.getText()))) {
            this.getChart().getLegend().setItemType(LegendItemType.getByName((String)LiteralHelper.legendItemTypeSet.getNameByDisplayName(this.cmbColorBy.getText())));
            if (this.getChart().getLegend().getItemType().getValue() == 1 && this.isGroupedSeries()) {
                ChartAdapter.beginIgnoreNotifications();
                SeriesDefinition[] osds = this.getValueSeriesDefinition();
                SeriesDefinition bsd = this.getCategorySeriesDefinition();
                bsd.getSeriesPalette().shift(0);
                int i = 0;
                while (i < osds.length) {
                    bsd.getSeriesPalette().getEntries().set(i, (Object)((Fill)osds[i].getSeriesPalette().getEntries().get(0)).copyInstance());
                    ++i;
                }
                ((SeriesPaletteSheet)this.popup).setCategorySeries(bsd);
                ChartAdapter.endIgnoreNotifications();
            }
            ((SeriesPaletteSheet)this.popup).setGroupedPalette(this.isGroupedSeries());
            this.refreshPopupSheet();
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private boolean isGroupedSeries() {
        return !this.getValueSeriesDefinition()[0].getQuery().getDefinition().trim().equals("");
    }

    protected IChartType getCurrentChartType() {
        for (IChartType ct : this.cTypes) {
            if (!ct.getName().equals(this.getChart().getType())) continue;
            return ct;
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SeriesOptionChoser
    implements SelectionListener,
    Listener {
        private SeriesDefinition seriesDefn;
        private String seriesName;
        private Link linkSeries;
        private ExternalizedTextEditorComposite txtTitle;
        private Combo cmbTypes;
        private Spinner spnZOrder;
        private Button btnVisible;
        private Button btnStack;
        private Button btnTranslucent;
        private boolean canStack;
        private int iSeriesDefinitionIndex = 0;
        private int axisIndex = 0;
        private int treeIndex = 0;
        private boolean bStackedPercent;

        public SeriesOptionChoser(SeriesDefinition seriesDefn, String seriesName, int iSeriesDefinitionIndex, int treeIndex, boolean canStack) {
            this.seriesDefn = seriesDefn;
            this.seriesName = seriesName;
            this.iSeriesDefinitionIndex = iSeriesDefinitionIndex;
            this.treeIndex = treeIndex;
            this.canStack = canStack;
            this.bStackedPercent = this.isStackedPercent(seriesDefn);
        }

        public SeriesOptionChoser(SeriesDefinition seriesDefn, String seriesName, int iSeriesDefinitionIndex, int treeIndex, boolean canStack, int axisIndex) {
            this.seriesDefn = seriesDefn;
            this.seriesName = seriesName;
            this.iSeriesDefinitionIndex = iSeriesDefinitionIndex;
            this.treeIndex = treeIndex;
            this.canStack = canStack;
            this.axisIndex = axisIndex;
            this.bStackedPercent = this.isStackedPercent(seriesDefn);
        }

        private boolean isStackedPercent(SeriesDefinition seriesDefn) {
            if (seriesDefn.eContainer() instanceof Axis) {
                return ((Axis)seriesDefn.eContainer()).isPercent();
            }
            return false;
        }

        public void placeComponents(Composite parent) {
            Series series = this.seriesDefn.getDesignTimeSeries();
            this.linkSeries = new Link(parent, 0);
            GridData gd = new GridData(768);
            this.linkSeries.setLayoutData((Object)gd);
            this.linkSeries.setText("<a>" + this.seriesName + "</a>");
            this.linkSeries.addSelectionListener((SelectionListener)this);
            List keys = null;
            if (SeriesSheetImpl.this.getContext().getUIServiceProvider() != null) {
                keys = SeriesSheetImpl.this.getContext().getUIServiceProvider().getRegisteredKeys();
            }
            this.txtTitle = new ExternalizedTextEditorComposite(parent, 2052, -1, -1, keys, SeriesSheetImpl.this.getContext().getUIServiceProvider(), series.getSeriesIdentifier().toString());
            GridData gd2 = new GridData(768);
            this.txtTitle.setLayoutData(gd2);
            this.txtTitle.addListener(this);
            this.cmbTypes = new Combo(parent, 12);
            gd2 = new GridData(768);
            this.cmbTypes.setLayoutData((Object)gd2);
            this.cmbTypes.addSelectionListener((SelectionListener)this);
            if (this.iSeriesDefinitionIndex == 0) {
                this.cmbTypes.setEnabled(false);
            }
            if (!series.getClass().isAssignableFrom(SeriesImpl.class)) {
                this.spnZOrder = new Spinner(parent, 2048);
                gd2 = new GridData();
                gd2.horizontalAlignment = 0x1000000;
                this.spnZOrder.setLayoutData((Object)gd2);
                this.spnZOrder.setMinimum(0);
                this.spnZOrder.setMaximum(10);
                if (SeriesSheetImpl.this.getChart() instanceof ChartWithAxes && !(SeriesSheetImpl.this.getContext().getChartType() instanceof BubbleChart)) {
                    this.spnZOrder.setSelection(this.seriesDefn.getZOrder());
                    this.spnZOrder.addSelectionListener((SelectionListener)this);
                } else {
                    this.spnZOrder.setEnabled(false);
                }
                this.btnVisible = new Button(parent, 32);
                gd2 = new GridData();
                gd2.horizontalAlignment = 0x1000000;
                this.btnVisible.setLayoutData((Object)gd2);
                this.btnVisible.setSelection(series.isVisible());
                this.btnVisible.addSelectionListener((SelectionListener)this);
                this.btnStack = new Button(parent, 32);
                gd2 = new GridData();
                gd2.horizontalAlignment = 0x1000000;
                this.btnStack.setLayoutData((Object)gd2);
                this.btnStack.setEnabled(this.canStack && series.canBeStacked() && SeriesSheetImpl.this.getChart().getDimension().getValue() != 2 && !this.bStackedPercent);
                if (series.isStacked() && !this.canStack) {
                    this.btnStack.setSelection(false);
                    series.setStacked(false);
                } else {
                    this.btnStack.setSelection(series.isStacked());
                }
                this.btnStack.addSelectionListener((SelectionListener)this);
                this.btnTranslucent = new Button(parent, 32);
                gd2 = new GridData();
                gd2.horizontalAlignment = 0x1000000;
                this.btnTranslucent.setLayoutData((Object)gd2);
                this.btnTranslucent.setSelection(series.isTranslucent());
                this.btnTranslucent.addSelectionListener((SelectionListener)this);
                this.setTypeComboState();
                this.setStackedBoxState();
            } else {
                Label dummy = new Label(parent, 32);
                GridData gd3 = new GridData();
                gd3.horizontalSpan = 4;
                dummy.setLayoutData((Object)gd3);
            }
            this.populateLists(this.seriesDefn.getDesignTimeSeries());
        }

        public void widgetSelected(SelectionEvent e) {
            Series series = this.seriesDefn.getDesignTimeSeries();
            if (e.getSource().equals(this.cmbTypes)) {
                if (SeriesSheetImpl.this.getCurrentChartType().canCombine()) {
                    String typeName = this.cmbTypes.getText();
                    this.convertSeriesType(series, typeName);
                }
            } else if (e.getSource().equals(this.btnVisible)) {
                series.setVisible(this.btnVisible.getSelection());
            } else if (e.getSource().equals(this.btnStack)) {
                series.setStacked(this.btnStack.getSelection());
                if (series instanceof BarSeries && series.isStacked()) {
                    series.setLabelPosition(Position.INSIDE_LITERAL);
                }
                this.setTypeComboState();
            } else if (e.getSource().equals(this.btnTranslucent)) {
                series.setTranslucent(this.btnTranslucent.getSelection());
            } else if (e.getSource().equals(this.linkSeries)) {
                this.switchTo(this.treeIndex);
            } else if (e.getSource().equals(this.spnZOrder)) {
                this.seriesDefn.setZOrder(this.spnZOrder.getSelection());
            }
        }

        private void convertSeriesType(Series series, String typeName) {
            Series newSeries = this.getNewSeries(typeName, series);
            ChartAdapter.beginIgnoreNotifications();
            SeriesDefinition[] seriesDefns = (SeriesDefinition[])ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)SeriesSheetImpl.this.getChart(), (int)this.axisIndex).toArray((Object[])new SeriesDefinition[0]);
            if (!newSeries.canBeStacked()) {
                int i = 0;
                while (i < seriesDefns.length) {
                    if (seriesDefns[i].getDesignTimeSeries().isStacked()) {
                        seriesDefns[i].getDesignTimeSeries().setStacked(false);
                    }
                    ++i;
                }
            }
            ChartAdapter.endIgnoreNotifications();
            newSeries.eAdapters().addAll((Collection)this.seriesDefn.eAdapters());
            this.seriesDefn.getSeries().set(0, (Object)newSeries);
            SeriesSheetImpl.this.createSeriesOptions((ScrolledComposite)SeriesSheetImpl.this.cmpList.getParent());
            SeriesSheetImpl.this.cmpList.layout();
        }

        private Series getNewSeries(String sSeriesName, Series oldSeries) {
            try {
                ChartCacheManager.getInstance().cacheSeries(this.iSeriesDefinitionIndex, oldSeries);
                Series series = ChartCacheManager.getInstance().findSeries(((Series)htSeriesNames.get(sSeriesName)).getDisplayName(), this.iSeriesDefinitionIndex);
                if (series == null) {
                    series = (Series)htSeriesNames.get(sSeriesName);
                    ChartAdapter.beginIgnoreNotifications();
                    ChartUIUtil.copyGeneralSeriesAttributes((Series)oldSeries, (Series)series);
                    ChartAdapter.endIgnoreNotifications();
                }
                ChartWizard.removeException((String)"SeriesSheetImpl.getNewSeries");
                return series;
            }
            catch (Exception e) {
                ChartWizard.showException((String)"SeriesSheetImpl.getNewSeries", (String)e.getLocalizedMessage());
                return null;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void handleEvent(Event event) {
            if (event.widget.equals((Object)this.txtTitle)) {
                this.seriesDefn.getDesignTimeSeries().setSeriesIdentifier((Object)this.txtTitle.getText());
            }
        }

        private void populateLists(Series series) {
            if (SeriesSheetImpl.this.getCurrentChartType().canCombine()) {
                this.populateSeriesTypes(SeriesSheetImpl.this.cTypes, series, ((ChartWithAxes)SeriesSheetImpl.this.getChart()).getOrientation());
                String sDisplayName = series.getDisplayName();
                this.cmbTypes.setText(sDisplayName);
            } else {
                String seriesName = series.getDisplayName();
                this.cmbTypes.add(seriesName);
                this.cmbTypes.select(0);
            }
        }

        private void populateSeriesTypes(Collection<IChartType> allChartType, Series series, Orientation orientation) {
            for (IChartType type : allChartType) {
                Series newSeries = type.getSeries();
                if (htSeriesNames == null) {
                    htSeriesNames = new Hashtable(20);
                }
                if (!type.canCombine() || newSeries instanceof StockSeries && orientation.getValue() != 1) continue;
                String sDisplayName = newSeries.getDisplayName();
                htSeriesNames.put(sDisplayName, newSeries);
                this.cmbTypes.add(sDisplayName);
            }
        }

        private void switchTo(int index) {
            TreeItem currentItem = SeriesSheetImpl.this.getParentTask().getNavigatorTree().getSelection()[0];
            TreeItem[] children = currentItem.getItems();
            if (index < children.length) {
                SeriesSheetImpl.this.getParentTask().switchToTreeItem(children[index]);
            }
        }

        public void setTypeComboState() {
            if (this.btnStack == null) {
                return;
            }
            ChartDimension cd = SeriesSheetImpl.this.getChart().getDimension();
            if (cd == ChartDimension.TWO_DIMENSIONAL_LITERAL || cd == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
                if (this.btnStack.getSelection()) {
                    this.cmbTypes.setEnabled(false);
                } else {
                    EList seriesDefns = SeriesSheetImpl.this.getContext().isMoreAxesSupported() || ChartUIUtil.getOrthogonalAxisNumber((Chart)SeriesSheetImpl.this.getChart()) > 2 ? ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)SeriesSheetImpl.this.getChart(), (int)0) : ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)SeriesSheetImpl.this.getChart(), (int)this.axisIndex);
                    Series s = ((SeriesDefinition)seriesDefns.get(0)).getDesignTimeSeries();
                    if (s != this.seriesDefn.getDesignTimeSeries()) {
                        this.cmbTypes.setEnabled(true);
                    } else {
                        this.cmbTypes.setEnabled(false);
                    }
                }
            }
        }

        private void setStackedBoxState() {
            if (this.btnStack == null) {
                return;
            }
            ChartDimension cd = SeriesSheetImpl.this.getChart().getDimension();
            if (cd == ChartDimension.TWO_DIMENSIONAL_LITERAL || cd == ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL) {
                EList seriesDefns = ChartUIUtil.getOrthogonalSeriesDefinitions((Chart)SeriesSheetImpl.this.getChart(), (int)this.axisIndex);
                Series s = ((SeriesDefinition)seriesDefns.get(0)).getDesignTimeSeries();
                if (s.getDisplayName().equals(this.seriesDefn.getDesignTimeSeries().getDisplayName())) {
                    if (this.canStack && this.seriesDefn.getDesignTimeSeries().canBeStacked() && !this.bStackedPercent) {
                        this.btnStack.setEnabled(true);
                    }
                } else {
                    this.btnStack.setEnabled(false);
                    this.cmbTypes.setEnabled(true);
                }
            }
        }
    }
}

