/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.chart.model.attribute.Cursor;
import org.eclipse.birt.chart.model.attribute.CursorType;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.emf.common.util.EList;

public class CSSHelper {
    public static final String CURSOR_STYLE_PREFIX = "cursor:";
    public static final Map<CursorType, String> CSS_CURSOR_MAP = new HashMap<CursorType, String>();

    static {
        CSS_CURSOR_MAP.put(CursorType.AUTO, "auto");
        CSS_CURSOR_MAP.put(CursorType.CROSSHAIR, "crosshair");
        CSS_CURSOR_MAP.put(CursorType.DEFAULT, "default");
        CSS_CURSOR_MAP.put(CursorType.POINTER, "pointer");
        CSS_CURSOR_MAP.put(CursorType.MOVE, "move");
        CSS_CURSOR_MAP.put(CursorType.TEXT, "text");
        CSS_CURSOR_MAP.put(CursorType.WAIT, "wait");
        CSS_CURSOR_MAP.put(CursorType.ERESIZE, "e-resize");
        CSS_CURSOR_MAP.put(CursorType.NE_RESIZE, "ne-resize");
        CSS_CURSOR_MAP.put(CursorType.NW_RESIZE, "nw-resize");
        CSS_CURSOR_MAP.put(CursorType.NRESIZE, "n-resize");
        CSS_CURSOR_MAP.put(CursorType.SE_RESIZE, "se-resize");
        CSS_CURSOR_MAP.put(CursorType.SW_RESIZE, "sw-resize");
        CSS_CURSOR_MAP.put(CursorType.SRESIZE, "s-resize");
        CSS_CURSOR_MAP.put(CursorType.WRESIZE, "w-resize");
    }

    public static String getCSSCursorValue(Cursor cursor) {
        if (cursor == null || cursor.getType() == null) {
            return null;
        }
        String value = "cursor: ";
        if (cursor.getType() != CursorType.CUSTOM) {
            value = String.valueOf(value) + CSS_CURSOR_MAP.get(cursor.getType()) + ";";
        } else {
            EList cursorImages = cursor.getImage();
            int i = 0;
            for (Image uri : cursorImages) {
                if (uri.getURL() == null || uri.getURL().trim().length() == 0) continue;
                String sUri = uri.getURL();
                if (sUri.startsWith("\"") && sUri.endsWith("\"")) {
                    sUri = sUri.substring(1, sUri.length() - 1);
                }
                if (sUri.trim().length() == 0) continue;
                if (i != 0) {
                    value = String.valueOf(value) + ",";
                }
                value = String.valueOf(value) + "url(" + sUri + ")";
                ++i;
            }
            value = cursorImages.size() > 0 ? String.valueOf(value) + ",auto;" : String.valueOf(value) + "auto;";
        }
        return value;
    }
}

