/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.computation.withaxes;

import java.util.ArrayList;
import org.eclipse.birt.chart.computation.withaxes.AllAxes;
import org.eclipse.birt.chart.computation.withaxes.AutoScale;
import org.eclipse.birt.chart.computation.withaxes.AxesAdjuster;
import org.eclipse.birt.chart.computation.withaxes.IAxisAdjuster;
import org.eclipse.birt.chart.computation.withaxes.OneAxis;
import org.eclipse.birt.chart.computation.withaxes.PlotWithAxes;
import org.eclipse.birt.chart.computation.withaxes.VerticalAxisAdjuster;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.component.Label;

public class VerticalAxesAdjuster
implements IAxisAdjuster {
    private OneAxis[] fVerticalAxes;
    private OneAxis fHorizontalAxis;
    private PlotWithAxes fPlotWithAxes;
    private Bounds fPlotBounds;

    public VerticalAxesAdjuster(OneAxis[] verticalAxes, OneAxis horizontalAxis, PlotWithAxes plotWithAxes, Bounds boPlot) {
        this.fVerticalAxes = verticalAxes;
        this.fHorizontalAxis = horizontalAxis;
        this.fPlotWithAxes = plotWithAxes;
        this.fPlotBounds = boPlot;
    }

    public void adjust() throws ChartException {
        double iYTitleLocation;
        OneAxis oa;
        AutoScale scX = this.fHorizontalAxis.getScale();
        boolean isBackward = scX.getDirection() == -1;
        ArrayList<VerticalAxisAdjuster> values = new ArrayList<VerticalAxisAdjuster>();
        ArrayList<VerticalAxisAdjuster> min = new ArrayList<VerticalAxisAdjuster>();
        ArrayList<VerticalAxisAdjuster> max = new ArrayList<VerticalAxisAdjuster>();
        OneAxis[] oneAxisArray = this.fVerticalAxes;
        int n = this.fVerticalAxes.length;
        int n2 = 0;
        while (n2 < n) {
            OneAxis oa2 = oneAxisArray[n2];
            VerticalAxisAdjuster vaa = new VerticalAxisAdjuster(oa2, this.fHorizontalAxis, this.fPlotWithAxes, this.fPlotBounds);
            int iv = oa2.getIntersectionValue().getType();
            switch (iv) {
                case 2: {
                    min.add(vaa);
                    break;
                }
                case 1: {
                    max.add(vaa);
                    break;
                }
                default: {
                    values.add(vaa);
                }
            }
            ++n2;
        }
        double x = Double.NaN;
        double left = Double.NaN;
        double right = Double.NaN;
        double[] endPoints = this.fHorizontalAxis.getScale().getEndPoints();
        this.fHorizontalAxis.getScale().resetShifts();
        int i = 0;
        while (i < values.size()) {
            ((VerticalAxisAdjuster)values.get(i)).adjust();
            double locationDelta = Math.abs(AxesAdjuster.getLocationDelta(this.fHorizontalAxis.getScale(), ((VerticalAxisAdjuster)values.get(i)).getVerticalAxis().getIntersectionValue()));
            if (Double.isNaN(x)) {
                x = ((VerticalAxisAdjuster)values.get(i)).getAxisX();
                if (!isBackward) {
                    left = ((VerticalAxisAdjuster)values.get(i)).getAxisLeftEdge();
                    if ((x -= locationDelta) < left) {
                        left = x;
                    }
                    right = x;
                } else {
                    left = x += locationDelta;
                    right = ((VerticalAxisAdjuster)values.get(i)).getAxisRightEdge();
                    if (x > right) {
                        right = x;
                    }
                }
            } else {
                double deltaX1 = x - left;
                double deltaX2 = right - x;
                double newX = ((VerticalAxisAdjuster)values.get(i)).getAxisX();
                newX = !isBackward ? (newX -= locationDelta) : (newX += locationDelta);
                if (!isBackward) {
                    if (newX > x) {
                        x = newX;
                    }
                    left = x - Math.max(deltaX1, x - ((VerticalAxisAdjuster)values.get(i)).getAxisLeftEdge());
                    right = x;
                } else {
                    if (newX < x) {
                        x = newX;
                    }
                    left = x;
                    right = x + Math.max(deltaX2, ((VerticalAxisAdjuster)values.get(i)).getAxisRightEdge() - x);
                }
            }
            scX.setEndPoints(endPoints[0], endPoints[1]);
            ++i;
        }
        scX.setEndPoints(endPoints[0], endPoints[1]);
        scX.resetShifts();
        i = 0;
        while (i < min.size()) {
            ((VerticalAxisAdjuster)min.get(i)).adjust();
            if (Double.isNaN(x)) {
                x = ((VerticalAxisAdjuster)min.get(i)).getAxisX();
                left = ((VerticalAxisAdjuster)min.get(i)).getAxisLeftEdge();
                right = ((VerticalAxisAdjuster)min.get(i)).getAxisRightEdge();
            } else {
                double deltaX1 = x - left;
                double deltaX2 = right - x;
                if (((VerticalAxisAdjuster)min.get(i)).getAxisX() > x) {
                    x = ((VerticalAxisAdjuster)min.get(i)).getAxisX();
                }
                left = x - Math.max(deltaX1, ((VerticalAxisAdjuster)min.get(i)).getAxisX() - ((VerticalAxisAdjuster)min.get(i)).getAxisLeftEdge());
                right = x + Math.max(deltaX2, ((VerticalAxisAdjuster)min.get(i)).getAxisRightEdge() - ((VerticalAxisAdjuster)min.get(i)).getAxisX());
            }
            scX.setEndPoints(endPoints[0], endPoints[1]);
            ++i;
        }
        scX.setEndPoints(endPoints[0], endPoints[1]);
        double[] positions = this.adjustOrthogonalAxis(2, this.fHorizontalAxis, x, left, right);
        x = positions[0];
        left = positions[1];
        right = positions[2];
        int i2 = 0;
        while (i2 < values.size()) {
            oa = ((VerticalAxisAdjuster)values.get(i2)).getVerticalAxis();
            iYTitleLocation = oa.getTitlePosition();
            double axisCoordinate = 0.0;
            double locationDelta = Math.abs(AxesAdjuster.getLocationDelta(this.fHorizontalAxis.getScale(), ((VerticalAxisAdjuster)values.get(i2)).getVerticalAxis().getIntersectionValue()));
            if (!isBackward) {
                axisCoordinate = scX.getEndPoints()[0];
                axisCoordinate += locationDelta;
            } else {
                axisCoordinate = scX.getEndPoints()[1];
                axisCoordinate -= locationDelta;
            }
            double axisTitleCoordinate = iYTitleLocation == 1.0 ? left - 1.0 + locationDelta : axisCoordinate + 1.0 + (oa.getLabelPosition() == 1 ? 0.0 : ((VerticalAxisAdjuster)values.get(i2)).getAxisLabelThickness());
            oa.setAxisCoordinate(axisCoordinate);
            oa.setTitleCoordinate(axisTitleCoordinate);
            ++i2;
        }
        i2 = 0;
        while (i2 < min.size()) {
            iYTitleLocation = (oa = ((VerticalAxisAdjuster)min.get(i2)).getVerticalAxis()).getTitlePosition();
            oa.setTitleCoordinate(iYTitleLocation == 1.0 ? left - 1.0 : right + 1.0 - ((VerticalAxisAdjuster)min.get(i2)).getAxisTitleThickness());
            oa.setAxisCoordinate(x);
            ++i2;
        }
        x = Double.NaN;
        left = Double.NaN;
        right = Double.NaN;
        endPoints = scX.getEndPoints();
        scX.resetShifts();
        i2 = 0;
        while (i2 < max.size()) {
            ((VerticalAxisAdjuster)max.get(i2)).adjust();
            if (Double.isNaN(x)) {
                x = ((VerticalAxisAdjuster)max.get(i2)).getAxisX();
                left = ((VerticalAxisAdjuster)max.get(i2)).getAxisLeftEdge();
                right = ((VerticalAxisAdjuster)max.get(i2)).getAxisRightEdge();
            } else {
                double deltaX1 = x - left;
                double deltaX2 = right - x;
                if (((VerticalAxisAdjuster)max.get(i2)).getAxisX() < x) {
                    x = ((VerticalAxisAdjuster)max.get(i2)).getAxisX();
                    left = x - Math.max(deltaX1, x - ((VerticalAxisAdjuster)max.get(i2)).getAxisLeftEdge());
                    right = x + Math.max(deltaX2, ((VerticalAxisAdjuster)max.get(i2)).getAxisRightEdge() - x);
                }
            }
            scX.setEndPoints(endPoints[0], endPoints[1]);
            ++i2;
        }
        if (!Double.isNaN(x)) {
            scX.setEndPoints(endPoints[0], endPoints[1]);
            positions = this.adjustOrthogonalAxis(1, this.fHorizontalAxis, x, left, right);
            x = positions[0];
            left = positions[1];
            right = positions[2];
        }
        i2 = 0;
        while (i2 < max.size()) {
            OneAxis oa3;
            iYTitleLocation = (oa3 = ((VerticalAxisAdjuster)max.get(i2)).getVerticalAxis()).getTitlePosition();
            oa3.setTitleCoordinate(iYTitleLocation == 1.0 ? left - 1.0 : right + 1.0 - ((VerticalAxisAdjuster)max.get(i2)).getAxisTitleThickness());
            oa3.setAxisCoordinate(x);
            ++i2;
        }
        scX.computeTicks(this.fPlotWithAxes.getDisplayServer(), this.fHorizontalAxis.getLabel(), this.fHorizontalAxis.getLabelPosition(), 0, scX.getStart(), scX.getEnd(), false, this.fPlotWithAxes.getAxes());
        scX.resetShifts();
    }

    public double[] adjustOrthogonalAxis(int iv, OneAxis orthogonalAxis, double dX, double dLeftEdge, double dRightEdge) throws ChartException {
        IDisplayServer ids = this.fPlotWithAxes.getDisplayServer();
        AutoScale scX = orthogonalAxis.getScale();
        AllAxes aax = this.fPlotWithAxes.getAxes();
        Label laXAxisLabels = orthogonalAxis.getLabel();
        int iXLabelLocation = orthogonalAxis.getLabelPosition();
        double dYAxisThickness = dRightEdge - dLeftEdge;
        double dDeltaX2 = dRightEdge - dX;
        double dDeltaX1 = dX - dLeftEdge;
        if (iv == 2) {
            double dStart;
            double dEnd;
            scX.computeAxisStartEndShifts(ids, laXAxisLabels, 0, iXLabelLocation, aax);
            boolean startEndChanged = false;
            if (scX.getDirection() == -1) {
                if (dYAxisThickness > scX.getEndShift()) {
                    dEnd = dRightEdge;
                    startEndChanged = true;
                } else {
                    dEnd = scX.getEnd();
                }
                dStart = scX.getStart();
            } else {
                if (dYAxisThickness > scX.getStartShift()) {
                    dStart = dRightEdge;
                    startEndChanged = true;
                } else {
                    dStart = scX.getStart();
                }
                dEnd = scX.getEnd();
            }
            scX.resetShifts();
            scX.setEndPoints(dStart, dEnd);
            boolean considerStartLabel = false;
            boolean considerEndLabel = false;
            if (scX.getDirection() == -1) {
                considerEndLabel = !startEndChanged;
            } else {
                considerStartLabel = !startEndChanged;
            }
            scX.computeTicks(ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, considerStartLabel, considerEndLabel, aax);
            if (!scX.isStepFixed()) {
                Object[] oaMinMax = scX.getMinMax();
                while (!scX.checkFit(ids, laXAxisLabels, iXLabelLocation)) {
                    if (!scX.zoomOut()) break;
                    scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    int tickCount = scX.computeTicks(ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, considerStartLabel, considerEndLabel, aax);
                    if (scX.getUnit() != null && PlotWithAxes.asInteger(scX.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
                }
            }
            if (scX.getDirection() == -1) {
                if (dYAxisThickness < scX.getEndShift()) {
                    dX = scX.getEnd() - (dRightEdge - dX);
                }
            } else if (dYAxisThickness < scX.getStartShift()) {
                dX = scX.getStart() - (dRightEdge - dX);
            }
            dRightEdge = (dX -= this.fPlotWithAxes.getPlotInsets().getLeft()) + dDeltaX2;
            dLeftEdge = dX - dDeltaX1;
        } else if (iv == 1) {
            double dEnd;
            double dStart;
            scX.computeAxisStartEndShifts(ids, laXAxisLabels, 0, iXLabelLocation, aax);
            boolean startEndChanged = false;
            if (scX.getDirection() == -1) {
                if (dYAxisThickness > scX.getStartShift()) {
                    dStart = dLeftEdge;
                    startEndChanged = true;
                } else {
                    dStart = scX.getStart();
                }
                dEnd = scX.getEnd();
            } else {
                if (dYAxisThickness > scX.getEndShift()) {
                    dEnd = dLeftEdge;
                    startEndChanged = true;
                } else {
                    dEnd = scX.getEnd();
                }
                dStart = scX.getStart();
            }
            scX.resetShifts();
            scX.setEndPoints(dStart, dEnd);
            boolean considerStartLabel = false;
            boolean considerEndLabel = false;
            if (scX.getDirection() == -1) {
                considerStartLabel = !startEndChanged;
            } else {
                considerEndLabel = !startEndChanged;
            }
            scX.computeTicks(ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, considerStartLabel, considerEndLabel, aax);
            if (!scX.isStepFixed()) {
                Object[] oaMinMax = scX.getMinMax();
                while (!scX.checkFit(ids, laXAxisLabels, iXLabelLocation)) {
                    if (!scX.zoomOut()) break;
                    scX.updateAxisMinMax(oaMinMax[0], oaMinMax[1]);
                    int tickCount = scX.computeTicks(ids, laXAxisLabels, iXLabelLocation, 0, dStart, dEnd, considerStartLabel, considerEndLabel, aax);
                    if (scX.getUnit() != null && PlotWithAxes.asInteger(scX.getUnit()) == 1 && tickCount <= 3 || this.fPlotWithAxes.isSharedScale()) break;
                }
            }
            if (scX.getDirection() == -1) {
                if (dYAxisThickness < scX.getStartShift()) {
                    dX = scX.getStart() - (dLeftEdge - dX);
                }
            } else if (dYAxisThickness < scX.getEndShift()) {
                dX = scX.getEnd() - (dLeftEdge - dX);
            }
            dRightEdge = (dX += this.fPlotWithAxes.getPlotInsets().getRight()) + dDeltaX2;
            dLeftEdge = dX - dDeltaX1;
        }
        return new double[]{dX, dLeftEdge, dRightEdge};
    }
}

