/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.chart.device.swt;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.birt.chart.device.DeviceAdapter;
import org.eclipse.birt.chart.device.FontUtil;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IDisplayServer;
import org.eclipse.birt.chart.device.IPrimitiveRenderer;
import org.eclipse.birt.chart.device.IUpdateNotifier;
import org.eclipse.birt.chart.device.swt.R31Enhance;
import org.eclipse.birt.chart.device.swt.RegionAction;
import org.eclipse.birt.chart.device.swt.SwtDisplayServer;
import org.eclipse.birt.chart.device.swt.SwtEventHandler;
import org.eclipse.birt.chart.device.swt.SwtTextRenderer;
import org.eclipse.birt.chart.device.swt.i18n.Messages;
import org.eclipse.birt.chart.event.ArcRenderEvent;
import org.eclipse.birt.chart.event.AreaRenderEvent;
import org.eclipse.birt.chart.event.ClipRenderEvent;
import org.eclipse.birt.chart.event.ImageRenderEvent;
import org.eclipse.birt.chart.event.InteractionEvent;
import org.eclipse.birt.chart.event.LineRenderEvent;
import org.eclipse.birt.chart.event.OvalRenderEvent;
import org.eclipse.birt.chart.event.PolygonRenderEvent;
import org.eclipse.birt.chart.event.PrimitiveRenderEvent;
import org.eclipse.birt.chart.event.RectangleRenderEvent;
import org.eclipse.birt.chart.event.TextRenderEvent;
import org.eclipse.birt.chart.event.TransformationEvent;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.log.ILogger;
import org.eclipse.birt.chart.log.Logger;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.EmbeddedImage;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.Gradient;
import org.eclipse.birt.chart.model.attribute.Image;
import org.eclipse.birt.chart.model.attribute.LineAttributes;
import org.eclipse.birt.chart.model.attribute.Location;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.render.InteractiveRenderer;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.birt.chart.util.SecurityUtil;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Path;
import org.eclipse.swt.graphics.Pattern;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.widgets.Composite;

public class SwtRendererImpl
extends DeviceAdapter {
    public static final String DOUBLE_BUFFERED = "device.double.buffered";
    private final LinkedHashMap<TriggerCondition, List<RegionAction>> _lhmAllTriggers = new LinkedHashMap();
    private IDisplayServer _ids;
    private SwtTextRenderer _tr;
    private GC _gc = null;
    private IUpdateNotifier _iun = null;
    private SwtEventHandler _eh = null;
    private double dTranslateX = 0.0;
    private double dTranslateY = 0.0;
    private double dRotateInDegrees = 0.0;
    private double dScale = 1.0;
    private InteractiveRenderer iv;
    static final int CEIL = 1;
    static final int TRUNCATE = 2;
    private static ILogger logger = Logger.getLogger((String)"org.eclipse.birt.chart.device.extension/swt");

    public SwtRendererImpl() {
        PluginSettings ps = PluginSettings.instance();
        try {
            this._ids = ps.getDisplayServer("ds.SWT");
            this._tr = new SwtTextRenderer(this._ids);
            this.iv = new InteractiveRenderer();
        }
        catch (ChartException pex) {
            logger.log((Exception)((Object)pex));
        }
    }

    public Object getGraphicsContext() {
        return this._gc;
    }

    public IDisplayServer getDisplayServer() {
        return this._ids;
    }

    public void setClip(ClipRenderEvent cre) {
        Location[] loa = cre.getVertices();
        if (loa == null) {
            this._gc.setClipping(null);
        } else {
            Region rgClipping = new Region();
            rgClipping.add(SwtRendererImpl.getCoordinatesAsInts(loa, 2, this.dTranslateX, this.dTranslateY, this.dScale));
            this._gc.setClipping(rgClipping);
            rgClipping.dispose();
        }
    }

    public void drawImage(ImageRenderEvent pre) throws ChartException {
        if (pre.getImage() == null || pre.getLocation() == null) {
            return;
        }
        org.eclipse.swt.graphics.Image img = null;
        if (pre.getImage() instanceof EmbeddedImage) {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(Base64.decodeBase64((byte[])((EmbeddedImage)pre.getImage()).getData().getBytes()));
                img = new org.eclipse.swt.graphics.Image(((SwtDisplayServer)this._ids).getDevice(), (InputStream)bis);
            }
            catch (Exception ilex) {
                throw new ChartException("org.eclipse.birt.chart.device.swt", 11, (Throwable)ilex);
            }
        }
        try {
            String sUrl = pre.getImage().getURL();
            img = (org.eclipse.swt.graphics.Image)this._ids.loadImage(SecurityUtil.newURL((String)sUrl));
        }
        catch (ChartException ilex) {
            logger.log((Exception)((Object)new ChartException("org.eclipse.birt.chart.device.swt", 11, (Throwable)ilex)));
        }
        catch (MalformedURLException muex) {
            throw new ChartException("org.eclipse.birt.chart.device.swt", 11, (Throwable)muex);
        }
        if (img == null) {
            return;
        }
        Location loc = pre.getLocation();
        Position pos = pre.getPosition();
        if (pos == null) {
            pos = Position.INSIDE_LITERAL;
        }
        boolean bSizeSet = pre.getWidth() * pre.getHeight() > 0;
        int width = bSizeSet ? pre.getWidth() : img.getBounds().width;
        int height = bSizeSet ? pre.getHeight() : img.getBounds().height;
        int x = (int)loc.getX();
        int y = (int)loc.getY();
        switch (pos.getValue()) {
            case 4: 
            case 5: {
                x -= width / 2;
                y -= height / 2;
                break;
            }
            case 2: {
                x -= width;
                y -= height / 2;
                break;
            }
            case 3: {
                y -= height / 2;
                break;
            }
            case 0: {
                x -= width / 2;
                y -= height;
                break;
            }
            case 1: {
                x -= width / 2;
            }
        }
        if (bSizeSet) {
            this._gc.drawImage(img, 0, 0, img.getBounds().width, img.getBounds().height, x, y, pre.getWidth(), pre.getHeight());
        } else {
            this._gc.drawImage(img, x, y);
        }
        img.dispose();
    }

    public void drawLine(LineRenderEvent lre) throws ChartException {
        this.iv.modifyEvent((PrimitiveRenderEvent)lre);
        LineAttributes lia = lre.getLineAttributes();
        if (!this.validateLineAttributes(lre.getSource(), lia) || lia.getColor() == null) {
            return;
        }
        int iOldLineStyle = this._gc.getLineStyle();
        int iOldLineWidth = this._gc.getLineWidth();
        Color cFG = (Color)this._ids.getColor(lia.getColor());
        int iLineStyle = 1;
        switch (lia.getStyle().getValue()) {
            case 2: {
                iLineStyle = 3;
                break;
            }
            case 3: {
                iLineStyle = 4;
                break;
            }
            case 1: {
                iLineStyle = 2;
            }
        }
        this._gc.setLineStyle(iLineStyle);
        this._gc.setLineWidth(lia.getThickness());
        Location lo1 = lre.getStart();
        Location lo2 = lre.getEnd();
        this._gc.setForeground(cFG);
        R31Enhance.setAlpha(this._gc, lia.getColor());
        this._gc.drawLine((int)((lo1.getX() + this.dTranslateX) * this.dScale), (int)((lo1.getY() + this.dTranslateY) * this.dScale), (int)((lo2.getX() + this.dTranslateX) * this.dScale), (int)((lo2.getY() + this.dTranslateY) * this.dScale));
        this._gc.setLineStyle(iOldLineStyle);
        this._gc.setLineWidth(iOldLineWidth);
        cFG.dispose();
    }

    public void drawRectangle(RectangleRenderEvent rre) throws ChartException {
        this.iv.modifyEvent((PrimitiveRenderEvent)rre);
        LineAttributes lia = rre.getOutline();
        if (!this.validateLineAttributes(rre.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), rre.getBackground(), this._ids);
        if (cFG == null) {
            return;
        }
        int iOldLineStyle = this._gc.getLineStyle();
        int iOldLineWidth = this._gc.getLineWidth();
        int iLineStyle = 1;
        switch (lia.getStyle().getValue()) {
            case 2: {
                iLineStyle = 3;
                break;
            }
            case 3: {
                iLineStyle = 4;
                break;
            }
            case 1: {
                iLineStyle = 2;
            }
        }
        this._gc.setLineStyle(iLineStyle);
        this._gc.setLineWidth(lia.getThickness());
        Bounds bo = SwtRendererImpl.normalizeBounds(rre.getBounds());
        this._gc.setForeground(cFG);
        R31Enhance.setAlpha(this._gc, lia.getColor());
        this._gc.drawRectangle((int)((bo.getLeft() + this.dTranslateX) * this.dScale), (int)((bo.getTop() + this.dTranslateY) * this.dScale), (int)(bo.getWidth() * this.dScale) - 1, (int)(bo.getHeight() * this.dScale) - 1);
        this._gc.setLineStyle(iOldLineStyle);
        this._gc.setLineWidth(iOldLineWidth);
        cFG.dispose();
    }

    public void fillRectangle(RectangleRenderEvent rre) throws ChartException {
        this.iv.modifyEvent((PrimitiveRenderEvent)rre);
        Fill flBackground = this.validateMultipleFill(rre.getBackground());
        if (this.isFullTransparent(flBackground)) {
            return;
        }
        Bounds bo = SwtRendererImpl.normalizeBounds(rre.getBounds());
        Rectangle r = new Rectangle((int)((bo.getLeft() + this.dTranslateX) * this.dScale), (int)((bo.getTop() + this.dTranslateY) * this.dScale), (int)Math.ceil(bo.getWidth() * this.dScale), (int)Math.ceil(bo.getHeight() * this.dScale));
        Path pt = new Path(((SwtDisplayServer)this._ids).getDevice());
        pt.moveTo((float)r.x, (float)r.y);
        pt.lineTo((float)r.x, (float)(r.y + r.height));
        pt.lineTo((float)(r.x + r.width), (float)(r.y + r.height));
        pt.lineTo((float)(r.x + r.width), (float)r.y);
        try {
            if (flBackground instanceof ColorDefinition) {
                this.fillPathColor(pt, (ColorDefinition)flBackground);
            }
            if (flBackground instanceof Gradient) {
                this.fillPathGradient(pt, (Gradient)flBackground, r);
            } else if (flBackground instanceof Image) {
                this.fillPathImage(pt, (Image)flBackground);
            }
        }
        finally {
            pt.dispose();
        }
    }

    public void drawPolygon(PolygonRenderEvent pre) throws ChartException {
        this.iv.modifyEvent((PrimitiveRenderEvent)pre);
        LineAttributes lia = pre.getOutline();
        if (!this.validateLineAttributes(pre.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), pre.getBackground(), this._ids);
        if (cFG == null) {
            return;
        }
        int iOldLineStyle = this._gc.getLineStyle();
        int iOldLineWidth = this._gc.getLineWidth();
        int iLineStyle = 1;
        switch (lia.getStyle().getValue()) {
            case 2: {
                iLineStyle = 3;
                break;
            }
            case 3: {
                iLineStyle = 4;
                break;
            }
            case 1: {
                iLineStyle = 2;
            }
        }
        this._gc.setLineStyle(iLineStyle);
        this._gc.setLineWidth(lia.getThickness());
        this._gc.setForeground(cFG);
        R31Enhance.setAlpha(this._gc, lia.getColor());
        this._gc.drawPolygon(SwtRendererImpl.getCoordinatesAsInts(pre.getPoints(), 2, this.dTranslateX, this.dTranslateY, this.dScale));
        this._gc.setLineStyle(iOldLineStyle);
        this._gc.setLineWidth(iOldLineWidth);
        cFG.dispose();
    }

    public void fillPolygon(PolygonRenderEvent pre) throws ChartException {
        this.iv.modifyEvent((PrimitiveRenderEvent)pre);
        Fill flBackground = this.validateMultipleFill(pre.getBackground());
        if (this.isFullTransparent(flBackground)) {
            return;
        }
        Bounds bo = SwtRendererImpl.normalizeBounds(pre.getBounds());
        Rectangle r = new Rectangle((int)((bo.getLeft() + this.dTranslateX) * this.dScale), (int)((bo.getTop() + this.dTranslateY) * this.dScale), (int)Math.ceil(bo.getWidth() * this.dScale), (int)Math.ceil(bo.getHeight() * this.dScale));
        float[] points = SwtRendererImpl.convertDoubleToFloat(SwtRendererImpl.getDoubleCoordinatesAsInts(pre.getPoints(), 2, this.dTranslateX, this.dTranslateY, this.dScale));
        if (points.length < 1) {
            return;
        }
        Path pt = new Path(((SwtDisplayServer)this._ids).getDevice());
        pt.moveTo(points[0], points[1]);
        int i = 1;
        while (i < points.length / 2) {
            pt.lineTo(points[2 * i], points[2 * i + 1]);
            ++i;
        }
        try {
            if (flBackground instanceof ColorDefinition) {
                this.fillPathColor(pt, (ColorDefinition)flBackground);
            } else if (flBackground instanceof Gradient) {
                this.fillPathGradient(pt, (Gradient)flBackground, r);
            } else if (flBackground instanceof Image) {
                this.fillPathImage(pt, (Image)flBackground);
            }
        }
        finally {
            pt.dispose();
        }
    }

    protected void drawArc(GC _gc, Device _dv, ArcRenderEvent are, double dTranslateX, double dTranslateY, double dScale) {
        if (are.getInnerRadius() >= 0.0 && are.getOuterRadius() > 0.0 && are.getInnerRadius() < are.getOuterRadius() || are.getInnerRadius() > 0.0 && are.getOuterRadius() <= 0.0) {
            Bounds bo = goFactory.createBounds(are.getTopLeft().getX(), are.getTopLeft().getY(), are.getWidth(), are.getHeight());
            Bounds rctOuter = are.getOuterRadius() > 0.0 ? goFactory.createBounds((bo.getLeft() + dTranslateX + (bo.getWidth() / 2.0 - are.getOuterRadius())) * dScale, (bo.getTop() + dTranslateY + (bo.getHeight() / 2.0 - are.getOuterRadius())) * dScale, 2.0 * are.getOuterRadius() * dScale, 2.0 * are.getOuterRadius() * dScale) : goFactory.createBounds((bo.getLeft() + dTranslateX) * dScale, (bo.getTop() + dTranslateY) * dScale, bo.getWidth() * dScale, bo.getHeight() * dScale);
            Bounds rctInner = are.getInnerRadius() > 0.0 ? goFactory.createBounds((bo.getLeft() + dTranslateX + (bo.getWidth() / 2.0 - are.getInnerRadius())) * dScale, (bo.getTop() + dTranslateY + (bo.getHeight() / 2.0 - are.getInnerRadius())) * dScale, 2.0 * are.getInnerRadius() * dScale, 2.0 * are.getInnerRadius() * dScale) : goFactory.createBounds((bo.getLeft() + dTranslateX + bo.getWidth() / 2.0) * dScale, (bo.getTop() + dTranslateY + bo.getHeight() / 2.0) * dScale, 0.0, 0.0);
            double startAngle = Math.toRadians(-are.getStartAngle());
            double stopAngle = Math.toRadians(-are.getStartAngle() - are.getAngleExtent());
            double xsOuter = rctOuter.getLeft() + (Math.cos(startAngle) * 0.5 + 0.5) * rctOuter.getWidth();
            double ysOuter = rctOuter.getTop() + (Math.sin(startAngle) * 0.5 + 0.5) * rctOuter.getHeight();
            double xeInner = rctInner.getLeft() + (Math.cos(stopAngle) * 0.5 + 0.5) * rctInner.getWidth();
            double yeInner = rctInner.getTop() + (Math.sin(stopAngle) * 0.5 + 0.5) * rctInner.getHeight();
            Path pt = new Path(_dv);
            pt.addArc((float)rctOuter.getLeft(), (float)rctOuter.getTop(), (float)rctOuter.getWidth(), (float)rctOuter.getHeight(), (float)are.getStartAngle(), (float)are.getAngleExtent());
            pt.lineTo((float)xeInner, (float)yeInner);
            pt.addArc((float)rctInner.getLeft(), (float)rctInner.getTop(), (float)rctInner.getWidth(), (float)rctInner.getHeight(), (float)(are.getStartAngle() + are.getAngleExtent()), (float)(-are.getAngleExtent()));
            pt.lineTo((float)xsOuter, (float)ysOuter);
            _gc.drawPath(pt);
            pt.dispose();
        } else if (are.getStyle() == 1) {
            _gc.drawArc((int)((are.getTopLeft().getX() + dTranslateX) * dScale), (int)((are.getTopLeft().getY() + dTranslateY) * dScale), (int)(are.getWidth() * dScale), (int)(are.getHeight() * dScale), (int)are.getStartAngle(), (int)are.getAngleExtent());
        } else {
            double xc = (are.getTopLeft().getX() + dTranslateX + are.getWidth() / 2.0) * dScale;
            double yc = (are.getTopLeft().getY() + dTranslateY + are.getHeight() / 2.0) * dScale;
            double xs = 0.0;
            double ys = 0.0;
            double xe = 0.0;
            double ye = 0.0;
            double angle = Math.toRadians(-are.getStartAngle());
            xs = (are.getTopLeft().getX() + dTranslateX + (Math.cos(angle) * 0.5 + 0.5) * are.getWidth()) * dScale;
            ys = (are.getTopLeft().getY() + dTranslateY + (Math.sin(angle) * 0.5 + 0.5) * are.getHeight()) * dScale;
            angle = Math.toRadians(-are.getStartAngle() - are.getAngleExtent());
            xe = (are.getTopLeft().getX() + dTranslateX + (Math.cos(angle) * 0.5 + 0.5) * are.getWidth()) * dScale;
            ye = (are.getTopLeft().getY() + dTranslateY + (Math.sin(angle) * 0.5 + 0.5) * are.getHeight()) * dScale;
            Path pt = new Path(_dv);
            if (are.getStyle() == 2) {
                pt.addArc((float)((are.getTopLeft().getX() + dTranslateX) * dScale), (float)((are.getTopLeft().getY() + dTranslateY) * dScale), (float)(are.getWidth() * dScale), (float)(are.getHeight() * dScale), (float)are.getStartAngle(), (float)are.getAngleExtent());
                pt.moveTo((float)xe, (float)ye);
                pt.lineTo((float)xs, (float)ys);
                _gc.drawPath(pt);
            } else if (are.getStyle() == 3) {
                pt.addArc((float)((are.getTopLeft().getX() + dTranslateX) * dScale), (float)((are.getTopLeft().getY() + dTranslateY) * dScale), (float)(are.getWidth() * dScale), (float)(are.getHeight() * dScale), (float)are.getStartAngle(), (float)are.getAngleExtent());
                pt.moveTo((float)xe, (float)ye);
                pt.lineTo((float)xc, (float)yc);
                pt.lineTo((float)xs, (float)ys);
                _gc.drawPath(pt);
            }
            pt.dispose();
        }
    }

    public void drawArc(ArcRenderEvent are) throws ChartException {
        this.iv.modifyEvent((PrimitiveRenderEvent)are);
        LineAttributes lia = are.getOutline();
        if (!this.validateLineAttributes(are.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), are.getBackground(), this._ids);
        if (cFG == null) {
            return;
        }
        int iOldLineStyle = this._gc.getLineStyle();
        int iOldLineWidth = this._gc.getLineWidth();
        int iLineStyle = 1;
        switch (lia.getStyle().getValue()) {
            case 2: {
                iLineStyle = 3;
                break;
            }
            case 3: {
                iLineStyle = 4;
                break;
            }
            case 1: {
                iLineStyle = 2;
            }
        }
        this._gc.setLineStyle(iLineStyle);
        this._gc.setLineWidth(lia.getThickness());
        this._gc.setForeground(cFG);
        R31Enhance.setAlpha(this._gc, lia.getColor());
        this.drawArc(this._gc, ((SwtDisplayServer)this._ids).getDevice(), are, this.dTranslateX, this.dTranslateY, this.dScale);
        this._gc.setLineStyle(iOldLineStyle);
        this._gc.setLineWidth(iOldLineWidth);
        cFG.dispose();
    }

    public void fillArc(ArcRenderEvent are) throws ChartException {
        this.iv.modifyEvent((PrimitiveRenderEvent)are);
        Fill flBackground = this.validateMultipleFill(are.getBackground());
        if (this.isFullTransparent(flBackground) || are.getAngleExtent() == 0.0) {
            return;
        }
        Bounds bo = goFactory.createBounds(are.getTopLeft().getX(), are.getTopLeft().getY(), are.getWidth(), are.getHeight());
        Rectangle r = new Rectangle((int)((bo.getLeft() + this.dTranslateX) * this.dScale), (int)((bo.getTop() + this.dTranslateY) * this.dScale), (int)Math.ceil(bo.getWidth() * this.dScale), (int)Math.ceil(bo.getHeight() * this.dScale));
        Path pt = new Path(((SwtDisplayServer)this._ids).getDevice());
        if (are.getInnerRadius() >= 0.0 && are.getOuterRadius() > 0.0 && are.getInnerRadius() < are.getOuterRadius() || are.getInnerRadius() > 0.0 && are.getOuterRadius() <= 0.0) {
            Bounds rctOuter = are.getOuterRadius() > 0.0 ? goFactory.createBounds((bo.getLeft() + this.dTranslateX + (bo.getWidth() / 2.0 - are.getOuterRadius())) * this.dScale, (bo.getTop() + this.dTranslateY + (bo.getHeight() / 2.0 - are.getOuterRadius())) * this.dScale, 2.0 * are.getOuterRadius() * this.dScale, 2.0 * are.getOuterRadius() * this.dScale) : goFactory.createBounds((bo.getLeft() + this.dTranslateX) * this.dScale, (bo.getTop() + this.dTranslateY) * this.dScale, bo.getWidth() * this.dScale, bo.getHeight() * this.dScale);
            Bounds rctInner = are.getInnerRadius() > 0.0 ? goFactory.createBounds((bo.getLeft() + this.dTranslateX + (bo.getWidth() / 2.0 - are.getInnerRadius())) * this.dScale, (bo.getTop() + this.dTranslateY + (bo.getHeight() / 2.0 - are.getInnerRadius())) * this.dScale, 2.0 * are.getInnerRadius() * this.dScale, 2.0 * are.getInnerRadius() * this.dScale) : goFactory.createBounds((bo.getLeft() + this.dTranslateX + bo.getWidth() / 2.0) * this.dScale, (bo.getTop() + this.dTranslateY + bo.getHeight() / 2.0) * this.dScale, 0.0, 0.0);
            double startAngle = Math.toRadians(-are.getStartAngle());
            double stopAngle = Math.toRadians(-are.getStartAngle() - are.getAngleExtent());
            double xsOuter = rctOuter.getLeft() + (Math.cos(startAngle) * 0.5 + 0.5) * rctOuter.getWidth();
            double ysOuter = rctOuter.getTop() + (Math.sin(startAngle) * 0.5 + 0.5) * rctOuter.getHeight();
            double xeInner = rctInner.getLeft() + (Math.cos(stopAngle) * 0.5 + 0.5) * rctInner.getWidth();
            double yeInner = rctInner.getTop() + (Math.sin(stopAngle) * 0.5 + 0.5) * rctInner.getHeight();
            pt.addArc((float)rctOuter.getLeft(), (float)rctOuter.getTop(), (float)rctOuter.getWidth(), (float)rctOuter.getHeight(), (float)are.getStartAngle(), (float)are.getAngleExtent());
            pt.lineTo((float)xeInner, (float)yeInner);
            pt.addArc((float)rctInner.getLeft(), (float)rctInner.getTop(), (float)rctInner.getWidth(), (float)rctInner.getHeight(), (float)(are.getStartAngle() + are.getAngleExtent()), (float)(-are.getAngleExtent()));
            pt.lineTo((float)xsOuter, (float)ysOuter);
        } else if (are.getStyle() == 3 || are.getStyle() == 2 && Math.abs(are.getAngleExtent()) >= 360.0) {
            double xc = (are.getTopLeft().getX() + this.dTranslateX + are.getWidth() / 2.0) * this.dScale;
            double yc = (are.getTopLeft().getY() + this.dTranslateY + are.getHeight() / 2.0) * this.dScale;
            double xs = 0.0;
            double ys = 0.0;
            double angle = Math.toRadians(-are.getStartAngle());
            xs = (are.getTopLeft().getX() + this.dTranslateX + (Math.cos(angle) * 0.5 + 0.5) * are.getWidth()) * this.dScale;
            ys = (are.getTopLeft().getY() + this.dTranslateY + (Math.sin(angle) * 0.5 + 0.5) * are.getHeight()) * this.dScale;
            if (are.getStyle() == 2) {
                pt.addArc((float)((are.getTopLeft().getX() + this.dTranslateX) * this.dScale), (float)((are.getTopLeft().getY() + this.dTranslateY) * this.dScale), (float)(are.getWidth() * this.dScale), (float)(are.getHeight() * this.dScale), (float)are.getStartAngle(), (float)are.getAngleExtent());
                pt.lineTo((float)xs, (float)ys);
            } else if (are.getStyle() == 3) {
                pt.addArc((float)((are.getTopLeft().getX() + this.dTranslateX) * this.dScale), (float)((are.getTopLeft().getY() + this.dTranslateY) * this.dScale), (float)(are.getWidth() * this.dScale), (float)(are.getHeight() * this.dScale), (float)are.getStartAngle(), (float)are.getAngleExtent());
                pt.lineTo((float)xc, (float)yc);
                pt.lineTo((float)xs, (float)ys);
            }
        } else if (are.getStyle() == 1 || are.getStyle() == 2) {
            double angle = Math.toRadians(-are.getStartAngle());
            double xs = (are.getTopLeft().getX() + this.dTranslateX + (Math.cos(angle) * 0.5 + 0.5) * are.getWidth()) * this.dScale;
            double ys = (are.getTopLeft().getY() + this.dTranslateY + (Math.sin(angle) * 0.5 + 0.5) * are.getHeight()) * this.dScale;
            pt.addArc((float)((are.getTopLeft().getX() + this.dTranslateX) * this.dScale), (float)((are.getTopLeft().getY() + this.dTranslateY) * this.dScale), (float)(are.getWidth() * this.dScale), (float)(are.getHeight() * this.dScale), (float)are.getStartAngle(), (float)are.getAngleExtent());
            pt.lineTo((float)xs, (float)ys);
        }
        try {
            if (flBackground instanceof ColorDefinition) {
                this.fillPathColor(pt, (ColorDefinition)flBackground);
            } else if (flBackground instanceof Gradient) {
                this.fillPathGradient(pt, (Gradient)flBackground, r);
            } else if (flBackground instanceof Image) {
                this.fillPathImage(pt, (Image)flBackground);
            }
        }
        finally {
            pt.dispose();
        }
    }

    private final void fillPathColor(Path path, ColorDefinition g) throws ChartException {
        if (!g.isSetTransparency() || g.getTransparency() != 0) {
            Color cBG = (Color)this._ids.getColor(g);
            Color cPreviousBG = this._gc.getBackground();
            this._gc.setBackground(cBG);
            R31Enhance.setAlpha(this._gc, g);
            this._gc.fillPath(path);
            cBG.dispose();
            this._gc.setBackground(cPreviousBG);
        }
    }

    private final void fillPathGradient(Path path, Gradient g, Rectangle r) throws ChartException {
        float y1;
        float y2;
        float x2;
        float x1;
        ColorDefinition cdStart = g.getStartColor();
        ColorDefinition cdEnd = g.getEndColor();
        double dAngleInDegrees = g.getDirection();
        if (dAngleInDegrees < -90.0 || dAngleInDegrees > 90.0) {
            throw new ChartException("org.eclipse.birt.chart.device.swt", 11, "SwtRendererImpl.exception.gradient.angle", new Object[]{new Double(dAngleInDegrees)}, Messages.getResourceBundle(this.getULocale()));
        }
        Color cPreviousFG = this._gc.getForeground();
        Color cPreviousBG = this._gc.getBackground();
        Color cFG = (Color)this._ids.getColor(cdStart);
        Color cBG = (Color)this._ids.getColor(cdEnd);
        if (dAngleInDegrees == 0.0) {
            x1 = r.x;
            x2 = r.x + r.width + 2;
            y1 = y2 = (float)r.y;
        } else if (dAngleInDegrees == 90.0) {
            x1 = x2 = (float)r.x;
            y1 = r.y + r.height + 2;
            y2 = r.y;
        } else if (dAngleInDegrees == -90.0) {
            x1 = x2 = (float)r.x;
            y1 = r.y;
            y2 = r.y + r.height + 2;
        } else if (dAngleInDegrees > 0.0) {
            x1 = r.x;
            y1 = r.y + r.height;
            x2 = r.x + r.width + 2;
            y2 = r.y;
        } else {
            x1 = r.x;
            y1 = r.y;
            x2 = r.x + r.width;
            y2 = r.y + r.height;
        }
        this._gc.setForeground(cFG);
        this._gc.setBackground(cBG);
        R31Enhance.setAlpha(this._gc, g);
        Pattern pattern = new Pattern(this._gc.getDevice(), x1, y1, x2, y2, cFG, cdStart.getTransparency(), cBG, cdEnd.getTransparency());
        this._gc.setBackgroundPattern(pattern);
        this._gc.fillPath(path);
        this._gc.setForeground(cPreviousFG);
        this._gc.setBackground(cPreviousBG);
        cFG.dispose();
        cBG.dispose();
        pattern.dispose();
    }

    private final void fillPathImage(Path path, Image g) throws ChartException {
        org.eclipse.swt.graphics.Image img = null;
        if (g instanceof EmbeddedImage) {
            try {
                String imageData = ((EmbeddedImage)g).getData();
                if (imageData != null) {
                    ByteArrayInputStream bis = new ByteArrayInputStream(Base64.decodeBase64((byte[])((EmbeddedImage)g).getData().getBytes()));
                    img = new org.eclipse.swt.graphics.Image(((SwtDisplayServer)this._ids).getDevice(), (InputStream)bis);
                }
                img = new org.eclipse.swt.graphics.Image(((SwtDisplayServer)this._ids).getDevice(), 10, 10);
            }
            catch (Exception ilex) {
                throw new ChartException("org.eclipse.birt.chart.device.swt", 11, (Throwable)ilex);
            }
        } else {
            String sUrl = g.getURL();
            try {
                img = (org.eclipse.swt.graphics.Image)this._ids.loadImage(SecurityUtil.newURL((String)sUrl));
            }
            catch (MalformedURLException muex) {
                throw new ChartException("org.eclipse.birt.chart.device.swt", 11, (Throwable)muex);
            }
        }
        Pattern pattern = new Pattern(this._gc.getDevice(), img);
        this._gc.setBackgroundPattern(pattern);
        this._gc.fillPath(path);
        pattern.dispose();
        img.dispose();
    }

    public void enableInteraction(InteractionEvent iev) throws ChartException {
        if (this._iun == null) {
            logger.log(1, Messages.getString("SwtRendererImpl.exception.missing.component.interaction", this.getULocale()));
            return;
        }
        Trigger[] tga = iev.getTriggers();
        if (tga == null) {
            return;
        }
        Region clipping = new Region();
        this._gc.getClipping(clipping);
        PrimitiveRenderEvent pre = iev.getHotSpot();
        if (pre instanceof PolygonRenderEvent) {
            Location[] loa = ((PolygonRenderEvent)pre).getPoints();
            int i = 0;
            while (i < tga.length) {
                TriggerCondition tc = tga[i].getCondition();
                List<RegionAction> al = this._lhmAllTriggers.get(tc);
                if (al == null) {
                    al = new ArrayList<RegionAction>(4);
                    this._lhmAllTriggers.put(tc, al);
                }
                RegionAction ra = new RegionAction(iev.getStructureSource(), loa, tga[i].getAction(), this.dTranslateX, this.dTranslateY, this.dScale, clipping);
                ra.setCursor(iev.getCursor());
                al.add(ra);
                ++i;
            }
        } else if (pre instanceof RectangleRenderEvent) {
            Bounds bo = ((RectangleRenderEvent)pre).getBounds();
            int i = 0;
            while (i < tga.length) {
                TriggerCondition tc = tga[i].getCondition();
                List<RegionAction> al = this._lhmAllTriggers.get(tc);
                if (al == null) {
                    al = new ArrayList<RegionAction>(4);
                    this._lhmAllTriggers.put(tc, al);
                }
                RegionAction ra = new RegionAction(iev.getStructureSource(), bo, tga[i].getAction(), this.dTranslateX, this.dTranslateY, this.dScale, clipping);
                ra.setCursor(iev.getCursor());
                al.add(ra);
                ++i;
            }
        } else if (pre instanceof OvalRenderEvent) {
            Bounds boEllipse = ((OvalRenderEvent)pre).getBounds();
            int i = 0;
            while (i < tga.length) {
                TriggerCondition tc = tga[i].getCondition();
                List<RegionAction> al = this._lhmAllTriggers.get(tc);
                if (al == null) {
                    al = new ArrayList<RegionAction>(4);
                    this._lhmAllTriggers.put(tc, al);
                }
                RegionAction ra = new RegionAction(iev.getStructureSource(), boEllipse, tga[i].getAction(), this.dTranslateX, this.dTranslateY, this.dScale, clipping);
                ra.setCursor(iev.getCursor());
                al.add(ra);
                ++i;
            }
        } else if (pre instanceof ArcRenderEvent) {
            ArcRenderEvent are = (ArcRenderEvent)pre;
            Bounds boEllipse = are.getEllipseBounds();
            double dStart = are.getStartAngle();
            double dExtent = are.getAngleExtent();
            int iArcType = are.getStyle();
            int i = 0;
            while (i < tga.length) {
                TriggerCondition tc = tga[i].getCondition();
                List<RegionAction> al = this._lhmAllTriggers.get(tc);
                if (al == null) {
                    al = new ArrayList<RegionAction>(4);
                    this._lhmAllTriggers.put(tc, al);
                }
                RegionAction ra = new RegionAction(iev.getStructureSource(), boEllipse, dStart, dExtent, iArcType == 3, tga[i].getAction(), this.dTranslateX, this.dTranslateY, this.dScale, clipping);
                ra.setCursor(iev.getCursor());
                al.add(ra);
                ++i;
            }
        } else if (pre instanceof AreaRenderEvent) {
            Bounds bo = ((AreaRenderEvent)pre).getBounds();
            int i = 0;
            while (i < tga.length) {
                TriggerCondition tc = tga[i].getCondition();
                List<RegionAction> al = this._lhmAllTriggers.get(tc);
                if (al == null) {
                    al = new ArrayList<RegionAction>(4);
                    this._lhmAllTriggers.put(tc, al);
                }
                RegionAction ra = new RegionAction(iev.getStructureSource(), bo, tga[i].getAction(), this.dTranslateX, this.dTranslateY, this.dScale, clipping);
                ra.setCursor(iev.getCursor());
                al.add(ra);
                ++i;
            }
        }
        clipping.dispose();
    }

    public void drawArea(AreaRenderEvent are) throws ChartException {
        this.iv.modifyEvent((PrimitiveRenderEvent)are);
        LineAttributes lia = are.getOutline();
        if (!this.validateLineAttributes(are.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), are.getBackground(), this._ids);
        if (cFG == null) {
            return;
        }
        Path gp = new Path(((SwtDisplayServer)this._ids).getDevice());
        int i = 0;
        while (i < are.getElementCount()) {
            PrimitiveRenderEvent pre = are.getElement(i);
            if (pre instanceof ArcRenderEvent) {
                ArcRenderEvent acre = (ArcRenderEvent)pre;
                gp.addArc((float)acre.getTopLeft().getX(), (float)acre.getTopLeft().getY(), (float)acre.getWidth(), (float)acre.getHeight(), (float)acre.getStartAngle(), (float)acre.getAngleExtent());
            } else if (pre instanceof LineRenderEvent) {
                LineRenderEvent lre = (LineRenderEvent)pre;
                gp.moveTo((float)lre.getStart().getX(), (float)lre.getStart().getY());
                gp.lineTo((float)lre.getEnd().getX(), (float)lre.getEnd().getY());
            }
            ++i;
        }
        int iOldLineStyle = this._gc.getLineStyle();
        int iOldLineWidth = this._gc.getLineWidth();
        int iLineStyle = 1;
        switch (lia.getStyle().getValue()) {
            case 2: {
                iLineStyle = 3;
                break;
            }
            case 3: {
                iLineStyle = 4;
                break;
            }
            case 1: {
                iLineStyle = 2;
            }
        }
        this._gc.setLineStyle(iLineStyle);
        this._gc.setLineWidth(lia.getThickness());
        this._gc.setForeground(cFG);
        R31Enhance.setAlpha(this._gc, lia.getColor());
        this._gc.drawPath(gp);
        this._gc.setLineStyle(iOldLineStyle);
        this._gc.setLineWidth(iOldLineWidth);
        gp.dispose();
        cFG.dispose();
    }

    public void fillArea(AreaRenderEvent are) throws ChartException {
        this.iv.modifyEvent((PrimitiveRenderEvent)are);
        Fill flBackground = this.validateMultipleFill(are.getBackground());
        if (this.isFullTransparent(flBackground)) {
            return;
        }
        Path pt = new Path(((SwtDisplayServer)this._ids).getDevice());
        int i = 0;
        while (i < are.getElementCount()) {
            PrimitiveRenderEvent pre = are.getElement(i);
            if (pre instanceof ArcRenderEvent) {
                ArcRenderEvent acre = (ArcRenderEvent)pre;
                pt.addArc((float)acre.getTopLeft().getX(), (float)acre.getTopLeft().getY(), (float)acre.getWidth(), (float)acre.getHeight(), (float)acre.getStartAngle(), (float)acre.getAngleExtent());
            } else if (pre instanceof LineRenderEvent) {
                LineRenderEvent lre = (LineRenderEvent)pre;
                if (i == 0) {
                    pt.moveTo((float)lre.getStart().getX(), (float)lre.getStart().getY());
                }
                pt.lineTo((float)lre.getEnd().getX(), (float)lre.getEnd().getY());
            }
            ++i;
        }
        try {
            if (flBackground instanceof ColorDefinition) {
                this.fillPathColor(pt, (ColorDefinition)flBackground);
            } else if (flBackground instanceof Gradient) {
                Bounds bo = are.getBounds();
                Rectangle r = new Rectangle((int)((bo.getLeft() + this.dTranslateX) * this.dScale), (int)((bo.getTop() + this.dTranslateY) * this.dScale), (int)(bo.getWidth() * this.dScale), (int)(bo.getHeight() * this.dScale));
                this.fillPathGradient(pt, (Gradient)flBackground, r);
            } else if (flBackground instanceof Image) {
                this.fillPathImage(pt, (Image)flBackground);
            }
        }
        finally {
            pt.dispose();
        }
    }

    public void drawOval(OvalRenderEvent ore) throws ChartException {
        this.iv.modifyEvent((PrimitiveRenderEvent)ore);
        LineAttributes lia = ore.getOutline();
        if (!this.validateLineAttributes(ore.getSource(), lia)) {
            return;
        }
        Color cFG = (Color)this.validateEdgeColor(lia.getColor(), ore.getBackground(), this._ids);
        if (cFG == null) {
            return;
        }
        int iOldLineStyle = this._gc.getLineStyle();
        int iOldLineWidth = this._gc.getLineWidth();
        int iLineStyle = 1;
        switch (lia.getStyle().getValue()) {
            case 2: {
                iLineStyle = 3;
                break;
            }
            case 3: {
                iLineStyle = 4;
                break;
            }
            case 1: {
                iLineStyle = 2;
            }
        }
        this._gc.setLineStyle(iLineStyle);
        this._gc.setLineWidth(lia.getThickness());
        Bounds bo = ore.getBounds();
        this._gc.setForeground(cFG);
        R31Enhance.setAlpha(this._gc, lia.getColor());
        this._gc.drawOval((int)((bo.getLeft() + this.dTranslateX) * this.dScale), (int)((bo.getTop() + this.dTranslateY) * this.dScale), (int)(bo.getWidth() * this.dScale), (int)(bo.getHeight() * this.dScale));
        this._gc.setLineStyle(iOldLineStyle);
        this._gc.setLineWidth(iOldLineWidth);
        cFG.dispose();
    }

    public void fillOval(OvalRenderEvent ore) throws ChartException {
        this.iv.modifyEvent((PrimitiveRenderEvent)ore);
        Fill flBackground = this.validateMultipleFill(ore.getBackground());
        if (this.isFullTransparent(flBackground)) {
            return;
        }
        Bounds bo = ore.getBounds();
        Rectangle r = new Rectangle((int)((bo.getLeft() + this.dTranslateX) * this.dScale), (int)((bo.getTop() + this.dTranslateY) * this.dScale), (int)(bo.getWidth() * this.dScale), (int)(bo.getHeight() * this.dScale));
        Path pt = new Path(((SwtDisplayServer)this._ids).getDevice());
        pt.addArc((float)r.x, (float)r.y, (float)r.width, (float)r.height, 0.0f, 360.0f);
        try {
            if (flBackground instanceof ColorDefinition) {
                this.fillPathColor(pt, (ColorDefinition)flBackground);
            } else if (flBackground instanceof Gradient) {
                this.fillPathGradient(pt, (Gradient)flBackground, r);
            } else if (flBackground instanceof Image) {
                this.fillPathImage(pt, (Image)flBackground);
            }
        }
        finally {
            pt.dispose();
        }
    }

    public void drawText(TextRenderEvent tre) throws ChartException {
        String fontName = this.convertFont(tre.getLabel().getCaption().getFont().getName());
        if (fontName != null) {
            tre.getLabel().getCaption().getFont().setName(fontName);
        }
        this.iv.modifyEvent((PrimitiveRenderEvent)tre);
        if (!tre.getLabel().isVisible()) {
            return;
        }
        switch (tre.getAction()) {
            case 0: {
                throw new ChartException("org.eclipse.birt.chart.device.swt", 11, "SwtRendererImpl.exception.unspecified.text.rendering.action", Messages.getResourceBundle(this.getULocale()));
            }
            case 1: {
                Location lo = tre.getLocation().copyInstance();
                lo.translate(this.dTranslateX, this.dTranslateY);
                lo.scale(this.dScale);
                this._tr.renderShadowAtLocation((IPrimitiveRenderer)this, tre.getTextPosition(), lo, tre.getLabel());
                break;
            }
            case 2: {
                Location lo = tre.getLocation().copyInstance();
                lo.translate(this.dTranslateX, this.dTranslateY);
                lo.scale(this.dScale);
                this._tr.renderTextAtLocation((IPrimitiveRenderer)this, tre.getTextPosition(), lo, tre.getLabel());
                break;
            }
            case 3: {
                Bounds bo = goFactory.copyOf(tre.getBlockBounds());
                bo.translate(this.dTranslateX, this.dTranslateY);
                bo.scale(this.dScale);
                this._tr.renderTextInBlock((IDeviceRenderer)this, bo, tre.getBlockAlignment(), tre.getLabel());
            }
        }
    }

    static final int[] getCoordinatesAsInts(Location[] la, int iRoundingStyle, double dTranslateX, double dTranslateY, double dScale) {
        return SwtRendererImpl.convertDoubleToInt(SwtRendererImpl.getDoubleCoordinatesAsInts(la, iRoundingStyle, dTranslateX, dTranslateY, dScale));
    }

    static final double[] getDoubleCoordinatesAsInts(Location[] la, int iRoundingStyle, double dTranslateX, double dTranslateY, double dScale) {
        double[] iaXY;
        block3: {
            int n;
            block2: {
                n = la.length * 2;
                iaXY = new double[n];
                if (iRoundingStyle != 1) break block2;
                int i = 0;
                while (i < n / 2) {
                    iaXY[2 * i] = Math.ceil((la[i].getX() + dTranslateX) * dScale);
                    iaXY[2 * i + 1] = Math.ceil((la[i].getY() + dTranslateY) * dScale);
                    ++i;
                }
                break block3;
            }
            if (iRoundingStyle != 2) break block3;
            int i = 0;
            while (i < n / 2) {
                iaXY[2 * i] = (la[i].getX() + dTranslateX) * dScale;
                iaXY[2 * i + 1] = (la[i].getY() + dTranslateY) * dScale;
                ++i;
            }
        }
        return iaXY;
    }

    static final float[] convertDoubleToFloat(double[] da) {
        if (da == null) {
            return null;
        }
        float[] fa = new float[da.length];
        int i = 0;
        while (i < fa.length) {
            fa[i] = (float)da[i];
            ++i;
        }
        return fa;
    }

    static final int[] convertDoubleToInt(double[] da) {
        if (da == null) {
            return null;
        }
        int[] fa = new int[da.length];
        int i = 0;
        while (i < fa.length) {
            fa[i] = (int)da[i];
            ++i;
        }
        return fa;
    }

    public void applyTransformation(TransformationEvent tev) throws ChartException {
        switch (tev.getTransform()) {
            case 2: {
                this.dTranslateX += tev.getTranslateX();
                this.dTranslateY += tev.getTranslateY();
                break;
            }
            case 4: {
                this.dRotateInDegrees += tev.getRotation();
                break;
            }
            case 1: {
                this.dScale *= tev.getScale();
                ((SwtDisplayServer)this._ids).setScale(this.dScale);
            }
        }
    }

    public void before() throws ChartException {
        this.cleanUpTriggers();
    }

    public void after() throws ChartException {
    }

    private void cleanUpTriggers() {
        for (List<RegionAction> ralist : this._lhmAllTriggers.values()) {
            if (ralist == null) continue;
            for (RegionAction ra : ralist) {
                ra.dispose();
            }
        }
        this._lhmAllTriggers.clear();
    }

    public void dispose() {
        Object obj;
        this.cleanUpTriggers();
        if (this._iun != null && (obj = this._iun.peerInstance()) instanceof Composite) {
            Composite jc = (Composite)obj;
            if (this._eh != null) {
                if (!jc.isDisposed()) {
                    jc.removeMouseListener((MouseListener)this._eh);
                    jc.removeMouseMoveListener((MouseMoveListener)this._eh);
                    jc.removeMouseTrackListener((MouseTrackListener)this._eh);
                    jc.removeKeyListener((KeyListener)this._eh);
                    jc.removeFocusListener((FocusListener)this._eh);
                }
                this._eh.dispose();
                this._eh = null;
            }
        }
    }

    public final void setProperty(String sProperty, Object oValue) {
        if (sProperty.equals("device.component")) {
            this._iun = (IUpdateNotifier)oValue;
            this.iv.reset();
            this.iv.setUpdateNotifier(this._iun);
            this.cleanUpTriggers();
            Object obj = this._iun.peerInstance();
            if (obj instanceof Composite) {
                Composite jc = (Composite)obj;
                if (this._eh != null) {
                    jc.removeMouseListener((MouseListener)this._eh);
                    jc.removeMouseMoveListener((MouseMoveListener)this._eh);
                    jc.removeMouseTrackListener((MouseTrackListener)this._eh);
                    jc.removeKeyListener((KeyListener)this._eh);
                    jc.removeFocusListener((FocusListener)this._eh);
                    this._eh.dispose();
                }
                this._eh = new SwtEventHandler(this.iv, this._lhmAllTriggers, this._iun, this.getULocale());
                jc.addMouseListener((MouseListener)this._eh);
                jc.addMouseMoveListener((MouseMoveListener)this._eh);
                jc.addMouseTrackListener((MouseTrackListener)this._eh);
                jc.addKeyListener((KeyListener)this._eh);
                jc.addFocusListener((FocusListener)this._eh);
            }
        } else if (sProperty.equals("device.output.context")) {
            this._gc = (GC)oValue;
            if (R31Enhance.isR31Available()) {
                Region rg = new Region();
                this._gc.getClipping(rg);
                R31Enhance.setAdvanced(this._gc, true, rg);
                R31Enhance.setAntialias(this._gc, 1);
                R31Enhance.setTextAntialias(this._gc, 1);
                rg.dispose();
            }
            this._ids.setGraphicsContext((Object)this._gc);
            logger.log(1, Messages.getString("SwtRendererImpl.info.graphics.context", new Object[]{this._gc.getClass().getName(), this._gc}, this.getULocale()));
        } else if (sProperty.equals("device.resolution")) {
            this.getDisplayServer().setDpiResolution(((Integer)oValue).intValue());
        }
    }

    protected static final Bounds normalizeBounds(Bounds bo) {
        if (bo.getHeight() < 0.0) {
            bo.setTop(bo.getTop() + bo.getHeight());
            bo.setHeight(-bo.getHeight());
        }
        if (bo.getWidth() < 0.0) {
            bo.setLeft(bo.getLeft() + bo.getWidth());
            bo.setWidth(-bo.getWidth());
        }
        return bo;
    }

    protected String convertFont(String fontFamily) {
        return FontUtil.getFontFamily((String)fontFamily);
    }
}

