/***********************************************************************
 * Copyright (c) 2004 Actuate Corporation.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 * Actuate Corporation - initial API and implementation
 ***********************************************************************/

package org.eclipse.birt.chart.model.impl;

import org.eclipse.birt.chart.model.*;

import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.ModelFactory;
import org.eclipse.birt.chart.model.ModelPackage;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;

import org.eclipse.emf.ecore.impl.EFactoryImpl;

import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;

/**
 * <!-- begin-user-doc --> An implementation of the model <b>Factory </b>. <!--
 * end-user-doc -->
 * @generated
 */
public class ModelFactoryImpl extends EFactoryImpl implements ModelFactory
{

	/**
	 * Creates the default factory implementation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static ModelFactory init( )
	{
		try
		{
			ModelFactory theModelFactory = (ModelFactory) EPackage.Registry.INSTANCE.getEFactory( "http://www.birt.eclipse.org/ChartModel" ); //$NON-NLS-1$ 
			if ( theModelFactory != null )
			{
				return theModelFactory;
			}
		}
		catch ( Exception exception )
		{
			EcorePlugin.INSTANCE.log( exception );
		}
		return new ModelFactoryImpl( );
	}

	/**
	 * Creates an instance of the factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * @generated
	 */
	public ModelFactoryImpl( )
	{
		super( );
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public EObject create( EClass eClass )
	{
		switch ( eClass.getClassifierID( ) )
		{
			case ModelPackage.CHART :
				return createChart( );
			case ModelPackage.CHART_WITH_AXES :
				return createChartWithAxes( );
			case ModelPackage.CHART_WITHOUT_AXES :
				return createChartWithoutAxes( );
			case ModelPackage.DIAL_CHART :
				return createDialChart( );
			default :
				throw new IllegalArgumentException( "The class '" + eClass.getName( ) + "' is not a valid classifier" ); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object createFromString( EDataType eDataType, String initialValue )
	{
		switch ( eDataType.getClassifierID( ) )
		{
			case ModelPackage.COVERAGE_TYPE :
				return createCoverageTypeFromString( eDataType, initialValue );
			case ModelPackage.COVERAGE_TYPE_OBJECT :
				return createCoverageTypeObjectFromString( eDataType,
						initialValue );
			default :
				throw new IllegalArgumentException( "The datatype '" + eDataType.getName( ) + "' is not a valid classifier" ); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public String convertToString( EDataType eDataType, Object instanceValue )
	{
		switch ( eDataType.getClassifierID( ) )
		{
			case ModelPackage.COVERAGE_TYPE :
				return convertCoverageTypeToString( eDataType, instanceValue );
			case ModelPackage.COVERAGE_TYPE_OBJECT :
				return convertCoverageTypeObjectToString( eDataType,
						instanceValue );
			default :
				throw new IllegalArgumentException( "The datatype '" + eDataType.getName( ) + "' is not a valid classifier" ); //$NON-NLS-1$ //$NON-NLS-2$
		}
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public Chart createChart( )
	{
		ChartImpl chart = new ChartImpl( );
		return chart;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ChartWithAxes createChartWithAxes( )
	{
		ChartWithAxesImpl chartWithAxes = new ChartWithAxesImpl( );
		return chartWithAxes;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ChartWithoutAxes createChartWithoutAxes( )
	{
		ChartWithoutAxesImpl chartWithoutAxes = new ChartWithoutAxesImpl( );
		return chartWithoutAxes;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public DialChart createDialChart( )
	{
		DialChartImpl dialChart = new DialChartImpl( );
		return dialChart;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Double createCoverageTypeFromString( EDataType eDataType,
			String initialValue )
	{
		return (Double) XMLTypeFactory.eINSTANCE.createFromString( XMLTypePackage.Literals.DOUBLE,
				initialValue );
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertCoverageTypeToString( EDataType eDataType,
			Object instanceValue )
	{
		return XMLTypeFactory.eINSTANCE.convertToString( XMLTypePackage.Literals.DOUBLE,
				instanceValue );
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public Double createCoverageTypeObjectFromString( EDataType eDataType,
			String initialValue )
	{
		return createCoverageTypeFromString( ModelPackage.Literals.COVERAGE_TYPE,
				initialValue );
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public String convertCoverageTypeObjectToString( EDataType eDataType,
			Object instanceValue )
	{
		return convertCoverageTypeToString( ModelPackage.Literals.COVERAGE_TYPE,
				instanceValue );
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @generated
	 */
	public ModelPackage getModelPackage( )
	{
		return (ModelPackage) getEPackage( );
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * @deprecated
	 * @generated
	 */
	@Deprecated
	public static ModelPackage getPackage( )
	{
		return ModelPackage.eINSTANCE;
	}

} // ModelFactoryImpl
