/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.designer.ui.actions;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.birt.report.designer.core.model.SessionHandleAdapter;
import org.eclipse.birt.report.designer.internal.ui.util.Policy;
import org.eclipse.birt.report.designer.internal.ui.util.UIUtil;
import org.eclipse.birt.report.designer.nls.Messages;
import org.eclipse.birt.report.designer.ui.ReportPlugin;
import org.eclipse.birt.report.designer.ui.util.UIHelper;
import org.eclipse.birt.report.engine.api.EngineConfig;
import org.eclipse.birt.report.engine.api.ReportEngine;
import org.eclipse.birt.report.model.api.ModuleHandle;
import org.eclipse.birt.report.viewer.utilities.WebViewer;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate;
import org.eclipse.ui.forms.editor.FormEditor;

public class PreviewToolbarMenuAction
implements IWorkbenchWindowPulldownDelegate {
    private static Map typeMap = new HashMap();
    public static final String TYPE_DOC = "doc";
    public static final String TYPE_HTML = "html";
    public static final String TYPE_PDF = "pdf";
    public static final String TYPE_PPT = "ppt";
    public static final String TYPE_PS = "postscript";
    public static final String TYPE_XLS = "xls";
    public static final String TYPE_DOCX = "docx";
    public static final String TYPE_PPTX = "pptx";
    public static final String TYPE_XHTML = "xhtml";
    public static final String IMG_FILE_DEFAULT = "icons/etool16/preview.gif";
    public static final String IMG_FILE_WEB = "icons/etool16/preview.gif";
    public static final String IMG_FILE_DOC = "icons/etool16/preview_doc.gif";
    public static final String IMG_FILE_HTML = "icons/etool16/preview_html.gif";
    public static final String IMG_FILE_PDF = "icons/etool16/preview_pdf.gif";
    public static final String IMG_FILE_PPT = "icons/etool16/preview_ppt.gif";
    public static final String IMG_FILE_PS = "icons/etool16/preview_ps.gif";
    public static final String IMG_FILE_XLS = "icons/etool16/preview_xls.gif";
    public static final String IMG_FILE_DOCX = "icons/etool16/preview_docx.gif";
    public static final String IMG_FILE_PPTX = "icons/etool16/preview_pptx.gif";
    public static final String IMG_FILE_XHTML = "icons/etool16/preview_xhtml.gif";

    static {
        typeMap.put(TYPE_DOC, IMG_FILE_DOC);
        typeMap.put(TYPE_HTML, IMG_FILE_HTML);
        typeMap.put(TYPE_PDF, IMG_FILE_PDF);
        typeMap.put(TYPE_PPT, IMG_FILE_PPT);
        typeMap.put(TYPE_PS, IMG_FILE_PS);
        typeMap.put(TYPE_XLS, IMG_FILE_XLS);
        typeMap.put(TYPE_DOCX, IMG_FILE_DOCX);
        typeMap.put(TYPE_PPTX, IMG_FILE_PPTX);
        typeMap.put(TYPE_XHTML, IMG_FILE_XHTML);
    }

    public Menu getMenu(Control parent) {
        ReportEngine engine = new ReportEngine(new EngineConfig());
        Object[] supportedFormats = engine.getSupportedFormats();
        Arrays.sort(supportedFormats);
        Menu menu = new Menu(parent);
        MenuItem previewWebViewer = new MenuItem(menu, 8);
        previewWebViewer.setText("&1 " + Messages.getString((String)"designer.preview.previewaction.label.webviewer"));
        previewWebViewer.setImage(UIHelper.getImage("icons/etool16/preview.gif"));
        previewWebViewer.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreviewToolbarMenuAction.this.preview(PreviewToolbarMenuAction.TYPE_HTML, true);
            }
        });
        int i = 0;
        while (i < supportedFormats.length) {
            Object format = supportedFormats[i];
            MenuItem previewOption = new MenuItem(menu, 8);
            String indexPrefix = i > 7 ? " " : "&" + (i + 2);
            previewOption.setText(String.valueOf(indexPrefix) + " " + Messages.getFormattedString((String)"designer.preview.previewaction.label", (Object[])new Object[]{((String)format).toUpperCase()}));
            if (typeMap.containsKey(format)) {
                previewOption.setImage(UIHelper.getImage((String)typeMap.get(format)));
            } else {
                previewOption.setImage(UIHelper.getImage("icons/etool16/preview.gif"));
            }
            previewOption.addSelectionListener((SelectionListener)new SelectionAdapter((String)format){
                private final /* synthetic */ String val$format;
                {
                    this.val$format = string;
                }

                public void widgetSelected(SelectionEvent e) {
                    PreviewToolbarMenuAction.this.preview(this.val$format, false);
                }
            });
            ++i;
        }
        return menu;
    }

    public void init(IWorkbenchWindow window) {
    }

    public void dispose() {
    }

    public void run(IAction action) {
        if (Policy.TRACING_ACTIONS) {
            System.out.println("Preview action >> Run ...");
        }
        this.preview(TYPE_HTML, true);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        action.setEnabled(this.isEnable());
    }

    protected boolean prePreview() {
        System.clearProperty("TransientSecurityID");
        System.clearProperty("MaxDataSetRows");
        System.clearProperty("MaxCubeRowLevels");
        System.clearProperty("MaxCubeColumnLevels");
        return true;
    }

    protected void preview(String format, boolean allowPage) {
        if (!this.prePreview()) {
            return;
        }
        FormEditor editor = UIUtil.getActiveReportEditor((boolean)false);
        ModuleHandle model = SessionHandleAdapter.getInstance().getReportDesignHandle();
        if (!UIUtil.canPreviewWithErrors((ModuleHandle)model)) {
            return;
        }
        if (editor != null && model.needsSave()) {
            editor.doSave(null);
        }
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("FORMAT_KEY", format);
        options.put("ALLOW_PAGE_KEY", allowPage);
        options.put("RESOURCE_FOLDER_KEY", ReportPlugin.getDefault().getResourceFolder());
        WebViewer.display((String)model.getFileName(), options);
    }

    private boolean isEnable() {
        IEditorPart editor = UIUtil.getActiveEditor((boolean)true);
        if (editor != null) {
            IContentType[] contentTypes;
            IContentType[] iContentTypeArray = contentTypes = Platform.getContentTypeManager().findContentTypesFor(editor.getEditorInput().getName());
            int n = contentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType type = iContentTypeArray[n2];
                if (type.getId().equals("org.eclipse.birt.report.designer.ui.editors.reportdesign") || type.getId().equals("org.eclipse.birt.report.designer.ui.editors.reporttemplate")) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

