/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.api;

import java.io.File;
import java.util.Map;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.core.framework.Platform;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.birt.data.engine.api.DataEngineContext;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.IBaseDataSourceDesign;
import org.eclipse.birt.data.engine.api.IDataEngineFactory;
import org.eclipse.birt.data.engine.api.IDataQueryDefinition;
import org.eclipse.birt.data.engine.api.IPreparedQuery;
import org.eclipse.birt.data.engine.api.IQueryDefinition;
import org.eclipse.birt.data.engine.api.IQueryResults;
import org.eclipse.birt.data.engine.api.IResultMetaData;
import org.eclipse.birt.data.engine.api.IShutdownListener;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.olap.api.IPreparedCubeQuery;
import org.eclipse.birt.data.engine.olap.api.query.ICubeQueryDefinition;
import org.eclipse.birt.data.engine.olap.api.query.ISubCubeQueryDefinition;
import org.mozilla.javascript.Scriptable;

public abstract class DataEngine {
    public static String DATASET_CACHE_OPTION = "org.eclipse.birt.data.engine.dataset.cache.option";
    public static String DATA_SET_CACHE_ROW_LIMIT = "org.eclipse.birt.data.cache.RowLimit";
    public static String MEMORY_BUFFER_SIZE = "org.eclipse.birt.data.query.ResultBufferSize";
    public static String DATA_SET_CACHE_DELTA_FILE = "org.eclipse.birt.data.cache.DeltaFile";
    public static String MEMORY_DATA_SET_CACHE = "org.eclipse.birt.data.cache.memory";
    public static String INCREMENTAL_CACHE_CONFIG = "org.eclipse.birt.data.cache.incremental.config";
    public static String CUBECURSOR_FETCH_LIMIT_ON_COLUMN_EDGE = "org.eclipse.birt.data.engine.olap.cursor.onColumn";
    public static String CUBECUSROR_FETCH_LIMIT_ON_ROW_EDGE = "org.eclipse.birt.data.engine.olap.cursor.onRow";
    public static String CUBECURSOR_FETCH_LIMIT_ON_LEVEL = "org.eclipse.birt.data.engine.olap.cursor.onLevel";
    public static String IN_MEMORY_CUBE_SIZE = "org.eclipse.birt.data.engine.cube.inmemory.size";

    public static DataEngine newDataEngine(DataEngineContext context) {
        try {
            return DataEngine.newDataEngine(null, context);
        }
        catch (BirtException e) {
            throw new RuntimeException(e);
        }
    }

    public static DataEngine newDataEngine(PlatformConfig platformConfig, DataEngineContext dataContext) throws BirtException {
        Platform.startup((PlatformConfig)platformConfig);
        Object factory = Platform.createFactoryObject((String)"org.eclipse.birt.data.DataEngineFactory");
        if (factory instanceof IDataEngineFactory) {
            return ((IDataEngineFactory)factory).createDataEngine(dataContext);
        }
        throw new DataException("load.factory.error");
    }

    public static DataEngine newDataEngine(Scriptable sharedScope) {
        try {
            return DataEngine.newDataEngine(DataEngineContext.newInstance(3, sharedScope, null, null));
        }
        catch (BirtException birtException) {
            return null;
        }
    }

    public static DataEngine newDataEngine(Scriptable sharedScope, File homeDir) {
        return DataEngine.newDataEngine(sharedScope);
    }

    public abstract IQueryResults getQueryResults(String var1) throws BirtException;

    public abstract void defineDataSource(IBaseDataSourceDesign var1) throws BirtException;

    public abstract void defineDataSet(IBaseDataSetDesign var1) throws BirtException;

    public abstract IResultMetaData getCachedDataSetMetaData(IBaseDataSourceDesign var1, IBaseDataSetDesign var2) throws BirtException;

    public abstract void clearCache(IBaseDataSourceDesign var1, IBaseDataSetDesign var2) throws BirtException;

    public abstract IPreparedQuery prepare(IQueryDefinition var1) throws BirtException;

    public abstract IPreparedQuery prepare(IQueryDefinition var1, Map var2) throws BirtException;

    public abstract void registerQueries(IDataQueryDefinition[] var1) throws DataException;

    public abstract void closeDataSource(String var1) throws BirtException;

    public abstract IPreparedCubeQuery prepare(ICubeQueryDefinition var1, Map var2) throws BirtException;

    public abstract IPreparedCubeQuery prepare(ISubCubeQueryDefinition var1, Map var2) throws BirtException;

    public abstract void addShutdownListener(IShutdownListener var1);

    public abstract void removeListener(IShutdownListener var1);

    public abstract void cancel();

    public abstract void shutdown();
}

