/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.engine.executor.dscache;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.birt.core.data.DataType;
import org.eclipse.birt.data.engine.api.IBaseDataSetDesign;
import org.eclipse.birt.data.engine.api.querydefn.ComputedColumn;
import org.eclipse.birt.data.engine.core.DataException;
import org.eclipse.birt.data.engine.executor.DataSetCacheManager;
import org.eclipse.birt.data.engine.executor.IDataSetCacheObject;
import org.eclipse.birt.data.engine.executor.ResultClass;
import org.eclipse.birt.data.engine.executor.ResultFieldMetadata;
import org.eclipse.birt.data.engine.executor.ResultObject;
import org.eclipse.birt.data.engine.executor.dscache.CacheUtilFactory;
import org.eclipse.birt.data.engine.executor.dscache.ILoadUtil;
import org.eclipse.birt.data.engine.executor.dscache.ISaveUtil;
import org.eclipse.birt.data.engine.impl.DataEngineSession;
import org.eclipse.birt.data.engine.impl.IIncreCacheDataSetDesign;
import org.eclipse.birt.data.engine.odaconsumer.ResultSet;
import org.eclipse.birt.data.engine.odi.ICustomDataSet;
import org.eclipse.birt.data.engine.odi.IDataSetPopulator;
import org.eclipse.birt.data.engine.odi.IResultClass;
import org.eclipse.birt.data.engine.odi.IResultObject;

public class DataSetResultCache {
    private IResultClass rsMeta;
    private ResultSet odaDataSet;
    private ICustomDataSet customDataSet;
    private IDataSetPopulator populator;
    private int cacheCount;
    private ISaveUtil saveUtil;
    private boolean isSaved;
    private ILoadUtil loadUtil;
    private boolean isLoad;
    private List addedTempComputedColumn;
    private int realColumnCount;
    private DataEngineSession session;
    private Integer increCacheMode;

    public DataSetResultCache(ResultSet odaDataSet, IResultClass rsMeta, DataEngineSession session) throws DataException {
        assert (odaDataSet != null);
        assert (rsMeta != null);
        this.odaDataSet = odaDataSet;
        this.init(rsMeta, session);
    }

    public DataSetResultCache(IDataSetPopulator populator, IResultClass rsMeta, DataEngineSession session) throws DataException {
        assert (populator != null);
        assert (rsMeta != null);
        this.populator = populator;
        this.init(rsMeta, session);
    }

    public DataSetResultCache(ICustomDataSet customDataSet, IResultClass rsMeta, DataEngineSession session) throws DataException {
        assert (customDataSet != null);
        assert (rsMeta != null);
        this.customDataSet = customDataSet;
        this.init(rsMeta, session);
    }

    private void init(IResultClass rsMeta, DataEngineSession session) throws DataException {
        this.rsMeta = DataSetResultCache.rebuildResultClass(rsMeta);
        this.isLoad = false;
        this.isSaved = false;
        this.session = session;
        this.cacheCount = this.getCacheCapability();
        this.populateCacheMode(session);
    }

    private static IResultClass rebuildResultClass(IResultClass meta) throws DataException {
        ArrayList<ResultFieldMetadata> projectedColumns = new ArrayList<ResultFieldMetadata>();
        int i = 1;
        while (i <= meta.getFieldCount()) {
            if (!meta.getFieldName(i).matches("\\Q_{$TEMP\\E.*\\d*\\Q$}_\\E")) {
                ResultFieldMetadata field = new ResultFieldMetadata(0, meta.getFieldName(i), meta.getFieldLabel(i), meta.getFieldValueClass(i), meta.getFieldNativeTypeName(i), meta.isCustomField(i));
                field.setAlias(meta.getFieldAlias(i));
                projectedColumns.add(field);
            }
            ++i;
        }
        ResultClass result = new ResultClass(projectedColumns);
        return result;
    }

    private void populateCacheMode(DataEngineSession session) {
        DataSetCacheManager cacheManager = session.getDataSetCacheManager();
        IBaseDataSetDesign dataSetDesign = cacheManager.getCurrentDataSetDesign();
        if (dataSetDesign instanceof IIncreCacheDataSetDesign) {
            IIncreCacheDataSetDesign icDataSetDesign = (IIncreCacheDataSetDesign)dataSetDesign;
            this.increCacheMode = new Integer(icDataSetDesign.getCacheMode());
        }
    }

    public DataSetResultCache(DataEngineSession session) {
        this.isLoad = true;
        this.isSaved = true;
        this.session = session;
        this.populateCacheMode(session);
    }

    public void setTempComputedColumn(List addedTempComputedColumn) {
        this.addedTempComputedColumn = addedTempComputedColumn;
    }

    public IResultObject fetch() throws DataException {
        if (this.increCacheMode != null) {
            return this.fetchFromCache();
        }
        if (!this.isLoad) {
            if (this.cacheCount <= 0) {
                return this.fetchFromDataSet();
            }
            return this.fetchFromCache();
        }
        return this.loadObject();
    }

    private IResultObject fetchFromCache() throws DataException {
        if (!this.isSaved) {
            this.cacheDataSet();
            this.isSaved = true;
        }
        return this.loadObject();
    }

    private void cacheDataSet() throws DataException {
        try {
            int index = 0;
            IResultObject resultObject = null;
            this.saveInit();
            do {
                if ((resultObject = this.fetchFromDataSet()) != null) {
                    this.saveUtil.saveObject(resultObject);
                    if (this.increCacheMode == null && ++index >= this.cacheCount) break;
                }
                if (!this.session.getStopSign().isStopped()) continue;
                this.removeCacheObject();
                break;
            } while (resultObject != null);
            this.saveClose();
        }
        catch (DataException de) {
            this.removeCacheObject();
            throw de;
        }
    }

    private void removeCacheObject() throws DataException {
        DataSetCacheManager dataSetCacheManager = this.getDataSetCacheManager();
        dataSetCacheManager.clearCache(dataSetCacheManager.getCurrentDataSourceDesign(), dataSetCacheManager.getCurrentDataSetDesign());
    }

    private IResultObject fetchFromDataSet() throws DataException {
        IResultObject resultObject = null;
        if (this.odaDataSet != null) {
            resultObject = this.odaDataSet.fetch();
        } else if (this.customDataSet != null) {
            resultObject = this.customDataSet.fetch();
        } else if (this.populator != null) {
            resultObject = this.populator.next();
        }
        return resultObject;
    }

    public IResultClass getResultClass() throws DataException {
        if (this.isLoad && this.rsMeta == null) {
            this.rsMeta = this.loadResultClass();
            if (this.addedTempComputedColumn != null && this.addedTempComputedColumn.size() > 0) {
                this.processResultClass();
            }
        }
        return this.rsMeta;
    }

    private void processResultClass() throws DataException {
        ArrayList<ResultFieldMetadata> metadataList = new ArrayList<ResultFieldMetadata>();
        this.realColumnCount = 0;
        ResultFieldMetadata metadata = null;
        int i = 0;
        i = 0;
        while (i < this.rsMeta.getFieldCount()) {
            if (!this.isTempComputedColumn(this.rsMeta.getFieldName(i + 1))) {
                metadata = new ResultFieldMetadata(0, this.rsMeta.getFieldName(i + 1), this.rsMeta.getFieldLabel(i + 1), this.rsMeta.getFieldValueClass(i + 1), this.rsMeta.getFieldNativeTypeName(i + 1), this.rsMeta.isCustomField(i + 1));
                metadata.setAlias(this.rsMeta.getFieldAlias(i + 1));
                metadataList.add(metadata);
                ++this.realColumnCount;
            }
            ++i;
        }
        ComputedColumn tempComputedColumn = null;
        i = 0;
        while (i < this.addedTempComputedColumn.size()) {
            tempComputedColumn = (ComputedColumn)this.addedTempComputedColumn.get(i);
            metadata = new ResultFieldMetadata(0, tempComputedColumn.getName(), null, DataType.getClass((int)tempComputedColumn.getDataType()), null, true);
            metadataList.add(metadata);
            ++i;
        }
        this.rsMeta = new ResultClass(metadataList);
    }

    private boolean isTempComputedColumn(String name) {
        return name.matches("\\Q_{$TEMP_GROUP_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_SORT_\\E\\d*\\Q$}_\\E") || name.matches("\\Q_{$TEMP_FILTER_\\E\\d*\\Q$}_\\E");
    }

    public void close() throws DataException {
        if (this.loadUtil != null) {
            this.loadUtil.close();
            this.loadUtil = null;
        }
    }

    private void saveInit() throws DataException {
        this.saveUtil = CacheUtilFactory.createSaveUtil(this.getCacheObject(), this.rsMeta, this.session);
    }

    private void saveClose() throws DataException {
        if (this.saveUtil != null) {
            this.saveUtil.close();
            this.saveUtil = null;
        }
    }

    private IResultObject loadObject() throws DataException {
        IResultObject cacheObject;
        if (this.loadUtil == null) {
            this.loadUtil = CacheUtilFactory.createLoadUtil(this.getCacheObject(), this.session);
        }
        IResultObject iResultObject = cacheObject = this.loadUtil == null ? null : this.loadUtil.loadObject();
        if (cacheObject == null) {
            return cacheObject;
        }
        if (this.addedTempComputedColumn != null && this.addedTempComputedColumn.size() > 0) {
            ResultObject resultObject = new ResultObject(this.getResultClass(), this.getAllObjects(cacheObject));
            return resultObject;
        }
        return cacheObject;
    }

    private Object[] getAllObjects(IResultObject cacheObject) throws DataException {
        Object[] objects = new Object[this.realColumnCount + this.addedTempComputedColumn.size()];
        int i = 0;
        while (i < this.realColumnCount) {
            objects[i] = cacheObject.getFieldValue(i + 1);
            ++i;
        }
        return objects;
    }

    private IResultClass loadResultClass() throws DataException {
        if (this.loadUtil == null) {
            this.loadUtil = CacheUtilFactory.createLoadUtil(this.getCacheObject(), this.session);
        }
        return this.loadUtil.loadResultClass();
    }

    private DataSetCacheManager getDataSetCacheManager() {
        return this.session.getDataSetCacheManager();
    }

    private int getCacheCapability() throws DataException {
        return this.getDataSetCacheManager().getCacheCapability();
    }

    private IDataSetCacheObject getCacheObject() throws DataException {
        return this.getDataSetCacheManager().getCacheObject();
    }
}

